/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.kyori.adventure.builder.AbstractBuilder;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.ComponentLike;
import me.extremall.advancedkits.libs.kyori.adventure.text.PatternReplacementResult;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextComponent;
import me.extremall.advancedkits.libs.kyori.adventure.text.TextReplacementConfigImpl;
import me.extremall.advancedkits.libs.kyori.adventure.util.Buildable;
import me.extremall.advancedkits.libs.kyori.adventure.util.IntFunction2;
import me.extremall.advancedkits.libs.kyori.examination.Examinable;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface TextReplacementConfig
extends Buildable<TextReplacementConfig, Builder>,
Examinable {
    @NotNull
    public static Builder builder() {
        return new TextReplacementConfigImpl.Builder();
    }

    @NotNull
    public Pattern matchPattern();

    @FunctionalInterface
    public static interface Condition {
        @NotNull
        public PatternReplacementResult shouldReplace(@NotNull MatchResult var1, int var2, int var3);
    }

    public static interface Builder
    extends AbstractBuilder<TextReplacementConfig>,
    Buildable.Builder<TextReplacementConfig> {
        @Contract(value="_ -> this")
        default public Builder matchLiteral(String string) {
            return this.match(Pattern.compile(string, 16));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder match(@NotNull @RegExp String string) {
            return this.match(Pattern.compile(string));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder match(@NotNull Pattern var1);

        @NotNull
        default public Builder once() {
            return this.times(1);
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder times(int n2) {
            return this.condition((int n3, int n4) -> {
                if (n4 < n2) {
                    return PatternReplacementResult.REPLACE;
                }
                return PatternReplacementResult.STOP;
            });
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder condition(@NotNull IntFunction2<PatternReplacementResult> intFunction2) {
            return this.condition((MatchResult matchResult, int n2, int n3) -> (PatternReplacementResult)((Object)((Object)intFunction2.apply(n2, n3))));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder condition(@NotNull Condition var1);

        @Contract(value="_ -> this")
        @NotNull
        default public Builder replacement(@NotNull String string) {
            Objects.requireNonNull(string, "replacement");
            return this.replacement((TextComponent.Builder builder) -> builder.content(string));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder replacement(@Nullable ComponentLike componentLike) {
            componentLike = ComponentLike.unbox(componentLike);
            return this.replacement((arg_0, arg_1) -> Builder.lambda$replacement$3((Component)componentLike, arg_0, arg_1));
        }

        @Contract(value="_ -> this")
        @NotNull
        default public Builder replacement(@NotNull Function<TextComponent.Builder, @Nullable ComponentLike> function) {
            Objects.requireNonNull(function, "replacement");
            return this.replacement((MatchResult matchResult, TextComponent.Builder builder) -> (ComponentLike)function.apply((TextComponent.Builder)builder));
        }

        @Contract(value="_ -> this")
        @NotNull
        public Builder replacement(@NotNull BiFunction<MatchResult, TextComponent.Builder, @Nullable ComponentLike> var1);

        private static /* synthetic */ ComponentLike lambda$replacement$3(Component component, MatchResult matchResult, TextComponent.Builder builder) {
            return component;
        }
    }
}

