/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.minimessage;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.Context;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.Tag;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ArgumentQueueImpl<T extends Tag.Argument>
implements ArgumentQueue {
    private final Context context;
    final List<T> args;
    private int ptr = 0;

    ArgumentQueueImpl(Context context, List<T> list) {
        this.context = context;
        this.args = list;
    }

    @NotNull
    public final T pop() {
        if (!this.hasNext()) {
            throw this.context.newException("Missing argument for this tag!", this);
        }
        return (T)((Tag.Argument)this.args.get(this.ptr++));
    }

    @NotNull
    public final T popOr(@NotNull String string) {
        Objects.requireNonNull(string, "errorMessage");
        if (!this.hasNext()) {
            throw this.context.newException(string, this);
        }
        return (T)((Tag.Argument)this.args.get(this.ptr++));
    }

    @NotNull
    public final T popOr(@NotNull Supplier<String> supplier) {
        Objects.requireNonNull(supplier, "errorMessage");
        if (!this.hasNext()) {
            throw this.context.newException(Objects.requireNonNull(supplier.get(), "errorMessage.get()"), this);
        }
        return (T)((Tag.Argument)this.args.get(this.ptr++));
    }

    @Nullable
    public final T peek() {
        if (this.hasNext()) {
            return (T)((Tag.Argument)this.args.get(this.ptr));
        }
        return null;
    }

    @Override
    public final boolean hasNext() {
        return this.ptr < this.args.size();
    }

    @Override
    public final void reset() {
        this.ptr = 0;
    }

    public final String toString() {
        return this.args.toString();
    }
}

