/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.standard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.text.format.TextColor;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.Context;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.Tag;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.resolver.ArgumentQueue;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.standard.AbstractColorChangingTag;
import me.extremall.advancedkits.libs.kyori.adventure.text.minimessage.tag.standard.ColorTagResolver;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

final class GradientTag
extends AbstractColorChangingTag {
    private static final String GRADIENT = "gradient";
    static final TagResolver RESOLVER = TagResolver.resolver("gradient", GradientTag::create);
    private int index = 0;
    private double multiplier = 1.0;
    private final TextColor[] colors;
    private @Range(from=-1L, to=1L) double phase;

    static Tag create(ArgumentQueue argumentQueue, Context context) {
        List<TextColor> list;
        double d2 = 0.0;
        if (argumentQueue.hasNext()) {
            list = new ArrayList();
            while (argumentQueue.hasNext()) {
                Object object;
                Tag.Argument argument = argumentQueue.pop();
                if (!argumentQueue.hasNext() && ((OptionalDouble)(object = argument.asDouble())).isPresent()) {
                    d2 = ((OptionalDouble)object).getAsDouble();
                    if (!(d2 < -1.0) && !(d2 > 1.0)) break;
                    throw context.newException(String.format("Gradient phase is out of range (%s). Must be in the range [-1.0, 1.0] (inclusive).", d2), argumentQueue);
                }
                object = ColorTagResolver.resolveColor(argument.value(), context);
                list.add((TextColor)object);
            }
            if (list.size() == 1) {
                throw context.newException("Invalid gradient, not enough colors. Gradients must have at least two colors.", argumentQueue);
            }
        } else {
            list = Collections.emptyList();
        }
        return new GradientTag(d2, list);
    }

    private GradientTag(double d2, List<TextColor> list) {
        this.colors = list.isEmpty() ? new TextColor[]{TextColor.color(0xFFFFFF), TextColor.color(0)} : list.toArray(new TextColor[0]);
        if (d2 < 0.0) {
            this.phase = d2 + 1.0;
            Collections.reverse(Arrays.asList(this.colors));
            return;
        }
        this.phase = d2;
    }

    @Override
    protected final void init() {
        this.multiplier = this.size() == 1 ? 0.0 : (double)(this.colors.length - 1) / (double)(this.size() - 1);
        this.phase *= (double)(this.colors.length - 1);
        this.index = 0;
    }

    @Override
    protected final void advanceColor() {
        ++this.index;
    }

    @Override
    protected final TextColor color() {
        double d2 = (double)this.index * this.multiplier + this.phase;
        int n2 = (int)Math.floor(d2);
        int n3 = (int)Math.ceil(d2) % this.colors.length;
        int n4 = n2 % this.colors.length;
        return TextColor.lerp((float)d2 - (float)n2, this.colors[n4], this.colors[n3]);
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase), ExaminableProperty.of("colors", this.colors));
    }

    @Override
    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (GradientTag)object;
        return this.index == ((GradientTag)object).index && this.phase == ((GradientTag)object).phase && Arrays.equals(this.colors, ((GradientTag)object).colors);
    }

    @Override
    public final int hashCode() {
        int n2 = Objects.hash(this.index, this.phase);
        n2 = n2 * 31 + Arrays.hashCode(this.colors);
        return n2;
    }
}

