/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.GsonBuilder;
import me.extremall.advancedkits.libs.gson.JsonElement;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.ComponentSerializerImpl;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.LegacyHoverEventSerializer;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.SerializerFactory;
import me.extremall.advancedkits.libs.kyori.adventure.util.Services;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class GsonComponentSerializerImpl
implements GsonComponentSerializer {
    private static final Optional<GsonComponentSerializer.Provider> SERVICE = Services.service(GsonComponentSerializer.Provider.class);
    static final Consumer<GsonComponentSerializer.Builder> BUILDER = SERVICE.map(GsonComponentSerializer.Provider::builder).orElseGet(() -> builder -> {});
    private final Gson serializer;
    private final UnaryOperator<GsonBuilder> populator;
    private final boolean downsampleColor;
    @Nullable
    private final LegacyHoverEventSerializer legacyHoverSerializer;
    private final boolean emitLegacyHover;

    GsonComponentSerializerImpl(boolean bl2, @Nullable LegacyHoverEventSerializer legacyHoverEventSerializer, boolean bl3) {
        this.downsampleColor = bl2;
        this.legacyHoverSerializer = legacyHoverEventSerializer;
        this.emitLegacyHover = bl3;
        this.populator = gsonBuilder -> {
            gsonBuilder.registerTypeAdapterFactory(new SerializerFactory(bl2, legacyHoverEventSerializer, bl3));
            return gsonBuilder;
        };
        this.serializer = ((GsonBuilder)this.populator.apply(new GsonBuilder().disableHtmlEscaping())).create();
    }

    @Override
    @NotNull
    public final Gson serializer() {
        return this.serializer;
    }

    @Override
    @NotNull
    public final UnaryOperator<GsonBuilder> populator() {
        return this.populator;
    }

    @Override
    @NotNull
    public final Component deserialize(@NotNull String string) {
        Component component = this.serializer().fromJson(string, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(string);
        }
        return component;
    }

    @Override
    @Nullable
    public final Component deserializeOr(@Nullable String object, @Nullable Component component) {
        if (object == null) {
            return component;
        }
        object = this.serializer().fromJson((String)object, Component.class);
        if (object == null) {
            return component;
        }
        return object;
    }

    @Override
    @NotNull
    public final String serialize(@NotNull Component component) {
        return this.serializer().toJson(component);
    }

    @Override
    @NotNull
    public final Component deserializeFromTree(@NotNull JsonElement jsonElement) {
        Component component = this.serializer().fromJson(jsonElement, Component.class);
        if (component == null) {
            throw ComponentSerializerImpl.notSureHowToDeserialize(jsonElement);
        }
        return component;
    }

    @Override
    @NotNull
    public final JsonElement serializeToTree(@NotNull Component component) {
        return this.serializer().toJsonTree(component);
    }

    @Override
    @NotNull
    public final GsonComponentSerializer.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static /* synthetic */ Optional access$000() {
        return SERVICE;
    }

    static final class BuilderImpl
    implements GsonComponentSerializer.Builder {
        private boolean downsampleColor = false;
        @Nullable
        private LegacyHoverEventSerializer legacyHoverSerializer;
        private boolean emitLegacyHover = false;

        BuilderImpl() {
            BUILDER.accept(this);
        }

        BuilderImpl(GsonComponentSerializerImpl gsonComponentSerializerImpl) {
            this();
            this.downsampleColor = gsonComponentSerializerImpl.downsampleColor;
            this.emitLegacyHover = gsonComponentSerializerImpl.emitLegacyHover;
            this.legacyHoverSerializer = gsonComponentSerializerImpl.legacyHoverSerializer;
        }

        @Override
        @NotNull
        public final GsonComponentSerializer.Builder downsampleColors() {
            this.downsampleColor = true;
            return this;
        }

        @Override
        @NotNull
        public final GsonComponentSerializer.Builder legacyHoverEventSerializer(@Nullable LegacyHoverEventSerializer legacyHoverEventSerializer) {
            this.legacyHoverSerializer = legacyHoverEventSerializer;
            return this;
        }

        @Override
        @NotNull
        public final GsonComponentSerializer.Builder emitLegacyHoverEvent() {
            this.emitLegacyHover = true;
            return this;
        }

        @Override
        @NotNull
        public final GsonComponentSerializer build() {
            if (this.legacyHoverSerializer == null) {
                if (this.downsampleColor) {
                    return Instances.LEGACY_INSTANCE;
                }
                return Instances.INSTANCE;
            }
            return new GsonComponentSerializerImpl(this.downsampleColor, this.legacyHoverSerializer, this.emitLegacyHover);
        }
    }

    static final class Instances {
        static final GsonComponentSerializer INSTANCE = GsonComponentSerializerImpl.access$000().map(GsonComponentSerializer.Provider::gson).orElseGet(() -> new GsonComponentSerializerImpl(false, null, false));
        static final GsonComponentSerializer LEGACY_INSTANCE = GsonComponentSerializerImpl.access$000().map(GsonComponentSerializer.Provider::gsonLegacy).orElseGet(() -> new GsonComponentSerializerImpl(true, null, true));

        Instances() {
        }
    }
}

