/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson;

import me.extremall.advancedkits.libs.gson.Gson;
import me.extremall.advancedkits.libs.gson.JsonParseException;
import me.extremall.advancedkits.libs.gson.TypeAdapter;
import me.extremall.advancedkits.libs.gson.stream.JsonReader;
import me.extremall.advancedkits.libs.gson.stream.JsonToken;
import me.extremall.advancedkits.libs.gson.stream.JsonWriter;
import me.extremall.advancedkits.libs.kyori.adventure.key.Key;
import me.extremall.advancedkits.libs.kyori.adventure.nbt.api.BinaryTagHolder;
import me.extremall.advancedkits.libs.kyori.adventure.text.event.HoverEvent;
import me.extremall.advancedkits.libs.kyori.adventure.text.serializer.gson.SerializerFactory;

final class ShowItemSerializer
extends TypeAdapter<HoverEvent.ShowItem> {
    static final String ID = "id";
    static final String COUNT = "count";
    static final String TAG = "tag";
    private final Gson gson;

    static TypeAdapter<HoverEvent.ShowItem> create(Gson gson) {
        return new ShowItemSerializer(gson).nullSafe();
    }

    private ShowItemSerializer(Gson gson) {
        this.gson = gson;
    }

    @Override
    public final HoverEvent.ShowItem read(JsonReader jsonReader) {
        jsonReader.beginObject();
        Key key = null;
        int n2 = 1;
        BinaryTagHolder binaryTagHolder = null;
        while (jsonReader.hasNext()) {
            Object object = jsonReader.nextName();
            if (object.equals(ID)) {
                key = (Key)this.gson.fromJson(jsonReader, SerializerFactory.KEY_TYPE);
                continue;
            }
            if (object.equals(COUNT)) {
                n2 = jsonReader.nextInt();
                continue;
            }
            if (object.equals(TAG)) {
                object = jsonReader.peek();
                if (object == JsonToken.STRING || object == JsonToken.NUMBER) {
                    binaryTagHolder = BinaryTagHolder.binaryTagHolder(jsonReader.nextString());
                    continue;
                }
                if (object == JsonToken.BOOLEAN) {
                    binaryTagHolder = BinaryTagHolder.binaryTagHolder(String.valueOf(jsonReader.nextBoolean()));
                    continue;
                }
                if (object == JsonToken.NULL) {
                    jsonReader.nextNull();
                    continue;
                }
                throw new JsonParseException("Expected tag to be a string");
            }
            jsonReader.skipValue();
        }
        if (key == null) {
            throw new JsonParseException("Not sure how to deserialize show_item hover event");
        }
        jsonReader.endObject();
        return HoverEvent.ShowItem.of(key, n2, binaryTagHolder);
    }

    @Override
    public final void write(JsonWriter jsonWriter, HoverEvent.ShowItem object) {
        jsonWriter.beginObject();
        jsonWriter.name(ID);
        this.gson.toJson((Object)((HoverEvent.ShowItem)object).item(), SerializerFactory.KEY_TYPE, jsonWriter);
        int n2 = ((HoverEvent.ShowItem)object).count();
        if (n2 != 1) {
            jsonWriter.name(COUNT);
            jsonWriter.value(n2);
        }
        if ((object = ((HoverEvent.ShowItem)object).nbt()) != null) {
            jsonWriter.name(TAG);
            jsonWriter.value(object.string());
        }
        jsonWriter.endObject();
    }
}

