/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.kyori.adventure.title;

import java.time.Duration;
import java.util.Objects;
import java.util.stream.Stream;
import me.extremall.advancedkits.libs.kyori.adventure.internal.Internals;
import me.extremall.advancedkits.libs.kyori.adventure.text.Component;
import me.extremall.advancedkits.libs.kyori.adventure.title.Title;
import me.extremall.advancedkits.libs.kyori.adventure.title.TitlePart;
import me.extremall.advancedkits.libs.kyori.examination.ExaminableProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;

final class TitleImpl
implements Title {
    private final Component title;
    private final Component subtitle;
    @Nullable
    private final Title.Times times;

    TitleImpl(@NotNull Component component, @NotNull Component component2, @Nullable Title.Times times) {
        this.title = Objects.requireNonNull(component, "title");
        this.subtitle = Objects.requireNonNull(component2, "subtitle");
        this.times = times;
    }

    @Override
    @NotNull
    public final Component title() {
        return this.title;
    }

    @Override
    @NotNull
    public final Component subtitle() {
        return this.subtitle;
    }

    @Override
    @Nullable
    public final Title.Times times() {
        return this.times;
    }

    @Override
    public final <T> @UnknownNullability T part(@NotNull TitlePart<T> titlePart) {
        Objects.requireNonNull(titlePart, "part");
        if (titlePart == TitlePart.TITLE) {
            return (T)this.title;
        }
        if (titlePart == TitlePart.SUBTITLE) {
            return (T)this.subtitle;
        }
        if (titlePart == TitlePart.TIMES) {
            return (T)this.times;
        }
        throw new IllegalArgumentException("Don't know what " + titlePart + " is.");
    }

    public final boolean equals(@Nullable Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        object = (TitleImpl)object;
        return this.title.equals(((TitleImpl)object).title) && this.subtitle.equals(((TitleImpl)object).subtitle) && Objects.equals(this.times, ((TitleImpl)object).times);
    }

    public final int hashCode() {
        int n2 = this.title.hashCode();
        n2 = n2 * 31 + this.subtitle.hashCode();
        n2 = n2 * 31 + Objects.hashCode(this.times);
        return n2;
    }

    @Override
    @NotNull
    public final Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("title", this.title), ExaminableProperty.of("subtitle", this.subtitle), ExaminableProperty.of("times", this.times));
    }

    public final String toString() {
        return Internals.toString(this);
    }

    static class TimesImpl
    implements Title.Times {
        private final Duration fadeIn;
        private final Duration stay;
        private final Duration fadeOut;

        TimesImpl(@NotNull Duration duration, @NotNull Duration duration2, @NotNull Duration duration3) {
            this.fadeIn = Objects.requireNonNull(duration, "fadeIn");
            this.stay = Objects.requireNonNull(duration2, "stay");
            this.fadeOut = Objects.requireNonNull(duration3, "fadeOut");
        }

        @Override
        @NotNull
        public Duration fadeIn() {
            return this.fadeIn;
        }

        @Override
        @NotNull
        public Duration stay() {
            return this.stay;
        }

        @Override
        @NotNull
        public Duration fadeOut() {
            return this.fadeOut;
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof TimesImpl)) {
                return false;
            }
            object = (TimesImpl)object;
            return this.fadeIn.equals(((TimesImpl)object).fadeIn) && this.stay.equals(((TimesImpl)object).stay) && this.fadeOut.equals(((TimesImpl)object).fadeOut);
        }

        public int hashCode() {
            int n2 = this.fadeIn.hashCode();
            n2 = n2 * 31 + this.stay.hashCode();
            n2 = n2 * 31 + this.fadeOut.hashCode();
            return n2;
        }

        @Override
        @NotNull
        public Stream<? extends ExaminableProperty> examinableProperties() {
            return Stream.of(ExaminableProperty.of("fadeIn", this.fadeIn), ExaminableProperty.of("stay", this.stay), ExaminableProperty.of("fadeOut", this.fadeOut));
        }

        public String toString() {
            return Internals.toString(this);
        }
    }
}

