/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.libby;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import me.extremall.advancedkits.libs.libby.Library;
import me.extremall.advancedkits.libs.libby.classloader.IsolatedClassLoader;
import me.extremall.advancedkits.libs.libby.logging.LogLevel;
import me.extremall.advancedkits.libs.libby.logging.Logger;
import me.extremall.advancedkits.libs.libby.logging.adapters.LogAdapter;
import me.extremall.advancedkits.libs.libby.relocation.Relocation;
import me.extremall.advancedkits.libs.libby.relocation.RelocationHelper;

public abstract class LibraryManager {
    protected final Logger logger;
    protected final Path saveDirectory;
    private final Set<String> repositories = new LinkedHashSet<String>();
    private RelocationHelper relocator;
    private final Map<String, IsolatedClassLoader> isolatedLibraries = new HashMap<String, IsolatedClassLoader>();

    @Deprecated
    protected LibraryManager(LogAdapter logAdapter, Path path) {
        this.logger = new Logger(Objects.requireNonNull(logAdapter, "logAdapter"));
        this.saveDirectory = Objects.requireNonNull(path, "dataDirectory").toAbsolutePath().resolve("lib");
    }

    protected LibraryManager(LogAdapter logAdapter, Path path, String string) {
        this.logger = new Logger(Objects.requireNonNull(logAdapter, "logAdapter"));
        this.saveDirectory = Objects.requireNonNull(path, "dataDirectory").toAbsolutePath().resolve(Objects.requireNonNull(string, "directoryName"));
    }

    protected abstract void addToClasspath(Path var1);

    protected void addToIsolatedClasspath(Library object, Path path) {
        object = (object = ((Library)object).getId()) != null ? this.isolatedLibraries.computeIfAbsent((String)object, string -> new IsolatedClassLoader(new URL[0])) : new IsolatedClassLoader(new URL[0]);
        ((IsolatedClassLoader)object).addPath(path);
    }

    public IsolatedClassLoader getIsolatedClassLoaderOf(String string) {
        return this.isolatedLibraries.get(string);
    }

    public LogLevel getLogLevel() {
        return this.logger.getLevel();
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logger.setLevel(logLevel);
    }

    public Collection<String> getRepositories() {
        LinkedList<String> linkedList;
        Set<String> set = this.repositories;
        synchronized (set) {
            linkedList = new LinkedList<String>(this.repositories);
        }
        return Collections.unmodifiableList(linkedList);
    }

    public void addRepository(String string) {
        string = Objects.requireNonNull(string, "url").endsWith("/") ? string : string + '/';
        Set<String> set = this.repositories;
        synchronized (set) {
            this.repositories.add(string);
            return;
        }
    }

    public void addMavenLocal() {
        this.addRepository(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".m2/repository").toUri().toString());
    }

    public void addMavenCentral() {
        this.addRepository("https://repo1.maven.org/maven2/");
    }

    public void addSonatype() {
        this.addRepository("https://oss.sonatype.org/content/groups/public/");
    }

    public void addJCenter() {
        this.addRepository("https://jcenter.bintray.com/");
    }

    public void addJitPack() {
        this.addRepository("https://jitpack.io/");
    }

    public Collection<String> resolveLibrary(Library library) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Objects.requireNonNull(library, "library").getUrls());
        for (String string : library.getRepositories()) {
            linkedHashSet.add(string + library.getPath());
        }
        for (String string : this.getRepositories()) {
            linkedHashSet.add(string + library.getPath());
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] downloadLibrary(String string) {
        try {
            Object object = new URL(Objects.requireNonNull(string, "url")).openConnection();
            ((URLConnection)object).setConnectTimeout(5000);
            ((URLConnection)object).setReadTimeout(5000);
            ((URLConnection)object).setRequestProperty("User-Agent", "libby/1.2.0");
            InputStream inputStream = ((URLConnection)object).getInputStream();
            try {
                byte[] throwable2 = new byte[8192];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                try {
                    int throwable;
                    while ((throwable = inputStream.read(throwable2)) != -1) {
                        byteArrayOutputStream.write(throwable2, 0, throwable);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.logger.warn("Download timed out: " + ((URLConnection)object).getURL());
                    object = null;
                    if (inputStream == null) return object;
                    inputStream.close();
                    return object;
                }
                this.logger.info("Downloaded library " + ((URLConnection)object).getURL());
                object = byteArrayOutputStream.toByteArray();
                return object;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(malformedURLException);
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            if (iOException instanceof FileNotFoundException) {
                this.logger.debug("File not found: " + string);
                return null;
            }
            if (iOException2 instanceof SocketTimeoutException) {
                this.logger.debug("Connect timed out: " + string);
                return null;
            }
            if (iOException2 instanceof UnknownHostException) {
                this.logger.debug("Unknown host: " + string);
                return null;
            }
            this.logger.debug("Unexpected IOException", iOException2);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Path downloadLibrary(Library library) {
        Path path;
        block18: {
            Object object;
            block17: {
                Path path2 = this.saveDirectory.resolve(Objects.requireNonNull(library, "library").getPath());
                if (Files.exists(path2, new LinkOption[0])) {
                    return path2;
                }
                Collection<String> collection = this.resolveLibrary(library);
                if (collection.isEmpty()) {
                    throw new RuntimeException("Library '" + library + "' couldn't be resolved, add a repository");
                }
                MessageDigest messageDigest = null;
                if (library.hasChecksum()) {
                    try {
                        messageDigest = MessageDigest.getInstance("SHA-256");
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new RuntimeException(noSuchAlgorithmException);
                    }
                }
                path = path2.resolveSibling(path2.getFileName() + ".tmp");
                path.toFile().deleteOnExit();
                try {
                    Files.createDirectories(path2.getParent(), new FileAttribute[0]);
                    for (String string : collection) {
                        byte[] byArray = this.downloadLibrary(string);
                        if (byArray == null) continue;
                        if (messageDigest != null && !Arrays.equals(object = messageDigest.digest(byArray), library.getChecksum())) {
                            this.logger.warn("*** INVALID CHECKSUM ***");
                            this.logger.warn(" Library :  " + library);
                            this.logger.warn(" URL :  " + string);
                            this.logger.warn(" Expected :  " + Base64.getEncoder().encodeToString(library.getChecksum()));
                            this.logger.warn(" Actual :  " + Base64.getEncoder().encodeToString((byte[])object));
                            continue;
                        }
                        Files.write(path, byArray, new OpenOption[0]);
                        Files.move(path, path2, new CopyOption[0]);
                        object = path2;
                        break block17;
                    }
                    break block18;
                }
                catch (IOException iOException) {
                    try {
                        throw new UncheckedIOException(iOException);
                    }
                    catch (Throwable throwable) {
                        try {
                            Files.deleteIfExists(path);
                            throw throwable;
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
            }
            try {
                Files.deleteIfExists(path);
                return object;
            }
            catch (IOException iOException) {}
            return object;
        }
        try {
            Files.deleteIfExists(path);
            throw new RuntimeException("Failed to download library '" + library + "'");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to download library '" + library + "'");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path relocate(Path path, String object, Collection<Relocation> collection) {
        void var3_4;
        Path path2;
        Objects.requireNonNull(path, "in");
        Objects.requireNonNull(path2, "out");
        Objects.requireNonNull(var3_4, "relocations");
        path2 = this.saveDirectory.resolve((String)((Object)path2));
        if (Files.exists(path2, new LinkOption[0])) {
            return path2;
        }
        Path path3 = path2.resolveSibling(path2.getFileName() + ".tmp");
        path3.toFile().deleteOnExit();
        Object object2 = this;
        synchronized (object2) {
            if (this.relocator == null) {
                this.relocator = new RelocationHelper(this);
            }
        }
        try {
            this.relocator.relocate(path, path3, (Collection<Relocation>)var3_4);
            Files.move(path3, path2, new CopyOption[0]);
            this.logger.info("Relocations applied to " + this.saveDirectory.getParent().relativize(path));
            object2 = path2;
        }
        catch (IOException object22) {
            try {
                throw new UncheckedIOException(object22);
            }
            catch (Throwable throwable) {
                try {
                    Files.deleteIfExists(path3);
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
        }
        try {
            Files.deleteIfExists(path3);
            return object2;
        }
        catch (IOException iOException) {}
        return object2;
    }

    public void loadLibrary(Library library) {
        Path path = this.downloadLibrary(Objects.requireNonNull(library, "library"));
        if (library.hasRelocations()) {
            path = this.relocate(path, library.getRelocatedPath(), library.getRelocations());
        }
        if (library.isIsolatedLoad()) {
            this.addToIsolatedClasspath(library, path);
            return;
        }
        this.addToClasspath(path);
    }
}

