/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.nbtapi;

import com.mojang.authlib.GameProfile;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import me.extremall.advancedkits.libs.nbtapi.NBTCompound;
import me.extremall.advancedkits.libs.nbtapi.NBTContainer;
import me.extremall.advancedkits.libs.nbtapi.NBTEntity;
import me.extremall.advancedkits.libs.nbtapi.NBTGameProfile;
import me.extremall.advancedkits.libs.nbtapi.NBTItem;
import me.extremall.advancedkits.libs.nbtapi.NBTTileEntity;
import me.extremall.advancedkits.libs.nbtapi.NbtApiException;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadWriteItemNBT;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadWriteNBT;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadableItemNBT;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadableNBT;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadableNBTList;
import me.extremall.advancedkits.libs.nbtapi.wrapper.NBTProxy;
import me.extremall.advancedkits.libs.nbtapi.wrapper.ProxyBuilder;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.inventory.ItemStack;

public class NBT {
    private NBT() {
    }

    public static ReadableNBT readNbt(ItemStack itemStack) {
        return new NBTItem(itemStack.clone(), false, true, false);
    }

    public static <T> T get(ItemStack object, Function<ReadableItemNBT, T> function) {
        if ((function = function.apply((ReadableItemNBT)(object = new NBTItem((ItemStack)object, false, true, false)))) instanceof ReadableNBT || function instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        ((NBTItem)object).setClosed();
        return (T)function;
    }

    public static void get(ItemStack object, Consumer<ReadableItemNBT> consumer) {
        object = new NBTItem((ItemStack)object, false, true, false);
        consumer.accept((ReadableItemNBT)object);
        ((NBTItem)object).setClosed();
    }

    public static <T> T get(Entity object, Function<ReadableNBT, T> function) {
        if ((function = function.apply((ReadableNBT)(object = new NBTEntity((Entity)object, true)))) instanceof ReadableNBT || function instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        ((NBTEntity)object).setClosed();
        return (T)function;
    }

    public static void get(Entity object, Consumer<ReadableNBT> consumer) {
        object = new NBTEntity((Entity)object, true);
        consumer.accept((ReadableNBT)object);
        ((NBTEntity)object).setClosed();
    }

    public static <T> T get(BlockState object, Function<ReadableNBT, T> function) {
        if ((function = function.apply((ReadableNBT)(object = new NBTTileEntity((BlockState)object, true)))) instanceof ReadableNBT || function instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        ((NBTTileEntity)object).setClosed();
        return (T)function;
    }

    public static void get(BlockState object, Consumer<ReadableNBT> consumer) {
        object = new NBTTileEntity((BlockState)object, true);
        consumer.accept((ReadableNBT)object);
        ((NBTTileEntity)object).setClosed();
    }

    public static <T> T getPersistentData(Entity object, Function<ReadableNBT, T> function) {
        if ((object = function.apply(new NBTEntity((Entity)object).getPersistentDataContainer())) instanceof ReadableNBT || object instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        return (T)object;
    }

    public static <T> T getPersistentData(BlockState object, Function<ReadableNBT, T> function) {
        if ((object = function.apply(new NBTTileEntity((BlockState)object).getPersistentDataContainer())) instanceof ReadableNBT || object instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        return (T)object;
    }

    public static <T> T modify(ItemStack object, Function<ReadWriteItemNBT, T> function) {
        object = new NBTItem((ItemStack)object, false, false, true);
        function = function.apply((ReadWriteItemNBT)object);
        ((NBTItem)object).finalizeChanges();
        if (function instanceof ReadableNBT || function instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        ((NBTItem)object).setClosed();
        return (T)function;
    }

    public static void modify(ItemStack object, Consumer<ReadWriteItemNBT> consumer) {
        object = new NBTItem((ItemStack)object, false, false, true);
        consumer.accept((ReadWriteItemNBT)object);
        ((NBTItem)object).finalizeChanges();
        ((NBTItem)object).setClosed();
    }

    public static <T> T modify(Entity object, Function<ReadWriteNBT, T> function) {
        object = new NBTEntity((Entity)object);
        NBTContainer nBTContainer = new NBTContainer(((NBTEntity)object).getCompound());
        function = function.apply(nBTContainer);
        ((NBTEntity)object).setCompound(nBTContainer.getCompound());
        if (function instanceof ReadableNBT || function instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        ((NBTEntity)object).setClosed();
        return (T)function;
    }

    public static void modify(Entity object, Consumer<ReadWriteNBT> consumer) {
        object = new NBTEntity((Entity)object);
        NBTContainer nBTContainer = new NBTContainer(((NBTEntity)object).getCompound());
        consumer.accept(nBTContainer);
        ((NBTEntity)object).setCompound(nBTContainer.getCompound());
        ((NBTEntity)object).setClosed();
    }

    public static <T> T modifyPersistentData(Entity object, Function<ReadWriteNBT, T> function) {
        if ((object = function.apply(new NBTEntity((Entity)object).getPersistentDataContainer())) instanceof ReadableNBT || object instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        return (T)object;
    }

    public static void modifyPersistentData(Entity entity, Consumer<ReadWriteNBT> consumer) {
        consumer.accept(new NBTEntity(entity).getPersistentDataContainer());
    }

    public static <T> T modify(BlockState object, Function<ReadWriteNBT, T> function) {
        object = new NBTTileEntity((BlockState)object);
        NBTContainer nBTContainer = new NBTContainer(((NBTTileEntity)object).getCompound());
        function = function.apply(nBTContainer);
        ((NBTTileEntity)object).setCompound(nBTContainer.getCompound());
        if (function instanceof ReadableNBT || function instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        ((NBTTileEntity)object).setClosed();
        return (T)function;
    }

    public static void modify(BlockState object, Consumer<ReadWriteNBT> consumer) {
        object = new NBTTileEntity((BlockState)object);
        NBTContainer nBTContainer = new NBTContainer(((NBTTileEntity)object).getCompound());
        consumer.accept(nBTContainer);
        ((NBTTileEntity)object).setCompound(nBTContainer.getCompound());
        ((NBTTileEntity)object).setClosed();
    }

    public static <T> T modifyPersistentData(BlockState object, Function<ReadWriteNBT, T> function) {
        if ((object = function.apply(new NBTTileEntity((BlockState)object).getPersistentDataContainer())) instanceof ReadableNBT || object instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        return (T)object;
    }

    public static void modifyPersistentData(BlockState blockState, Consumer<ReadWriteNBT> consumer) {
        consumer.accept(new NBTTileEntity(blockState).getPersistentDataContainer());
    }

    public static ReadWriteNBT gameProfileToNBT(GameProfile gameProfile) {
        return NBTGameProfile.toNBT(gameProfile);
    }

    public static GameProfile gameProfileFromNBT(ReadableNBT readableNBT) {
        return NBTGameProfile.fromNBT((NBTCompound)readableNBT);
    }

    public static ReadWriteNBT itemStackToNBT(ItemStack itemStack) {
        return NBTItem.convertItemtoNBT(itemStack);
    }

    @Nullable
    public static ItemStack itemStackFromNBT(ReadableNBT readableNBT) {
        return NBTItem.convertNBTtoItem((NBTCompound)readableNBT);
    }

    public static ReadWriteNBT itemStackArrayToNBT(ItemStack[] itemStackArray) {
        return NBTItem.convertItemArraytoNBT(itemStackArray);
    }

    @Nullable
    public static ItemStack[] itemStackArrayFromNBT(ReadableNBT readableNBT) {
        return NBTItem.convertNBTtoItemArray((NBTCompound)readableNBT);
    }

    public static ReadWriteNBT createNBTObject() {
        return new NBTContainer();
    }

    public static ReadWriteNBT parseNBT(String string) {
        return new NBTContainer(string);
    }

    public static <T extends NBTProxy> T readNbt(ItemStack itemStack, Class<T> clazz) {
        return new ProxyBuilder<T>(new NBTItem(itemStack, false, true, false), clazz).readOnly().build();
    }

    public static <T extends NBTProxy> T readNbt(Entity entity, Class<T> clazz) {
        return new ProxyBuilder<T>(new NBTEntity(entity, true), clazz).readOnly().build();
    }

    public static <T extends NBTProxy> T readNbt(BlockState blockState, Class<T> clazz) {
        return new ProxyBuilder<T>(new NBTTileEntity(blockState, true), clazz).readOnly().build();
    }

    public static <T, X extends NBTProxy> T modify(ItemStack object, Class<X> clazz, Function<X, T> function) {
        object = new NBTItem((ItemStack)object, false, false, true);
        clazz = function.apply(new ProxyBuilder<X>((ReadWriteNBT)object, clazz).build());
        ((NBTItem)object).finalizeChanges();
        if (clazz instanceof ReadableNBT || clazz instanceof ReadableNBTList) {
            throw new NbtApiException("Tried returning part of the NBT to outside of the NBT scope!");
        }
        ((NBTItem)object).setClosed();
        return (T)clazz;
    }

    public static <X extends NBTProxy> void modify(ItemStack object, Class<X> clazz, Consumer<X> consumer) {
        object = new NBTItem((ItemStack)object, false, false, true);
        consumer.accept(new ProxyBuilder<X>((ReadWriteNBT)object, clazz).build());
        ((NBTItem)object).finalizeChanges();
        ((NBTItem)object).setClosed();
    }

    public static <X extends NBTProxy> void modify(Entity object, Class<X> clazz, Consumer<X> consumer) {
        object = new NBTEntity((Entity)object);
        NBTContainer nBTContainer = new NBTContainer(((NBTEntity)object).getCompound());
        consumer.accept(new ProxyBuilder<X>(nBTContainer, clazz).build());
        ((NBTEntity)object).setCompound(nBTContainer.getCompound());
        nBTContainer.setClosed();
    }

    public static <T, X extends NBTProxy> T modify(Entity object, Class<X> clazz, Function<X, T> function) {
        object = new NBTEntity((Entity)object);
        NBTContainer nBTContainer = new NBTContainer(((NBTEntity)object).getCompound());
        clazz = function.apply(new ProxyBuilder<X>(nBTContainer, clazz).build());
        ((NBTEntity)object).setCompound(nBTContainer.getCompound());
        nBTContainer.setClosed();
        return (T)clazz;
    }

    public static <X extends NBTProxy> void modify(BlockState object, Class<X> clazz, Consumer<X> consumer) {
        object = new NBTTileEntity((BlockState)object);
        NBTContainer nBTContainer = new NBTContainer(((NBTTileEntity)object).getCompound());
        consumer.accept(new ProxyBuilder<X>(nBTContainer, clazz).build());
        ((NBTTileEntity)object).setCompound(nBTContainer);
        nBTContainer.setClosed();
    }

    public static <T, X extends NBTProxy> T modify(BlockState object, Class<X> clazz, Function<X, T> function) {
        object = new NBTTileEntity((BlockState)object);
        NBTContainer nBTContainer = new NBTContainer(((NBTTileEntity)object).getCompound());
        clazz = function.apply(new ProxyBuilder<X>(nBTContainer, clazz).build());
        ((NBTTileEntity)object).setCompound(nBTContainer);
        nBTContainer.setClosed();
        return (T)clazz;
    }
}

