/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.nbtapi;

import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import me.extremall.advancedkits.libs.nbtapi.NBTCompoundList;
import me.extremall.advancedkits.libs.nbtapi.NBTItem;
import me.extremall.advancedkits.libs.nbtapi.NBTList;
import me.extremall.advancedkits.libs.nbtapi.NBTListCompound;
import me.extremall.advancedkits.libs.nbtapi.NBTReflectionUtil;
import me.extremall.advancedkits.libs.nbtapi.NBTType;
import me.extremall.advancedkits.libs.nbtapi.NbtApiException;
import me.extremall.advancedkits.libs.nbtapi.iface.NBTHandler;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadWriteNBT;
import me.extremall.advancedkits.libs.nbtapi.iface.ReadableNBT;
import me.extremall.advancedkits.libs.nbtapi.utils.CheckUtil;
import me.extremall.advancedkits.libs.nbtapi.utils.MinecraftVersion;
import me.extremall.advancedkits.libs.nbtapi.utils.PathUtil;
import me.extremall.advancedkits.libs.nbtapi.utils.nmsmappings.Forge1710Mappings;
import me.extremall.advancedkits.libs.nbtapi.utils.nmsmappings.ReflectionMethod;
import org.bukkit.inventory.ItemStack;

public class NBTCompound
implements ReadWriteNBT {
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private String compundName;
    private NBTCompound parent;
    private final boolean readOnly;
    private Object readOnlyCache;

    protected NBTCompound(NBTCompound nBTCompound, String string) {
        this(nBTCompound, string, false);
    }

    protected NBTCompound(NBTCompound nBTCompound, String string, boolean bl2) {
        this.compundName = string;
        this.parent = nBTCompound;
        this.readOnly = bl2;
    }

    protected Lock getReadLock() {
        return this.readLock;
    }

    protected Lock getWriteLock() {
        return this.writeLock;
    }

    protected void saveCompound() {
        if (this.parent != null) {
            this.parent.saveCompound();
        }
    }

    protected void setResolvedObject(Object object) {
        if (this.isClosed()) {
            throw new NbtApiException("Tried using closed NBT data!");
        }
        if (this.readOnly) {
            this.readOnlyCache = object;
        }
    }

    protected void setClosed() {
        if (this.parent != null) {
            this.parent.setClosed();
        }
    }

    protected boolean isClosed() {
        if (this.parent != null) {
            return this.parent.isClosed();
        }
        return false;
    }

    protected boolean isReadOnly() {
        return this.readOnly;
    }

    protected Object getResolvedObject() {
        if (this.isClosed()) {
            throw new NbtApiException("Tried using closed NBT data!");
        }
        if (this.readOnlyCache != null) {
            return this.readOnlyCache;
        }
        Object object = this.getCompound();
        if (object == null) {
            return null;
        }
        if (!NBTReflectionUtil.valideCompound(this)) {
            throw new NbtApiException("The Compound wasn't able to be linked back to the root!");
        }
        object = NBTReflectionUtil.gettoCompount(object, this);
        if (this.readOnly) {
            this.readOnlyCache = object;
        }
        return object;
    }

    public String getName() {
        return this.compundName;
    }

    public Object getCompound() {
        return this.parent.getCompound();
    }

    protected void setCompound(Object object) {
        this.parent.setCompound(object);
    }

    public NBTCompound getParent() {
        return this.parent;
    }

    public void mergeCompound(NBTCompound nBTCompound) {
        if (nBTCompound == null) {
            return;
        }
        try {
            this.writeLock.lock();
            NBTReflectionUtil.mergeOtherNBTCompound(this, nBTCompound);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void mergeCompound(ReadableNBT readableNBT) {
        if (readableNBT instanceof NBTCompound) {
            this.mergeCompound((NBTCompound)readableNBT);
            return;
        }
        throw new NbtApiException("Unknown NBT object: " + readableNBT);
    }

    @Override
    public void setString(String string, String string2) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_STRING, string, string2);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public String getString(String string) {
        try {
            this.readLock.lock();
            string = (String)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_STRING, string);
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setInteger(String string, Integer n2) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INT, string, n2);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Integer getInteger(String object) {
        try {
            this.readLock.lock();
            object = (Integer)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INT, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setDouble(String string, Double d2) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_DOUBLE, string, d2);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Double getDouble(String object) {
        try {
            this.readLock.lock();
            object = (Double)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_DOUBLE, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setByte(String string, Byte by) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTE, string, by);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Byte getByte(String object) {
        try {
            this.readLock.lock();
            object = (Byte)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTE, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setShort(String string, Short s2) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_SHORT, string, s2);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Short getShort(String object) {
        try {
            this.readLock.lock();
            object = (Short)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_SHORT, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setLong(String string, Long l2) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_LONG, string, l2);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Long getLong(String object) {
        try {
            this.readLock.lock();
            object = (Long)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_LONG, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setFloat(String string, Float f2) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_FLOAT, string, f2);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Float getFloat(String object) {
        try {
            this.readLock.lock();
            object = (Float)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_FLOAT, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setByteArray(String string, byte[] byArray) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BYTEARRAY, string, byArray);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public byte[] getByteArray(String object) {
        try {
            this.readLock.lock();
            object = (byte[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BYTEARRAY, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setIntArray(String string, int[] nArray) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_INTARRAY, string, nArray);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public int[] getIntArray(String object) {
        try {
            this.readLock.lock();
            object = (int[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_INTARRAY, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setLongArray(String string, long[] lArray) {
        CheckUtil.assertAvailable(MinecraftVersion.MC1_16_R1);
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_LONGARRAY, string, lArray);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long[] getLongArray(String object) {
        CheckUtil.assertAvailable(MinecraftVersion.MC1_16_R1);
        try {
            this.readLock.lock();
            object = (long[])NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_LONGARRAY, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setBoolean(String string, Boolean bl2) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_BOOLEAN, string, bl2);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    protected void set(String string, Object object) {
        NBTReflectionUtil.set(this, string, object);
        this.saveCompound();
    }

    @Override
    public Boolean getBoolean(String object) {
        try {
            this.readLock.lock();
            object = (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_BOOLEAN, (String)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Deprecated
    public void setObject(String string, Object object) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.setObject(this, string, object);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Deprecated
    public <T> T getObject(String string, Class<T> clazz) {
        try {
            this.readLock.lock();
            string = NBTReflectionUtil.getObject(this, string, clazz);
            return (T)string;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setItemStack(String string, ItemStack itemStack) {
        try {
            this.writeLock.lock();
            this.removeKey(string);
            this.addCompound(string).mergeCompound(NBTItem.convertItemtoNBT(itemStack));
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ItemStack getItemStack(String object) {
        try {
            this.readLock.lock();
            object = this.getCompound((String)object);
            if (object == null) {
                object = null;
                return object;
            }
            object = NBTItem.convertNBTtoItem((NBTCompound)object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setItemStackArray(String string, ItemStack[] itemStackArray) {
        try {
            this.writeLock.lock();
            this.removeKey(string);
            this.addCompound(string).mergeCompound(NBTItem.convertItemArraytoNBT(itemStackArray));
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public ItemStack[] getItemStackArray(String itemStackArray) {
        try {
            this.readLock.lock();
            itemStackArray = this.getCompound((String)itemStackArray);
            if (itemStackArray == null) {
                itemStackArray = null;
                return itemStackArray;
            }
            itemStackArray = NBTItem.convertNBTtoItemArray((NBTCompound)itemStackArray);
            return itemStackArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setUUID(String string, UUID uUID) {
        try {
            this.writeLock.lock();
            if (MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1)) {
                NBTReflectionUtil.setData(this, ReflectionMethod.COMPOUND_SET_UUID, string, uUID);
            } else {
                this.setString(string, uUID.toString());
            }
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public UUID getUUID(String object) {
        block6: {
            block5: {
                try {
                    this.readLock.lock();
                    if (!MinecraftVersion.isAtLeastVersion(MinecraftVersion.MC1_16_R1) || this.getType((String)object) != NBTType.NBTTagIntArray) break block5;
                    object = (UUID)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_UUID, (String)object);
                    this.readLock.unlock();
                    return object;
                }
                catch (Throwable throwable) {
                    this.readLock.unlock();
                    throw throwable;
                }
            }
            if (this.getType((String)object) != NBTType.NBTTagString) break block6;
            try {
                object = UUID.fromString(this.getString((String)object));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                object = null;
                this.readLock.unlock();
                return object;
            }
            this.readLock.unlock();
            return object;
        }
        object = null;
        this.readLock.unlock();
        return object;
    }

    @Deprecated
    public Boolean hasKey(String string) {
        return this.hasTag(string);
    }

    @Override
    public boolean hasTag(String object) {
        try {
            this.readLock.lock();
            object = (Boolean)NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_HAS_KEY, (String)object);
            if (object == null) {
                return false;
            }
            boolean bl2 = (Boolean)object;
            return bl2;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void removeKey(String string) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.remove(this, string);
            this.saveCompound();
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public Set<String> getKeys() {
        try {
            this.readLock.lock();
            HashSet<String> hashSet = new HashSet<String>(NBTReflectionUtil.getKeys(this));
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public NBTCompound addCompound(String object) {
        try {
            this.writeLock.lock();
            if (this.getType((String)object) == NBTType.NBTTagCompound) {
                object = this.getCompound((String)object);
                return object;
            }
            NBTReflectionUtil.addNBTTagCompound(this, (String)object);
            object = this.getCompound((String)object);
            if (object == null) {
                throw new NbtApiException("Error while adding Compound, got null!");
            }
            this.saveCompound();
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NBTCompound getCompound(String object) {
        block4: {
            try {
                this.readLock.lock();
                if (this.getType((String)object) == NBTType.NBTTagCompound) break block4;
                object = null;
                this.readLock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                this.readLock.unlock();
                throw throwable;
            }
        }
        object = new NBTCompound(this, (String)object, this.readOnly);
        if (NBTReflectionUtil.valideCompound((NBTCompound)object)) {
            this.readLock.unlock();
            return object;
        }
        object = null;
        this.readLock.unlock();
        return object;
    }

    @Override
    public NBTCompound getOrCreateCompound(String string) {
        return this.addCompound(string);
    }

    @Override
    public NBTList<String> getStringList(String object) {
        try {
            this.writeLock.lock();
            object = NBTReflectionUtil.getList(this, (String)object, NBTType.NBTTagString, String.class);
            this.saveCompound();
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NBTList<Integer> getIntegerList(String object) {
        try {
            this.writeLock.lock();
            object = NBTReflectionUtil.getList(this, (String)object, NBTType.NBTTagInt, Integer.class);
            this.saveCompound();
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NBTList<int[]> getIntArrayList(String object) {
        try {
            this.writeLock.lock();
            object = NBTReflectionUtil.getList(this, (String)object, NBTType.NBTTagIntArray, int[].class);
            this.saveCompound();
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NBTList<UUID> getUUIDList(String object) {
        try {
            this.writeLock.lock();
            object = NBTReflectionUtil.getList(this, (String)object, NBTType.NBTTagIntArray, UUID.class);
            this.saveCompound();
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NBTList<Float> getFloatList(String object) {
        try {
            this.writeLock.lock();
            object = NBTReflectionUtil.getList(this, (String)object, NBTType.NBTTagFloat, Float.class);
            this.saveCompound();
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NBTList<Double> getDoubleList(String object) {
        try {
            this.writeLock.lock();
            object = NBTReflectionUtil.getList(this, (String)object, NBTType.NBTTagDouble, Double.class);
            this.saveCompound();
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NBTList<Long> getLongList(String object) {
        try {
            this.writeLock.lock();
            object = NBTReflectionUtil.getList(this, (String)object, NBTType.NBTTagLong, Long.class);
            this.saveCompound();
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public NBTType getListType(String object) {
        try {
            this.readLock.lock();
            if (this.getType((String)object) != NBTType.NBTTagList) {
                object = null;
                return object;
            }
            object = NBTReflectionUtil.getListType(this, object);
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public NBTCompoundList getCompoundList(String object) {
        try {
            this.writeLock.lock();
            object = (NBTCompoundList)NBTReflectionUtil.getList(this, (String)object, NBTType.NBTTagCompound, NBTListCompound.class);
            this.saveCompound();
            return object;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public <T> T getOrDefault(String object, T t2) {
        if (t2 == null) {
            throw new NullPointerException("Default type in getOrDefault can't be null!");
        }
        if (!this.hasTag((String)object)) {
            return t2;
        }
        Class<?> clazz = t2.getClass();
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return (T)this.getBoolean((String)object);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return (T)this.getByte((String)object);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return (T)this.getShort((String)object);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (T)this.getInteger((String)object);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return (T)this.getLong((String)object);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return (T)this.getFloat((String)object);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return (T)this.getDouble((String)object);
        }
        if (clazz == byte[].class) {
            return (T)this.getByteArray((String)object);
        }
        if (clazz == int[].class) {
            return (T)this.getIntArray((String)object);
        }
        if (clazz == long[].class) {
            return (T)this.getLongArray((String)object);
        }
        if (clazz == String.class) {
            return (T)this.getString((String)object);
        }
        if (clazz == UUID.class) {
            if ((object = this.getUUID((String)object)) == null) {
                return t2;
            }
            return (T)object;
        }
        if (clazz.isEnum()) {
            if ((object = this.getEnum((String)object, t2.getClass())) == null) {
                return t2;
            }
            return (T)object;
        }
        throw new NbtApiException("Unsupported type for getOrDefault: " + clazz.getName());
    }

    @Override
    public <T> T getOrNull(String string, Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("Default type in getOrNull can't be null!");
        }
        if (!this.hasTag(string)) {
            return null;
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return (T)this.getBoolean(string);
        }
        if (clazz == Byte.class || clazz == Byte.TYPE) {
            return (T)this.getByte(string);
        }
        if (clazz == Short.class || clazz == Short.TYPE) {
            return (T)this.getShort(string);
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return (T)this.getInteger(string);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return (T)this.getLong(string);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return (T)this.getFloat(string);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return (T)this.getDouble(string);
        }
        if (clazz == byte[].class) {
            return (T)this.getByteArray(string);
        }
        if (clazz == int[].class) {
            return (T)this.getIntArray(string);
        }
        if (clazz == long[].class) {
            return (T)this.getLongArray(string);
        }
        if (clazz == String.class) {
            return (T)this.getString(string);
        }
        if (clazz == UUID.class) {
            return (T)this.getUUID(string);
        }
        if (clazz.isEnum()) {
            return (T)this.getEnum(string, clazz);
        }
        throw new NbtApiException("Unsupported type for getOrNull: " + clazz.getName());
    }

    @Override
    public <T> T resolveOrNull(String object, Class<?> clazz) {
        object = PathUtil.splitPath((String)object);
        Object object2 = this;
        for (int i2 = 0; i2 < object.size() - 1; ++i2) {
            PathUtil.PathSegment pathSegment = (PathUtil.PathSegment)object.get(i2);
            if (!pathSegment.hasIndex()) {
                if ((object2 = ((NBTCompound)object2).getCompound(pathSegment.getPath())) != null) continue;
                return null;
            }
            if (((NBTCompound)object2).getType(pathSegment.getPath()) != NBTType.NBTTagList || ((NBTCompound)object2).getListType(pathSegment.getPath()) != NBTType.NBTTagCompound) continue;
            object2 = ((NBTCompound)object2).getCompoundList(pathSegment.getPath());
            if (pathSegment.getIndex() >= 0) {
                object2 = ((NBTCompoundList)object2).get(pathSegment.getIndex());
                continue;
            }
            Object object3 = object2;
            object2 = ((NBTCompoundList)object3).get(((NBTList)object3).size() + pathSegment.getIndex());
        }
        Object object4 = object;
        PathUtil.PathSegment pathSegment = (PathUtil.PathSegment)object4.get(object4.size() - 1);
        if (!pathSegment.hasIndex()) {
            return ((NBTCompound)object2).getOrNull(pathSegment.getPath(), clazz);
        }
        return (T)this.getIndexedValue((NBTCompound)object2, pathSegment, clazz);
    }

    @Override
    public <T> T resolveOrDefault(String object, T t2) {
        object = PathUtil.splitPath((String)object);
        Object object2 = this;
        for (int i2 = 0; i2 < object.size() - 1; ++i2) {
            PathUtil.PathSegment pathSegment = (PathUtil.PathSegment)object.get(i2);
            if (!pathSegment.hasIndex()) {
                if ((object2 = ((NBTCompound)object2).getCompound(pathSegment.getPath())) != null) continue;
                return t2;
            }
            if (((NBTCompound)object2).getType(pathSegment.getPath()) != NBTType.NBTTagList || ((NBTCompound)object2).getListType(pathSegment.getPath()) != NBTType.NBTTagCompound) continue;
            object2 = ((NBTCompound)object2).getCompoundList(pathSegment.getPath());
            if (pathSegment.getIndex() >= 0) {
                object2 = ((NBTCompoundList)object2).get(pathSegment.getIndex());
                continue;
            }
            Object object3 = object2;
            object2 = ((NBTCompoundList)object3).get(((NBTList)object3).size() + pathSegment.getIndex());
        }
        Object object4 = object;
        PathUtil.PathSegment pathSegment = (PathUtil.PathSegment)object4.get(object4.size() - 1);
        if (!pathSegment.hasIndex()) {
            return ((NBTCompound)object2).getOrDefault(pathSegment.getPath(), t2);
        }
        return (T)this.getIndexedValue((NBTCompound)object2, pathSegment, t2.getClass());
    }

    private <T> T getIndexedValue(NBTCompound object, PathUtil.PathSegment pathSegment, Class<T> clazz) {
        if (clazz == String.class) {
            if (((NBTCompound)object).getType(pathSegment.getPath()) == NBTType.NBTTagList && ((NBTCompound)object).getListType(pathSegment.getPath()) == NBTType.NBTTagString) {
                if (pathSegment.getIndex() >= 0) {
                    return (T)((NBTCompound)object).getStringList(pathSegment.getPath()).get(pathSegment.getIndex());
                }
                object = ((NBTCompound)object).getStringList(pathSegment.getPath());
                return (T)object.get(object.size() + pathSegment.getIndex());
            }
            throw new NbtApiException("No fitting list/array found for " + pathSegment.getPath() + " of type " + clazz);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            if (((NBTCompound)object).getType(pathSegment.getPath()) == NBTType.NBTTagList && ((NBTCompound)object).getListType(pathSegment.getPath()) == NBTType.NBTTagInt) {
                if (pathSegment.getIndex() >= 0) {
                    return (T)((NBTCompound)object).getIntegerList(pathSegment.getPath()).get(pathSegment.getIndex());
                }
                object = ((NBTCompound)object).getIntegerList(pathSegment.getPath());
                return (T)object.get(object.size() + pathSegment.getIndex());
            }
            if (((NBTCompound)object).getType(pathSegment.getPath()) == NBTType.NBTTagIntArray) {
                if (pathSegment.getIndex() >= 0) {
                    int[] nArray = ((NBTCompound)object).getIntArray(pathSegment.getPath());
                    object = nArray;
                    if (nArray != null) {
                        return (T)Integer.valueOf((int)object[pathSegment.getIndex()]);
                    }
                } else {
                    int[] nArray = ((NBTCompound)object).getIntArray(pathSegment.getPath());
                    object = nArray;
                    if (nArray != null) {
                        Object object2 = object;
                        return (T)Integer.valueOf((int)object2[((Object)object2).length + pathSegment.getIndex()]);
                    }
                }
            }
            throw new NbtApiException("No fitting list/array found for " + pathSegment.getPath() + " of type " + clazz);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            if (((NBTCompound)object).getType(pathSegment.getPath()) == NBTType.NBTTagList && ((NBTCompound)object).getListType(pathSegment.getPath()) == NBTType.NBTTagLong) {
                if (pathSegment.getIndex() >= 0) {
                    return (T)((NBTCompound)object).getLongList(pathSegment.getPath()).get(pathSegment.getIndex());
                }
                object = ((NBTCompound)object).getLongList(pathSegment.getPath());
                return (T)object.get(object.size() + pathSegment.getIndex());
            }
            if (((NBTCompound)object).getType(pathSegment.getPath()) == NBTType.NBTTagLongArray) {
                if (pathSegment.getIndex() >= 0) {
                    long[] lArray = ((NBTCompound)object).getLongArray(pathSegment.getPath());
                    object = lArray;
                    if (lArray != null) {
                        return (T)Long.valueOf((long)object[pathSegment.getIndex()]);
                    }
                } else {
                    long[] lArray = ((NBTCompound)object).getLongArray(pathSegment.getPath());
                    object = lArray;
                    if (lArray != null) {
                        Object object3 = object;
                        return (T)Long.valueOf((long)object3[((Object)object3).length + pathSegment.getIndex()]);
                    }
                }
            }
            throw new NbtApiException("No fitting list/array found for " + pathSegment.getPath() + " of type " + clazz);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            if (((NBTCompound)object).getType(pathSegment.getPath()) == NBTType.NBTTagList && ((NBTCompound)object).getListType(pathSegment.getPath()) == NBTType.NBTTagFloat) {
                if (pathSegment.getIndex() >= 0) {
                    return (T)((NBTCompound)object).getFloatList(pathSegment.getPath()).get(pathSegment.getIndex());
                }
                object = ((NBTCompound)object).getFloatList(pathSegment.getPath());
                return (T)object.get(object.size() + pathSegment.getIndex());
            }
            throw new NbtApiException("No fitting list/array found for " + pathSegment.getPath() + " of type " + clazz);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            if (((NBTCompound)object).getType(pathSegment.getPath()) == NBTType.NBTTagList && ((NBTCompound)object).getListType(pathSegment.getPath()) == NBTType.NBTTagDouble) {
                if (pathSegment.getIndex() >= 0) {
                    return (T)((NBTCompound)object).getDoubleList(pathSegment.getPath()).get(pathSegment.getIndex());
                }
                object = ((NBTCompound)object).getDoubleList(pathSegment.getPath());
                return (T)object.get(object.size() + pathSegment.getIndex());
            }
            throw new NbtApiException("No fitting list/array found for " + pathSegment.getPath() + " of type " + clazz);
        }
        if (clazz == int[].class) {
            if (((NBTCompound)object).getType(pathSegment.getPath()) == NBTType.NBTTagList && ((NBTCompound)object).getListType(pathSegment.getPath()) == NBTType.NBTTagIntArray) {
                if (pathSegment.getIndex() >= 0) {
                    return (T)((NBTCompound)object).getIntArrayList(pathSegment.getPath()).get(pathSegment.getIndex());
                }
                object = ((NBTCompound)object).getIntArrayList(pathSegment.getPath());
                return (T)object.get(object.size() + pathSegment.getIndex());
            }
            throw new NbtApiException("No fitting list/array found for " + pathSegment.getPath() + " of type " + clazz);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            if (((NBTCompound)object).getType(pathSegment.getPath()) == NBTType.NBTTagByteArray) {
                if (pathSegment.getIndex() >= 0) {
                    byte[] byArray = ((NBTCompound)object).getByteArray(pathSegment.getPath());
                    object = byArray;
                    if (byArray != null) {
                        return (T)Byte.valueOf((byte)object[pathSegment.getIndex()]);
                    }
                } else {
                    byte[] byArray = ((NBTCompound)object).getByteArray(pathSegment.getPath());
                    object = byArray;
                    if (byArray != null) {
                        Object object4 = object;
                        return (T)Byte.valueOf((byte)object4[((Object)object4).length + pathSegment.getIndex()]);
                    }
                }
            }
            throw new NbtApiException("No fitting list/array found for " + pathSegment.getPath() + " of type " + clazz);
        }
        throw new NbtApiException("Unable to get indexed value for type " + clazz);
    }

    @Override
    public ReadWriteNBT resolveCompound(String object) {
        object = PathUtil.splitPath((String)object);
        Object object2 = this;
        for (int i2 = 0; i2 < object.size(); ++i2) {
            PathUtil.PathSegment pathSegment = (PathUtil.PathSegment)object.get(i2);
            if (!pathSegment.hasIndex()) {
                if ((object2 = ((NBTCompound)object2).getCompound(pathSegment.getPath())) != null) continue;
                return null;
            }
            if (((NBTCompound)object2).getType(pathSegment.getPath()) != NBTType.NBTTagList || ((NBTCompound)object2).getListType(pathSegment.getPath()) != NBTType.NBTTagCompound) continue;
            object2 = ((NBTCompound)object2).getCompoundList(pathSegment.getPath());
            if (pathSegment.getIndex() >= 0) {
                object2 = ((NBTCompoundList)object2).get(pathSegment.getIndex());
                continue;
            }
            Object object3 = object2;
            object2 = ((NBTCompoundList)object3).get(((NBTList)object3).size() + pathSegment.getIndex());
        }
        return object2;
    }

    @Override
    public ReadWriteNBT resolveOrCreateCompound(String object) {
        object = PathUtil.splitPath((String)object);
        Object object2 = this;
        for (int i2 = 0; i2 < object.size(); ++i2) {
            PathUtil.PathSegment pathSegment = (PathUtil.PathSegment)object.get(i2);
            if (!pathSegment.hasIndex()) {
                if ((object2 = ((NBTCompound)object2).getOrCreateCompound(pathSegment.getPath())) != null) continue;
                return null;
            }
            if (((NBTCompound)object2).getType(pathSegment.getPath()) != NBTType.NBTTagList || ((NBTCompound)object2).getListType(pathSegment.getPath()) != NBTType.NBTTagCompound) continue;
            object2 = ((NBTCompound)object2).getCompoundList(pathSegment.getPath());
            if (pathSegment.getIndex() >= 0) {
                object2 = ((NBTCompoundList)object2).get(pathSegment.getIndex());
                continue;
            }
            Object object3 = object2;
            object2 = ((NBTCompoundList)object3).get(((NBTList)object3).size() + pathSegment.getIndex());
        }
        return object2;
    }

    @Override
    public <E extends Enum<?>> void setEnum(String string, E e2) {
        if (e2 == null) {
            this.removeKey(string);
            return;
        }
        this.setString(string, e2.name());
    }

    @Override
    public <E extends Enum<E>> E getEnum(String string, Class<E> clazz) {
        if (string == null || clazz == null) {
            return null;
        }
        if ((string = this.getString(string)) == null) {
            return null;
        }
        try {
            return Enum.valueOf(clazz, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    @Override
    public NBTType getType(String object) {
        try {
            this.readLock.lock();
            if (MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
                if ((object = NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET, (String)object)) == null) {
                    object = null;
                    return object;
                }
                object = NBTType.valueOf(((Byte)ReflectionMethod.COMPOUND_OWN_TYPE.run(object, new Object[0])).byteValue());
                return object;
            }
            if ((object = NBTReflectionUtil.getData(this, ReflectionMethod.COMPOUND_GET_TYPE, (String)object)) == null) {
                object = null;
                return object;
            }
            object = NBTType.valueOf(((Byte)object).byteValue());
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void writeCompound(OutputStream outputStream) {
        try {
            this.writeLock.lock();
            NBTReflectionUtil.writeApiNBT(this, outputStream);
            return;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public <T> T get(String string, NBTHandler<T> nBTHandler) {
        return nBTHandler.get(this, string);
    }

    @Override
    public <T> void set(String string, T t2, NBTHandler<T> nBTHandler) {
        nBTHandler.set(this, string, t2);
    }

    @Override
    public String toString() {
        return this.asNBTString();
    }

    @Deprecated
    public String toString(String string) {
        return this.asNBTString();
    }

    @Override
    public void clearNBT() {
        for (String string : this.getKeys()) {
            this.removeKey(string);
        }
    }

    @Deprecated
    public String asNBTString() {
        try {
            this.readLock.lock();
            Object object = this.getResolvedObject();
            if (object == null) {
                object = "{}";
                return object;
            }
            if (MinecraftVersion.isForgePresent() && MinecraftVersion.getVersion() == MinecraftVersion.MC1_7_R4) {
                object = Forge1710Mappings.toString(object);
                return object;
            }
            object = object.toString();
            return object;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof NBTCompound) {
            object = (NBTCompound)object;
            if (this.getKeys().equals(((NBTCompound)object).getKeys())) {
                for (String string : this.getKeys()) {
                    if (NBTCompound.isEqual(this, (NBTCompound)object, string)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    protected static boolean isEqual(NBTCompound nBTCompound, NBTCompound nBTCompound2, String string) {
        if (nBTCompound.getType(string) != nBTCompound2.getType(string)) {
            return false;
        }
        switch (nBTCompound.getType(string)) {
            case NBTTagByte: {
                return nBTCompound.getByte(string).equals(nBTCompound2.getByte(string));
            }
            case NBTTagByteArray: {
                return Arrays.equals(nBTCompound.getByteArray(string), nBTCompound2.getByteArray(string));
            }
            case NBTTagCompound: {
                nBTCompound = nBTCompound.getCompound(string);
                return nBTCompound != null && nBTCompound.equals(nBTCompound2.getCompound(string));
            }
            case NBTTagDouble: {
                return nBTCompound.getDouble(string).equals(nBTCompound2.getDouble(string));
            }
            case NBTTagEnd: {
                return true;
            }
            case NBTTagFloat: {
                return nBTCompound.getFloat(string).equals(nBTCompound2.getFloat(string));
            }
            case NBTTagInt: {
                return nBTCompound.getInteger(string).equals(nBTCompound2.getInteger(string));
            }
            case NBTTagIntArray: {
                return Arrays.equals(nBTCompound.getIntArray(string), nBTCompound2.getIntArray(string));
            }
            case NBTTagList: {
                return NBTReflectionUtil.getEntry(nBTCompound, string).toString().equals(NBTReflectionUtil.getEntry(nBTCompound2, string).toString());
            }
            case NBTTagLong: {
                return nBTCompound.getLong(string).equals(nBTCompound2.getLong(string));
            }
            case NBTTagShort: {
                return nBTCompound.getShort(string).equals(nBTCompound2.getShort(string));
            }
            case NBTTagString: {
                return nBTCompound.getString(string).equals(nBTCompound2.getString(string));
            }
            case NBTTagLongArray: {
                return Arrays.equals(nBTCompound.getLongArray(string), nBTCompound2.getLongArray(string));
            }
        }
        return false;
    }
}

