/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.nbtapi;

import java.io.InputStream;
import me.extremall.advancedkits.libs.nbtapi.NBTCompound;
import me.extremall.advancedkits.libs.nbtapi.NBTReflectionUtil;
import me.extremall.advancedkits.libs.nbtapi.NbtApiException;
import me.extremall.advancedkits.libs.nbtapi.utils.nmsmappings.ClassWrapper;
import me.extremall.advancedkits.libs.nbtapi.utils.nmsmappings.ObjectCreator;
import me.extremall.advancedkits.libs.nbtapi.utils.nmsmappings.ReflectionMethod;

public class NBTContainer
extends NBTCompound {
    private Object nbt;
    private boolean closed;
    private boolean readOnly;

    public NBTContainer() {
        super(null, null);
        this.nbt = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
    }

    public NBTContainer(Object object) {
        super(null, null);
        if (object == null) {
            object = ObjectCreator.NMS_NBTTAGCOMPOUND.getInstance(new Object[0]);
        }
        if (!ClassWrapper.NMS_NBTTAGCOMPOUND.getClazz().isAssignableFrom(object.getClass())) {
            throw new NbtApiException("The object '" + object.getClass() + "' is not a valid NBT-Object!");
        }
        this.nbt = object;
    }

    public NBTContainer(InputStream inputStream) {
        super(null, null);
        this.nbt = NBTReflectionUtil.readNBT(inputStream);
    }

    public NBTContainer(String string) {
        super(null, null);
        if (string == null) {
            throw new NullPointerException("The String can't be null!");
        }
        try {
            this.nbt = ReflectionMethod.PARSE_NBT.run(null, string);
            return;
        }
        catch (Exception exception) {
            throw new NbtApiException("Unable to parse Malformed Json!", exception);
        }
    }

    @Override
    public Object getCompound() {
        return this.nbt;
    }

    @Override
    public void setCompound(Object object) {
        this.nbt = object;
    }

    @Override
    protected void setClosed() {
        this.closed = true;
    }

    @Override
    protected boolean isClosed() {
        return this.closed;
    }

    @Override
    protected boolean isReadOnly() {
        return this.readOnly;
    }

    protected NBTContainer setReadOnly(boolean bl2) {
        this.readOnly = true;
        return this;
    }
}

