/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.paperlib.environments;

import java.util.concurrent.CompletableFuture;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.extremall.advancedkits.libs.paperlib.features.asyncchunks.AsyncChunks;
import me.extremall.advancedkits.libs.paperlib.features.asyncchunks.AsyncChunksSync;
import me.extremall.advancedkits.libs.paperlib.features.asyncteleport.AsyncTeleport;
import me.extremall.advancedkits.libs.paperlib.features.asyncteleport.AsyncTeleportSync;
import me.extremall.advancedkits.libs.paperlib.features.bedspawnlocation.BedSpawnLocation;
import me.extremall.advancedkits.libs.paperlib.features.bedspawnlocation.BedSpawnLocationSync;
import me.extremall.advancedkits.libs.paperlib.features.blockstatesnapshot.BlockStateSnapshot;
import me.extremall.advancedkits.libs.paperlib.features.blockstatesnapshot.BlockStateSnapshotBeforeSnapshots;
import me.extremall.advancedkits.libs.paperlib.features.blockstatesnapshot.BlockStateSnapshotNoOption;
import me.extremall.advancedkits.libs.paperlib.features.blockstatesnapshot.BlockStateSnapshotResult;
import me.extremall.advancedkits.libs.paperlib.features.chunkisgenerated.ChunkIsGenerated;
import me.extremall.advancedkits.libs.paperlib.features.chunkisgenerated.ChunkIsGeneratedApiExists;
import me.extremall.advancedkits.libs.paperlib.features.chunkisgenerated.ChunkIsGeneratedUnknown;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

public abstract class Environment {
    private final int minecraftVersion;
    private final int minecraftPatchVersion;
    private final int minecraftPreReleaseVersion;
    protected AsyncChunks asyncChunksHandler = new AsyncChunksSync();
    protected AsyncTeleport asyncTeleportHandler = new AsyncTeleportSync();
    protected ChunkIsGenerated isGeneratedHandler = new ChunkIsGeneratedUnknown();
    protected BlockStateSnapshot blockStateSnapshotHandler;
    protected BedSpawnLocation bedSpawnLocationHandler = new BedSpawnLocationSync();

    public Environment() {
        Object object = Pattern.compile("(?i)\\(MC: (\\d)\\.(\\d+)\\.?(\\d+?)?(?: Pre-Release )?(\\d)?\\)");
        object = ((Pattern)object).matcher(Bukkit.getVersion());
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (((Matcher)object).find()) {
            MatchResult matchResult = ((Matcher)object).toMatchResult();
            try {
                n2 = Integer.parseInt(matchResult.group(2), 10);
            }
            catch (Exception exception) {}
            if (matchResult.groupCount() >= 3) {
                try {
                    n3 = Integer.parseInt(matchResult.group(3), 10);
                }
                catch (Exception exception) {}
            }
            if (matchResult.groupCount() >= 4) {
                try {
                    n4 = Integer.parseInt(((Matcher)object).group(4));
                }
                catch (Exception exception) {}
            }
        }
        this.minecraftVersion = n2;
        this.minecraftPatchVersion = n3;
        this.minecraftPreReleaseVersion = n4;
        if (this.isVersion(13, 1)) {
            this.isGeneratedHandler = new ChunkIsGeneratedApiExists();
        }
        if (!this.isVersion(12)) {
            this.blockStateSnapshotHandler = new BlockStateSnapshotBeforeSnapshots();
            return;
        }
        this.blockStateSnapshotHandler = new BlockStateSnapshotNoOption();
    }

    public abstract String getName();

    public CompletableFuture<Chunk> getChunkAtAsync(World world, int n2, int n3, boolean bl2) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n2, n3, bl2, false);
    }

    public CompletableFuture<Chunk> getChunkAtAsync(World world, int n2, int n3, boolean bl2, boolean bl3) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n2, n3, bl2, bl3);
    }

    public CompletableFuture<Chunk> getChunkAtAsyncUrgently(World world, int n2, int n3, boolean bl2) {
        return this.asyncChunksHandler.getChunkAtAsync(world, n2, n3, bl2, true);
    }

    public CompletableFuture<Boolean> teleport(Entity entity, Location location, PlayerTeleportEvent.TeleportCause teleportCause) {
        return this.asyncTeleportHandler.teleportAsync(entity, location, teleportCause);
    }

    public boolean isChunkGenerated(World world, int n2, int n3) {
        return this.isGeneratedHandler.isChunkGenerated(world, n2, n3);
    }

    public BlockStateSnapshotResult getBlockState(Block block, boolean bl2) {
        return this.blockStateSnapshotHandler.getBlockState(block, bl2);
    }

    public CompletableFuture<Location> getBedSpawnLocationAsync(Player player, boolean bl2) {
        return this.bedSpawnLocationHandler.getBedSpawnLocationAsync(player, bl2);
    }

    public boolean isVersion(int n2) {
        return this.isVersion(n2, 0);
    }

    public boolean isVersion(int n2, int n3) {
        return this.minecraftVersion > n2 || this.minecraftVersion >= n2 && this.minecraftPatchVersion >= n3;
    }

    public int getMinecraftVersion() {
        return this.minecraftVersion;
    }

    public int getMinecraftPatchVersion() {
        return this.minecraftPatchVersion;
    }

    public int getMinecraftPreReleaseVersion() {
        return this.minecraftPreReleaseVersion;
    }

    public boolean isSpigot() {
        return false;
    }

    public boolean isPaper() {
        return false;
    }
}

