/*
 * Decompiled with CFR 0.152.
 */
package me.extremall.advancedkits.libs.yamlassist;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.extremall.advancedkits.libs.yamlassist.SyntaxError;
import me.extremall.advancedkits.libs.yamlassist.types.BadIndentation;
import me.extremall.advancedkits.libs.yamlassist.types.DoubleMapping;
import me.extremall.advancedkits.libs.yamlassist.types.InvalidLine;
import me.extremall.advancedkits.libs.yamlassist.types.InvalidList;
import me.extremall.advancedkits.libs.yamlassist.types.MissingQuote;
import me.extremall.advancedkits.libs.yamlassist.types.MissingSpaceBeforeValue;
import me.extremall.advancedkits.libs.yamlassist.types.QuoteWrapRequired;
import me.extremall.advancedkits.libs.yamlassist.types.TABIndent;
import me.extremall.advancedkits.libs.yamlassist.types.UnknownEscape;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public class YamlAssist {
    private static Map<Class<? extends SyntaxError>, SyntaxError> registeredSyntaxErrors = new HashMap<Class<? extends SyntaxError>, SyntaxError>();

    public static List<String> getSuggestions(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            if (file == null) {
                throw new IllegalArgumentException("File cannot be null");
            }
            if (!file.exists()) {
                throw new IllegalStateException("File does not exist");
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                new Yaml().load((InputStream)fileInputStream);
            }
            catch (YAMLException yAMLException) {
                for (SyntaxError syntaxError : registeredSyntaxErrors.values()) {
                    arrayList.addAll(syntaxError.getSuggestions(yAMLException, Files.readAllLines(file.toPath())));
                }
            }
            fileInputStream.close();
        }
        catch (IOException iOException) {
            IOException iOException2 = iOException;
            iOException.printStackTrace();
        }
        return arrayList;
    }

    public static void registerSyntaxError(SyntaxError syntaxError) {
        registeredSyntaxErrors.put(syntaxError.getClass(), syntaxError);
    }

    public static <T> T getError(Class<T> clazz) {
        return (T)registeredSyntaxErrors.get(clazz);
    }

    static {
        YamlAssist.registerSyntaxError(new DoubleMapping());
        YamlAssist.registerSyntaxError(new InvalidList());
        YamlAssist.registerSyntaxError(new InvalidLine());
        YamlAssist.registerSyntaxError(new MissingQuote());
        YamlAssist.registerSyntaxError(new MissingSpaceBeforeValue());
        YamlAssist.registerSyntaxError(new QuoteWrapRequired());
        YamlAssist.registerSyntaxError(new TABIndent());
        YamlAssist.registerSyntaxError(new UnknownEscape());
        YamlAssist.registerSyntaxError(new BadIndentation());
    }
}

