/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.utils.FileUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.listener.ArenaGameplayListener;
import su.nightexpress.ama.arena.listener.ArenaGenericListener;
import su.nightexpress.ama.arena.listener.ArenaMythicListener;
import su.nightexpress.ama.arena.menu.ArenaListMenu;
import su.nightexpress.ama.arena.task.ArenaOpenTask;
import su.nightexpress.ama.arena.task.ArenaTickTask;

public class ArenaManager
extends AbstractManager<AMA> {
    public static final String DIR_ARENAS = "/arenas/";
    private final Map<String, Arena> arenas = new HashMap<String, Arena>();
    private ArenaListMenu arenaListMenu;
    private ArenaTickTask arenaTickTask;
    private ArenaOpenTask arenaOpenTask;

    public ArenaManager(@NotNull AMA aMA) {
        super((NexPlugin)aMA);
        DirMctLeUksmXxYhyQckpM3wxEWJVKy.1EjfNFBbuR(Class.forName("DiTectLeaSsnRcxog9aAnPQPPPboQo"));
    }

    protected void onLoad() {
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DIrxctLtAks", "&!{\u0007%2Z60-$'\f?&\u001c#84z\u0014$\r", (Object)"'!;=-&Y", "}\u0018?\b:4\u001d7!<8z\u000f9;Q6<::z*#;A780&n@\u001a", 77, -1.0110149682264749, "nU3CLWBwwverspVdoTCb4oxTAU3z4M8msJ4l", (Object)((AMA)this.plugin), bukkitTask -> {
            for (File file : FileUtil.getFolders((String)(((AMA)this.plugin).getDataFolder() + DIR_ARENAS))) {
                File file2 = new File(file.getAbsolutePath(), file.getName() + ".yml");
                File file3 = new File(file.getAbsolutePath(), "config.yml");
                if (file2.exists() && !file2.renameTo(file3)) {
                    ((AMA)this.plugin).error("Could not rename arena config: " + file2.getName());
                    continue;
                }
                JYML jYML = new JYML(file.getAbsolutePath(), "config.yml");
                ArenaConfig arenaConfig = new ArenaConfig((AMA)this.plugin, jYML, file.getName());
                if (arenaConfig.load()) {
                    this.arenas.put(arenaConfig.getId(), arenaConfig.getArena());
                    if (!arenaConfig.hasProblems()) continue;
                    ((AMA)this.plugin).warn("Arena '" + arenaConfig.getId() + "' contains some problems! Arena disabled until all problems are fixed.");
                    continue;
                }
                ((AMA)this.plugin).error("Arena not loaded: '" + jYML.getFile().getName() + "' !");
            }
            ((AMA)this.plugin).info("Arenas Loaded: " + this.arenas.size());
            ((AMA)this.plugin).getStatsManager().update();
        });
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DIrxctLtAks", "\u00109M\u0007\u0006\u0004Z6\u0006\u001b<\u0011\f\u001c\u0010\u001c#\u000e\u0002b\u0002\u001b\n\rSl\"\u0011)\r\b\"\u0002\\#\u0004\u0006>", (Object)"\u0002(\u0007%\u0006\u0010F'\r\u0006>", "K\u0000\u0010\u001c@\rW:\u000e\u0006(\n\b@\u0006\\%\n\r)L\b\u001f\n\u001d/\u0002\r-\u0004\f\u001dLw4\u0006\r8/\u0000\u001c\u0017W,\u0006\u0011wJ?", 77, -8599548405139200992L, "xcUfoL3kHOHvQtmd1LX0vPzmA4KhKq3LGKZ3v5VM3C", (Object)this, (Object)new ArenaGenericListener(this));
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DIrxctLtAks", "CG\u001e\u0007.WZ6UHBB\f4C\u001c#]Q\u001cQ\u001b\"^SlqBW^\b\nQ\\#WU@", (Object)"QVT%.CF'^U@", "\u0018~C\u001ch^W:]UVY\bhU\\%Y^W\u001f\b7Y\u001d/Q^SW\f5\u001fw4U^F|\u00004DW,UB\t\u0019?", 75, 4240265604102614317L, "C0uqGH8WNvKZ6UM2z2uY0U85C7jlEJiZbgI8qYOZmEZqjS", (Object)this, (Object)new ArenaGameplayListener(this));
        if (DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DIrxctLtAks", "A-\u001c\u0007\u0002J_'V[9\u001c\f\tU[,W\u001c-F\u0000\u000bA\u001c\u0007\\U1\\\f2F[.A", (Object)"Z9A9\u000bGU+\\", "\u001a\u0014X\b\u0011S\u001d.S\\?\u001d:\u0013@[,U\tqh", 76, 0.6744425f, "s27TgUh93nFM20CoJXjfWf8Dsi4O526MeEjdR50wzge5GKezUn6wUx", DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DIrxctLtAks", "\u001d.\r\f\u0000-~'8\n47;\u0000!]%`8\u0006792\tb\u0012;6\u00166", (Object)"\r\t\u0003\u001e\foC(#\u001f\u0015>#$\u0012K%h1v", "q\u000b3\b\u00158\u001d.87 v:\u0017+[,>b\u000b3\b\u00158\u001d.87 v:\u0017+[,>bn\u0015\u0003\u0002/Sm58)>F0-@+7>|", 76, -0.48015016f, "NY6LcoSDqbfTmgxdSGQV5uGnQTmRpqzmucAyzQIUC1", "\u0002\u0003;\u0012&\u0019\u0002\u0015-\t", "yEfpvbN76gku6S0Q4OMGmwjc4zNqdbAs7NMEsFqlaN0F7QTV7")) != false) {
            DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DIrxctLtAks", "B1\u001f\u0007\u0000VZ6TI4C\f\u001aB\u001c#\\PjP\u001b\f_SlpC!_\b$P\\#VT6", (Object)"P U%\u0000BF'_T6", "\u0019\bB\u001cF_W:\\T X\bFT\\%X_!\u001e\b\u0019X\u001d/P_%V\f\u001b\u001ew4T_0}\u0000\u001aEW,TC\u007f\u0018?", 77, 8913179669159758979L, "81BCiMsHkeHRbz4rND0YZukOl1vmdADiL4t0LZ", (Object)this, (Object)new ArenaMythicListener((AMA)this.plugin));
        }
        this.arenaTickTask = new ArenaTickTask(this);
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DIrxctLtAks", "2\u0012o\u0007\u001c&Z6$9\u00173\f\u00062\u001c#, I \u001b\u0010/Sl5 \u0014*G43W, \u0015\u000e\"\u0002! A)", (Object)"2\u0013 \u001b\u0001", "iN\u001b", 75, -13.286446067604547, "RAN6u01M1YxEaHLJBgVGDS3w8va4vAOtUl9", (Object)this.arenaTickTask);
        this.arenaOpenTask = new ArenaOpenTask(this);
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("DIrxctLtAks", "\u001fBB\u0007<\u000bZ6\t\u0014G\u001e\f&\u001f\u001c#\u0001\r\u0019\r\u001b0\u0002Sl\u0018\rD\u0007G\u0014\u001eW,\r#G\t\u0007\u0001\rA)", (Object)"\u001fC\r\u001b!", "D\u001e6", 75, 1383778454, "9lsDURPyS92M1qIBH7N3z8y3Smi1xENI8HNtK2mtrmrcgxQ5", (Object)this.arenaOpenTask);
    }

    protected void onShutdown() {
        if (this.arenaOpenTask != null) {
            this.arenaOpenTask.stop();
        }
        if (this.arenaTickTask != null) {
            this.arenaTickTask.stop();
        }
        this.arenas.values().forEach(arena -> {
            arena.stop();
            arena.getConfig().clear();
        });
        this.arenas.clear();
        if (this.arenaListMenu != null) {
            this.arenaListMenu.clear();
            this.arenaListMenu = null;
        }
    }

    @NotNull
    public ArenaListMenu getArenaListMenu() {
        if (this.arenaListMenu == null) {
            this.arenaListMenu = new ArenaListMenu((AMA)this.plugin);
        }
        return this.arenaListMenu;
    }

    public boolean create(@NotNull String string) {
        if (this.isArenaExists(string)) {
            return false;
        }
        JYML jYML = new JYML(((AMA)this.plugin).getDataFolder() + DIR_ARENAS + string, "config.yml");
        ArenaConfig arenaConfig = new ArenaConfig((AMA)this.plugin, jYML, string);
        arenaConfig.setName(StringUtil.capitalizeUnderscored((String)string));
        arenaConfig.load();
        arenaConfig.save();
        this.getArenasMap().put(arenaConfig.getId(), arenaConfig.getArena());
        return true;
    }

    public void delete(@NotNull Arena arena) {
        if (arena.getConfig().isActive()) {
            return;
        }
        if (FileUtil.deleteRecursive((File)arena.getConfig().getFile().getParentFile())) {
            arena.getConfig().clear();
            this.arenas.remove(arena.getId());
        }
        if (this.arenaListMenu != null) {
            this.arenaListMenu.clear();
            this.arenaListMenu = null;
        }
    }

    public boolean isArenaExists(@NotNull String string) {
        return this.getArenaById(string) != null;
    }

    @NotNull
    public Collection<Arena> getArenas() {
        return this.getArenasMap().values();
    }

    @NotNull
    public Collection<Arena> getArenas(@NotNull Player player) {
        return this.getArenas().stream().filter(arena -> arena.canJoin(player, false)).collect(Collectors.toSet());
    }

    @NotNull
    public Map<String, Arena> getArenasMap() {
        return this.arenas;
    }

    @Nullable
    public Arena getArenaAtLocation(@NotNull Location location) {
        return this.getArenas().stream().filter(arena -> arena.getConfig().getRegionManager().getRegion(location) != null).findFirst().orElse(null);
    }

    @Nullable
    public Arena getArenaById(@NotNull String string) {
        return this.getArenasMap().get(string.toLowerCase());
    }

    @NotNull
    public List<String> getArenaIds() {
        return new ArrayList<String>(this.getArenasMap().keySet());
    }
}

