/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.script;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.script.action.Parameter;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.Parameters;
import su.nightexpress.ama.arena.script.action.ScriptAction;
import su.nightexpress.ama.arena.script.action.ScriptActions;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.impl.ArenaScript;
import su.nightexpress.ama.arena.script.impl.ScriptCategory;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class ScriptActionsEditor
extends EditorMenu<AMA, ArenaScript>
implements AutoPaged<ScriptPreparedAction> {
    private final ScriptCategory category;

    public ScriptActionsEditor(@NotNull ScriptCategory scriptCategory, @NotNull ArenaScript arenaScript) {
        super((NexPlugin)arenaScript.plugin(), (Object)arenaScript, "Arena Script Editor", 45);
        this.category = scriptCategory;
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> scriptCategory.getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.SCRIPT_ACTION_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> {
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), ScriptActions.getActions().stream().map(ScriptAction::getName).toList(), (boolean)true);
            this.handleInput(menuViewer, Lang.EDITOR_ARENA_SCRIPT_ENTER_ACTION_NAME, inputWrapper -> {
                String string = StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw());
                ScriptAction scriptAction = ScriptActions.getByName(string);
                if (scriptAction == null) {
                    EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_ARENA_SCRIPT_ERROR_INVALID_ACTION).getLocalized());
                    return false;
                }
                ScriptPreparedAction scriptPreparedAction = new ScriptPreparedAction(scriptAction, new ParameterResult());
                arenaScript.getActions().add(scriptPreparedAction);
                arenaScript.getArenaConfig().getScriptManager().save();
                return true;
            });
        });
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((ScriptActionsEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ScriptPreparedAction> getObjects(@NotNull Player player) {
        return new ArrayList<ScriptPreparedAction>(((ArenaScript)this.object).getActions());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ScriptPreparedAction scriptPreparedAction) {
        ItemStack itemStack = new ItemStack(Material.COMMAND_BLOCK);
        String string = scriptPreparedAction.getAction().getParameters().stream().map(parameter -> ChatColor.YELLOW.toString() + ChatColor.BOLD + parameter.getName() + ": " + ChatColor.AQUA + scriptPreparedAction.getParameters().get(parameter, null)).collect(Collectors.joining("\n"));
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.SCRIPT_ACTION_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.SCRIPT_ACTION_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, string2 -> string2.replace("%script_action_name%", scriptPreparedAction.getAction().getName()).replace("%script_action_parameters%", string));
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ScriptPreparedAction scriptPreparedAction) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                ((ArenaScript)this.object).getActions().remove(scriptPreparedAction);
                this.category.save();
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            if (inventoryClickEvent.isLeftClick()) {
                EditorManager.suggestValues((Player)menuViewer.getPlayer(), scriptPreparedAction.getAction().getParameters().stream().map(Parameter::getName).toList(), (boolean)false);
                this.handleInput(menuViewer, Lang.EDITOR_ARENA_SCRIPT_ENTER_ACTION_PARAMETER, inputWrapper -> {
                    String[] stringArray = inputWrapper.getTextRaw().split(" ");
                    if (stringArray.length < 2) {
                        EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_ARENA_SCRIPT_ERROR_INVALID_INPUT).getLocalized());
                        return false;
                    }
                    String string = stringArray[0];
                    String string2 = Stream.of(stringArray).skip(1L).collect(Collectors.joining(" "));
                    Parameter parameter = Parameters.getByName(string).orElse(null);
                    if (parameter == null || !scriptPreparedAction.getAction().getParameters().contains(parameter)) {
                        EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_ARENA_SCRIPT_ERROR_INVALID_PARAMETER).getLocalized());
                        return false;
                    }
                    if (string2.equalsIgnoreCase("null")) {
                        scriptPreparedAction.getParameters().getParams().remove(parameter);
                    } else {
                        scriptPreparedAction.getParameters().add(parameter, parameter.getParser().apply(string2));
                    }
                    this.category.save();
                    return true;
                });
                return;
            }
            if (inventoryClickEvent.isRightClick()) {
                ((ArenaScript)this.object).getActions().clear();
                this.category.save();
            }
        };
    }
}

