/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.script;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ArenaScript;
import su.nightexpress.ama.arena.script.impl.ScriptCategory;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class ScriptsCategoryEditor
extends EditorMenu<AMA, ScriptCategory>
implements AutoPaged<ArenaScript> {
    public ScriptsCategoryEditor(@NotNull ScriptCategory scriptCategory) {
        super((NexPlugin)((AMA)scriptCategory.plugin()), (Object)scriptCategory, "Arena Script Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> scriptCategory.getArenaConfig().getScriptManager().getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.SCRIPT_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_ARENA_SCRIPT_ENTER_SCRIPT, inputWrapper -> {
            scriptCategory.createScript(StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw()));
            scriptCategory.save();
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((ScriptsCategoryEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ArenaScript> getObjects(@NotNull Player player) {
        return ((ScriptCategory)this.object).getScripts().stream().sorted(Comparator.comparing(ArenaScript::getId)).toList();
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ArenaScript arenaScript) {
        ItemStack itemStack = new ItemStack(Material.MAP);
        String string2 = arenaScript.getConditions().values().stream().map(list -> list.stream().map(ScriptPreparedCondition::toRaw).map(string -> ChatColor.LIGHT_PURPLE + string).collect(Collectors.joining("\n"))).collect(Collectors.joining("\n" + ChatColor.RED + "OR:\n"));
        String string3 = arenaScript.getActions().stream().map(ScriptPreparedAction::toRaw).map(string -> ChatColor.GOLD + string).collect(Collectors.joining("\n"));
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.SCRIPT_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.SCRIPT_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, string3 -> string3.replace("%script_id%", arenaScript.getId()).replace("%script_condition_section_conditions%", string2).replace("%script_action_parameters%", string3).replace("%script_event_type%", arenaScript.getEventType().name()));
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ArenaScript arenaScript) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                ((ScriptCategory)this.object).getScriptsMap().remove(arenaScript.getId());
                ((ScriptCategory)this.object).save();
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            if (inventoryClickEvent.isLeftClick()) {
                arenaScript.getActionsEditor((ScriptCategory)this.object).openNextTick(menuViewer, 1);
            } else if (inventoryClickEvent.isRightClick()) {
                arenaScript.getConditionsEditor((ScriptCategory)this.object).openNextTick(menuViewer, 1);
            } else if (inventoryClickEvent.getClick() == ClickType.DROP) {
                arenaScript.setEventType((ArenaGameEventType)CollectionsUtil.next((Enum)arenaScript.getEventType()));
                ((ScriptCategory)this.object).save();
                this.openNextTick(menuViewer, menuViewer.getPage());
            }
        };
    }
}

