/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.shop;

import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.editor.shop.ShopProductListEditor;
import su.nightexpress.ama.arena.shop.impl.ShopCategory;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class ShopCategorySettingsEditor
extends EditorMenu<AMA, ShopCategory> {
    private ShopProductListEditor productsEditor;

    public ShopCategorySettingsEditor(@NotNull ShopCategory shopCategory) {
        super((NexPlugin)shopCategory.getShopManager().plugin(), (Object)shopCategory, "Arena Shop Editor", 45);
        this.addReturn(new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> shopCategory.getShopManager().getEditor().getCategoryListEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.NAME_TAG, EditorLocales.SHOP_CATEGORY_NAME, new int[]{20}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NAME, inputWrapper -> {
            shopCategory.setName(inputWrapper.getText());
            shopCategory.getShopManager().save();
            return true;
        }));
        this.addItem(Material.PAPER, EditorLocales.SHOP_CATEGORY_DESCRIPTION, new int[]{21}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                shopCategory.getDescription().clear();
                this.save(menuViewer);
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_DESCRIPTION, inputWrapper -> {
                shopCategory.getDescription().add(inputWrapper.getText());
                shopCategory.getShopManager().save();
                return true;
            });
        });
        this.addItem(Material.ITEM_FRAME, EditorLocales.SHOP_CATEGORY_ICON, new int[]{22}).setClick((menuViewer, inventoryClickEvent) -> {
            ItemStack itemStack = inventoryClickEvent.getCursor();
            if (itemStack == null || itemStack.getType().isAir()) {
                return;
            }
            shopCategory.setIcon(itemStack);
            inventoryClickEvent.getView().setCursor(null);
            this.save(menuViewer);
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(shopCategory.getIcon().getType()));
        this.addItem(Material.ARMOR_STAND, EditorLocales.SHOP_CATEGORY_ALLOWED_KITS, new int[]{23}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                shopCategory.getAllowedKits().clear();
                this.save(menuViewer);
                return;
            }
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), ((AMA)this.plugin).getKitManager().getKitIds(), (boolean)true);
            this.handleInput(menuViewer, Lang.EDITOR_KIT_ENTER_ID, inputWrapper -> {
                shopCategory.getAllowedKits().add(inputWrapper.getTextRaw());
                shopCategory.getShopManager().save();
                return true;
            });
        });
        this.addItem(Material.CHEST_MINECART, EditorLocales.SHOP_CATEGORY_PRODUCTS, new int[]{24}).setClick((menuViewer, inventoryClickEvent) -> this.getProductsEditor().openNextTick(menuViewer, 1));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)shopCategory.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((ShopCategory)this.object).getShopManager().save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }

    public void clear() {
        super.clear();
        if (this.productsEditor != null) {
            this.productsEditor.clear();
            this.productsEditor = null;
        }
    }

    @NotNull
    public ShopProductListEditor getProductsEditor() {
        if (this.productsEditor == null) {
            this.productsEditor = new ShopProductListEditor((ShopCategory)this.object);
        }
        return this.productsEditor;
    }

    public void onClick(@NotNull MenuViewer menuViewer, @Nullable ItemStack itemStack, @NotNull Menu.SlotType slotType, int n, @NotNull InventoryClickEvent inventoryClickEvent) {
        super.onClick(menuViewer, itemStack, slotType, n, inventoryClickEvent);
        if (slotType == Menu.SlotType.PLAYER || slotType == Menu.SlotType.PLAYER_EMPTY) {
            inventoryClickEvent.setCancelled(false);
        }
    }
}

