/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.shop;

import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.editor.shop.ShopCategoryListEditor;
import su.nightexpress.ama.arena.shop.ShopManager;
import su.nightexpress.ama.editor.EditorLocales;

public class ShopManagerEditor
extends EditorMenu<AMA, ShopManager> {
    private ShopCategoryListEditor categoryEditor;

    public ShopManagerEditor(@NotNull ShopManager shopManager) {
        super((NexPlugin)shopManager.plugin(), (Object)shopManager, "Arena Shop Editor", 45);
        this.addReturn(new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> shopManager.getArenaConfig().getEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.LIME_DYE, EditorLocales.SHOP_ACTIVE, new int[]{4}).setClick((menuViewer, inventoryClickEvent) -> {
            shopManager.setActive(!shopManager.isActive());
            this.save(menuViewer);
        }).getOptions().addDisplayModifier((menuViewer, itemStack) -> itemStack.setType(shopManager.isActive() ? Material.LIME_DYE : Material.GRAY_DYE));
        this.addItem(Material.ARMOR_STAND, EditorLocales.SHOP_HIDE_OTHER_KIT_ITEMS, new int[]{21}).setClick((menuViewer, inventoryClickEvent) -> {
            shopManager.setHideOtherKitProducts(!shopManager.isHideOtherKitProducts());
            this.save(menuViewer);
        });
        this.addItem(Material.CHEST_MINECART, EditorLocales.SHOP_CATEGORIES, new int[]{23}).setClick((menuViewer, inventoryClickEvent) -> this.getCategoryListEditor().openNextTick(menuViewer, 1));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)shopManager.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((ShopManager)this.object).save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }

    public void clear() {
        if (this.categoryEditor != null) {
            this.categoryEditor.clear();
            this.categoryEditor = null;
        }
        super.clear();
    }

    @NotNull
    public ShopCategoryListEditor getCategoryListEditor() {
        if (this.categoryEditor == null) {
            this.categoryEditor = new ShopCategoryListEditor((ShopManager)this.object);
        }
        return this.categoryEditor;
    }
}

