/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.spot;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.spot.ArenaSpot;
import su.nightexpress.ama.arena.spot.ArenaSpotManager;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class SpotListEditor
extends EditorMenu<AMA, ArenaSpotManager>
implements AutoPaged<ArenaSpot> {
    public SpotListEditor(@NotNull ArenaSpotManager arenaSpotManager) {
        super((NexPlugin)arenaSpotManager.plugin(), (Object)arenaSpotManager, "Arena Spot Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> arenaSpotManager.getArenaConfig().getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.SPOT_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_SPOT_ENTER_ID, inputWrapper -> {
            if (!arenaSpotManager.createSpot(StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw()))) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_SPOT_ERROR_EXISTS).getLocalized());
                return false;
            }
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((SpotListEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ArenaSpot> getObjects(@NotNull Player player) {
        return new ArrayList<ArenaSpot>(((ArenaSpotManager)this.object).getSpots());
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ArenaSpot arenaSpot) {
        ItemStack itemStack = new ItemStack(Material.END_PORTAL_FRAME);
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.SPOT_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.SPOT_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)arenaSpot.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ArenaSpot arenaSpot) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick() && inventoryClickEvent.isRightClick()) {
                ((ArenaSpotManager)this.object).removeSpot(arenaSpot);
                this.openNextTick(menuViewer, menuViewer.getPage());
                return;
            }
            arenaSpot.getEditor().openNextTick(menuViewer, 1);
        };
    }
}

