/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.supply;

import java.util.Comparator;
import java.util.List;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.supply.ArenaSupplyChest;
import su.nightexpress.ama.arena.supply.ArenaSupplyManager;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class SupplyChestListEditor
extends EditorMenu<AMA, ArenaSupplyManager>
implements AutoPaged<ArenaSupplyChest> {
    public SupplyChestListEditor(@NotNull ArenaSupplyManager arenaSupplyManager) {
        super((NexPlugin)((AMA)arenaSupplyManager.plugin()), (Object)arenaSupplyManager, "Arena Supply Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> arenaSupplyManager.getArenaConfig().getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
        this.addCreation(EditorLocales.SUPPLY_CHEST_CREATE, new int[]{41}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_SUPPLY_CHEST_ENTER_ID, inputWrapper -> {
            if (!arenaSupplyManager.createChest(StringUtil.lowerCaseUnderscore((String)inputWrapper.getTextRaw()))) {
                EditorManager.error((Player)menuViewer.getPlayer(), (String)((AMA)this.plugin).getMessage(Lang.EDITOR_SUPPLY_CHEST_ERROR_EXISTS).getLocalized());
                return false;
            }
            arenaSupplyManager.save();
            return true;
        }));
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((SupplyChestListEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<ArenaSupplyChest> getObjects(@NotNull Player player) {
        return ((ArenaSupplyManager)this.object).getChests().stream().sorted(Comparator.comparing(ArenaSupplyChest::getId)).toList();
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull ArenaSupplyChest arenaSupplyChest) {
        ItemStack itemStack = new ItemStack(Material.CHEST);
        arenaSupplyChest.getContainer().ifPresent(container -> itemStack.setType(container.getType()));
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.SUPPLY_CHEST_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.SUPPLY_CHEST_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, (UnaryOperator)arenaSupplyChest.replacePlaceholders());
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull ArenaSupplyChest arenaSupplyChest) {
        return (menuViewer, inventoryClickEvent) -> {
            Player player = menuViewer.getPlayer();
            if (inventoryClickEvent.isShiftClick()) {
                if (inventoryClickEvent.isRightClick()) {
                    ((ArenaSupplyManager)this.object).getChestsMap().remove(arenaSupplyChest.getId());
                    arenaSupplyChest.clear();
                    ((ArenaSupplyManager)this.object).save();
                    this.openNextTick(player, menuViewer.getPage());
                    return;
                }
                return;
            }
            if (inventoryClickEvent.isRightClick() && arenaSupplyChest.getLocation() != null) {
                player.teleport(arenaSupplyChest.getLocation());
                return;
            }
            arenaSupplyChest.getEditor().openNextTick(player, 1);
        };
    }
}

