/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.editor.wave;

import java.util.function.UnaryOperator;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.editor.wave.WavesGradualSettingsEditor;
import su.nightexpress.ama.arena.editor.wave.WavesListEditor;
import su.nightexpress.ama.arena.wave.ArenaWaveManager;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;

public class WaveManagerEditor
extends EditorMenu<AMA, ArenaWaveManager> {
    private WavesListEditor listEditor;
    private WavesGradualSettingsEditor gradualEditor;

    public WaveManagerEditor(@NotNull ArenaWaveManager arenaWaveManager) {
        super((NexPlugin)arenaWaveManager.plugin(), (Object)arenaWaveManager, "Arena Wave Editor", 54);
        this.addReturn(new int[]{49}).setClick((menuViewer, inventoryClickEvent) -> arenaWaveManager.getArenaConfig().getEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.CLOCK, EditorLocales.WAVES_ROUND_INTERVAL, new int[]{29}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_SECONDS, inputWrapper -> {
            if (inventoryClickEvent.isLeftClick()) {
                arenaWaveManager.setFirstRoundCountdown(inputWrapper.asInt());
            } else {
                arenaWaveManager.setRoundCountdown(inputWrapper.asInt());
            }
            arenaWaveManager.save();
            return true;
        }));
        this.addItem(Material.IRON_DOOR, EditorLocales.WAVES_FINAL_ROUND, new int[]{33}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                arenaWaveManager.setFinalRound(-1);
                arenaWaveManager.save();
                this.open(menuViewer.getPlayer(), menuViewer.getPage());
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NUMBER, inputWrapper -> {
                arenaWaveManager.setFinalRound(inputWrapper.asAnyInt(-1));
                arenaWaveManager.save();
                return true;
            });
        });
        this.addItem(Material.BLAZE_POWDER, EditorLocales.WAVES_WAVES, new int[]{31}).setClick((menuViewer, inventoryClickEvent) -> this.getListEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.OAK_SAPLING, EditorLocales.WAVES_GRADUAL, new int[]{13}).setClick((menuViewer, inventoryClickEvent) -> this.getGradualEditor().openNextTick(menuViewer, 1)).getOptions().addDisplayModifier((menuViewer, itemStack) -> {
            if (!arenaWaveManager.isGradualSpawnEnabled()) {
                itemStack.setType(Material.DEAD_BUSH);
            }
        });
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)arenaWaveManager.replacePlaceholders())));
    }

    public void clear() {
        if (this.listEditor != null) {
            this.listEditor.clear();
            this.listEditor = null;
        }
        if (this.gradualEditor != null) {
            this.gradualEditor.clear();
            this.gradualEditor = null;
        }
        super.clear();
    }

    @NotNull
    public WavesListEditor getListEditor() {
        if (this.listEditor == null) {
            this.listEditor = new WavesListEditor((ArenaWaveManager)this.object);
        }
        return this.listEditor;
    }

    @NotNull
    public WavesGradualSettingsEditor getGradualEditor() {
        if (this.gradualEditor == null) {
            this.gradualEditor = new WavesGradualSettingsEditor((ArenaWaveManager)this.object);
        }
        return this.gradualEditor;
    }
}

