/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.game;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.lang.LangKey;
import su.nexmedia.engine.api.manager.ConfigHolder;
import su.nexmedia.engine.api.manager.Loadable;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.command.CommandRegister;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.EngineUtils;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.Problematic;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.api.arena.type.ArenaTargetType;
import su.nightexpress.ama.arena.editor.game.GameplayEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.Parameters;
import su.nightexpress.ama.arena.script.action.ScriptActions;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ArenaScript;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.kit.Kit;

public class ArenaGameplayManager
implements ArenaChild,
ConfigHolder,
Loadable,
Problematic,
Placeholder {
    private final ArenaConfig arenaConfig;
    private final JYML config;
    private GameplayEditor editor;
    private int timeleft;
    private int lobbyTime;
    private boolean scoreboardEnabled;
    private String scoreboardId;
    private boolean isAnnouncesEnabled;
    private boolean isHungerEnabled;
    private boolean isRegenerationEnabled;
    private boolean isItemDropEnabled;
    private boolean isItemPickupEnabled;
    private boolean isItemDurabilityEnabled;
    private boolean isMobDropExpEnabled;
    private boolean isMobDropLootEnabled;
    private boolean isSpectateEnabled;
    private boolean mobHighlightEnabled;
    private double mobHighlightAmount;
    private ChatColor mobHighlightColor;
    private Set<Material> bannedItems;
    private Set<CreatureSpawnEvent.SpawnReason> allowedSpawnReasons;
    private int playerMinAmount;
    private int playerMaxAmount;
    private int playerLivesAmount;
    private int playerReviveTime;
    private boolean keepInventory;
    private boolean isPlayerCommandsEnabled;
    private Set<String> playerCommandsAllowed;
    private boolean isKitsEnabled;
    private Set<String> kitsAllowed;
    private Map<String, Integer> kitsLimits;
    private boolean petsAllowed;
    private boolean mcmmoAllowed;
    private final PlaceholderMap placeholderMap;
    private static final String CONFIG_NAME = "gameplay.yml";

    public ArenaGameplayManager(@NotNull ArenaConfig arenaConfig) {
        this.arenaConfig = arenaConfig;
        this.config = new JYML(arenaConfig.getFile().getParentFile().getAbsolutePath(), CONFIG_NAME);
        this.bannedItems = new HashSet<Material>();
        this.allowedSpawnReasons = new HashSet<CreatureSpawnEvent.SpawnReason>();
        this.playerCommandsAllowed = new HashSet<String>();
        this.kitsAllowed = new HashSet<String>();
        this.kitsLimits = new HashMap<String, Integer>();
        this.setMobHighlightColor(ChatColor.RED);
        this.placeholderMap = new PlaceholderMap().add("%problems%", () -> String.join((CharSequence)"\n", this.getProblems())).add("%gameplay_timeleft%", () -> this.hasTimeleft() ? NumberUtil.format((double)this.getTimeleft()) : LangManager.getPlain((LangKey)Lang.OTHER_INFINITY)).add("%gameplay_lobby_time%", () -> String.valueOf(this.getLobbyTime())).add("%gameplay_announcements%", () -> LangManager.getBoolean((boolean)this.isAnnouncesEnabled())).add("%gameplay_scoreboard_enabled%", () -> LangManager.getBoolean((boolean)this.isScoreboardEnabled())).add("%gameplay_scoreboard_id%", this::getScoreboardId).add("%gameplay_hunger_enabled%", () -> LangManager.getBoolean((boolean)this.isHungerEnabled())).add("%gameplay_regeneration_enabled%", () -> LangManager.getBoolean((boolean)this.isRegenerationEnabled())).add("%gameplay_item_drop_enabled%", () -> LangManager.getBoolean((boolean)this.isItemDropEnabled())).add("%gameplay_item_pickup_enabled%", () -> LangManager.getBoolean((boolean)this.isItemPickupEnabled())).add("%gameplay_item_durability_enabled%", () -> LangManager.getBoolean((boolean)this.isItemDurabilityEnabled())).add("%gameplay_mob_drop_exp%", () -> LangManager.getBoolean((boolean)this.isMobDropExpEnabled())).add("%gameplay_mob_drop_items%", () -> LangManager.getBoolean((boolean)this.isMobDropLootEnabled())).add("%gameplay_mob_highlight_enabled%", () -> LangManager.getBoolean((boolean)this.isMobHighlightEnabled())).add("%gameplay_mob_highlight_amount%", () -> NumberUtil.format((double)this.getMobHighlightAmount())).add("%gameplay_mob_highlight_color%", () -> this.getMobHighlightColor().name()).add("%gameplay_banned_items%", () -> String.join((CharSequence)"\n", this.getBannedItems().stream().map(Enum::name).toList())).add("%gameplay_allowed_spawn_reasons%", () -> String.join((CharSequence)"\n", this.getAllowedSpawnReasons().stream().map(Enum::name).toList())).add("%gameplay_players_amount_min%", () -> String.valueOf(this.getPlayerMinAmount())).add("%gameplay_players_amount_max%", () -> String.valueOf(this.getPlayerMaxAmount())).add("%gameplay_player_lifes_amount%", () -> String.valueOf(this.getPlayerLivesAmount())).add("%gameplay_player_revive_time%", () -> NumberUtil.format((double)this.getPlayerReviveTime())).add("%gameplay_keep_inventory%", () -> LangManager.getBoolean((boolean)this.isKeepInventory())).add("%gameplay_spectate_enabled%", () -> LangManager.getBoolean((boolean)this.isSpectateEnabled())).add("%gameplay_command_usage_enabled%", () -> LangManager.getBoolean((boolean)this.isPlayerCommandsEnabled())).add("%gameplay_command_usage_whitelist%", () -> String.join((CharSequence)"\n", this.getPlayerCommandsAllowed())).add("%gameplay_kits_enabled%", () -> LangManager.getBoolean((boolean)this.isKitsEnabled())).add("%gameplay_kits_allowed%", () -> String.join((CharSequence)"\n", this.getKitsAllowed())).add("%gameplay_kits_limits%", () -> String.join((CharSequence)"\n", this.getKitsLimits().entrySet().stream().map(entry -> (String)entry.getKey() + " " + entry.getValue()).toList())).add("%gameplay_pets_allowed%", () -> LangManager.getBoolean((boolean)this.isPetsAllowed())).add("%gameplay_mcmmo_allowed%", () -> LangManager.getBoolean((boolean)this.isMcmmoAllowed()));
    }

    public void setup() {
        Object object2;
        this.setTimeleft(this.config.getInt("Timeleft", 30));
        this.setLobbyTime(this.config.getInt("Lobby_Prepare_Time", 30));
        this.setAnnouncesEnabled(this.config.getBoolean("Announces_Enabled", true));
        this.setScoreboardEnabled(this.config.getBoolean("Scoreboard.Enabled", true));
        this.setScoreboardId(this.config.getString("Scoreboard.Id", "default"));
        this.setHungerEnabled(this.config.getBoolean("Hunger_Enabled"));
        this.setRegenerationEnabled(this.config.getBoolean("Regeneration_Enabled", true));
        this.setItemDropEnabled(this.config.getBoolean("Item_Drop_Enabled"));
        this.setItemPickupEnabled(this.config.getBoolean("Item_Pickup_Enabled"));
        this.setItemDurabilityEnabled(this.config.getBoolean("Item_Durability_Enabled"));
        this.setMobDropExpEnabled(this.config.getBoolean("Mob_Drop_Exp_Enabled"));
        this.setMobDropLootEnabled(this.config.getBoolean("Mob_Drop_Items_Enabled"));
        this.setMobHighlightEnabled(this.config.getBoolean("Mob_Highlight.Enabled"));
        this.setMobHighlightAmount(this.config.getDouble("Mob_Highlight.Amount"));
        this.setMobHighlightColor((ChatColor)this.config.getEnum("Mob_Highlight.Color", ChatColor.class, (Enum)ChatColor.RED));
        this.bannedItems = new HashSet<Material>(this.config.getStringSet("Banned_Items").stream().map(Material::getMaterial).filter(Objects::nonNull).toList());
        this.allowedSpawnReasons = new HashSet<CreatureSpawnEvent.SpawnReason>(this.config.getStringSet("Allowed_Spawn_Reasons").stream().map(string -> StringUtil.getEnum((String)string, CreatureSpawnEvent.SpawnReason.class).orElse(null)).filter(Objects::nonNull).toList());
        for (Object object2 : this.config.getSection("Auto_Commands")) {
            String string2 = "Auto_Commands." + (String)object2 + ".";
            Object object3 = (ArenaTargetType)this.config.getEnum((String)string2 + "Target", ArenaTargetType.class, (Enum)ArenaTargetType.GLOBAL);
            List list = this.config.getStringList((String)string2 + "Commands");
            for (String string3 : this.config.getSection((String)string2 + "Triggers")) {
                ArenaGameEventType arenaGameEventType = StringUtil.getEnum((String)string3, ArenaGameEventType.class).orElse(null);
                if (arenaGameEventType == null) continue;
                String string4 = "command_" + (String)object2;
                ArenaScript arenaScript = new ArenaScript(this.arenaConfig, string4, arenaGameEventType);
                String string5 = this.config.getString((String)string2 + "Triggers." + string3, "");
                Map<String, List<ScriptPreparedCondition>> map = ArenaScript.ofGameTrigger(arenaGameEventType, string5);
                arenaScript.getConditions().putAll(map);
                for (String string6 : list) {
                    ScriptPreparedAction scriptPreparedAction = new ScriptPreparedAction(ScriptActions.RUN_COMMAND, new ParameterResult());
                    scriptPreparedAction.getParameters().add(Parameters.NAME, string6);
                    scriptPreparedAction.getParameters().add(Parameters.TARGET, ((Enum)object3).name());
                    arenaScript.getActions().add(scriptPreparedAction);
                }
                this.getArenaConfig().getScriptManager().addConverted(arenaScript);
            }
            this.config.remove((String)string2 + "Triggers");
        }
        Object object4 = "Players.";
        this.setPlayerMinAmount(this.config.getInt((String)object4 + "Minimum", 1));
        this.setPlayerMaxAmount(this.config.getInt((String)object4 + "Maximum", 10));
        this.setPlayerLivesAmount(this.config.getInt((String)object4 + "Lives", 1));
        this.setPlayerReviveTime(this.config.getInt((String)object4 + "Revive_Time", -1));
        this.setKeepInventory(this.config.getBoolean("Keep_Inventory"));
        object4 = "Spectate.";
        this.setSpectateEnabled(this.config.getBoolean((String)object4 + "Enabled", true));
        object4 = "Commands.";
        this.setPlayerCommandsEnabled(this.config.getBoolean((String)object4 + "Allowed"));
        this.setPlayerCommandsAllowed(this.config.getStringSet((String)object4 + "Whitelist"));
        object4 = "Kits.";
        this.setKitsEnabled(this.config.getBoolean((String)object4 + "Enabled", true));
        this.setKitsAllowed(this.config.getStringSet((String)object4 + "Allowed"));
        if (this.isKitsEnabled() && this.getKitsAllowed().isEmpty()) {
            this.getKitsAllowed().add("*");
        }
        object2 = new HashMap();
        for (Object object3 : this.config.getSection((String)object4 + "Limits")) {
            object2.put(((String)object3).toLowerCase(), this.config.getInt((String)object4 + "Limits." + (String)object3));
        }
        this.setKitsLimits((Map<String, Integer>)object2);
        object4 = "Compatibility.";
        this.setPetsAllowed(this.config.getBoolean((String)object4 + "Pets_Enabled"));
        this.setMcmmoAllowed(this.config.getBoolean((String)object4 + "Mcmmo_Enabled"));
        this.config.saveChanges();
    }

    public void shutdown() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
    }

    public void onSave() {
        this.config.set("Timeleft", (Object)this.getTimeleft());
        this.config.set("Lobby_Prepare_Time", (Object)this.getLobbyTime());
        this.config.set("Announces_Enabled", (Object)this.isAnnouncesEnabled());
        this.config.set("Scoreboard.Enabled", (Object)this.isScoreboardEnabled());
        this.config.set("Scoreboard.Id", (Object)this.getScoreboardId());
        this.config.set("Hunger_Enabled", (Object)this.isHungerEnabled());
        this.config.set("Regeneration_Enabled", (Object)this.isRegenerationEnabled());
        this.config.set("Item_Drop_Enabled", (Object)this.isItemDropEnabled());
        this.config.set("Item_Pickup_Enabled", (Object)this.isItemPickupEnabled());
        this.config.set("Item_Durability_Enabled", (Object)this.isItemDurabilityEnabled());
        this.config.set("Mob_Drop_Exp_Enabled", (Object)this.isMobDropExpEnabled());
        this.config.set("Mob_Drop_Items_Enabled", (Object)this.isMobDropLootEnabled());
        this.config.set("Banned_Items", this.getBannedItems().stream().map(Enum::name).toList());
        this.config.set("Allowed_Spawn_Reasons", this.getAllowedSpawnReasons().stream().map(Enum::name).toList());
        this.config.set("Mob_Highlight.Enabled", (Object)this.isMobHighlightEnabled());
        this.config.set("Mob_Highlight.Amount", (Object)this.getMobHighlightAmount());
        this.config.set("Mob_Highlight.Color", (Object)this.getMobHighlightColor().name());
        String string = "Players.";
        this.config.set(string + "Minimum", (Object)this.getPlayerMinAmount());
        this.config.set(string + "Maximum", (Object)this.getPlayerMaxAmount());
        this.config.set(string + "Lives", (Object)this.getPlayerLivesAmount());
        this.config.set(string + "Revive_Time", (Object)this.getPlayerReviveTime());
        this.config.set("Keep_Inventory", (Object)this.isKeepInventory());
        string = "Spectate.";
        this.config.set(string + "Enabled", (Object)this.isSpectateEnabled());
        string = "Commands.";
        this.config.set(string + "Allowed", (Object)this.isPlayerCommandsEnabled());
        this.config.set(string + "Whitelist", this.getPlayerCommandsAllowed());
        this.config.set("Auto_Commands", null);
        string = "Kits.";
        this.config.set(string + "Enabled", (Object)this.isKitsEnabled());
        this.config.set(string + "Allowed", new ArrayList<String>(this.getKitsAllowed()));
        String string3 = string;
        this.config.set(string3 + "Limits", null);
        this.getKitsLimits().forEach((string2, n) -> this.config.set(string3 + "Limits." + string2, n));
        string = "Compatibility.";
        this.config.set(string + "Pets_Enabled", (Object)this.isPetsAllowed());
        this.config.set(string + "Mcmmo_Enabled", (Object)this.isMcmmoAllowed());
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @NotNull
    public GameplayEditor getEditor() {
        if (this.editor == null) {
            this.editor = new GameplayEditor(this);
        }
        return this.editor;
    }

    @NotNull
    public JYML getConfig() {
        return this.config;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.isKitsEnabled() && this.getKitsAllowed().isEmpty()) {
            arrayList.add(this.problem("Kits are enabled, but no kits are allowed!"));
        }
        return arrayList;
    }

    public int getTimeleft() {
        return this.timeleft;
    }

    public boolean hasTimeleft() {
        return this.getTimeleft() > 0;
    }

    public void setTimeleft(int n) {
        this.timeleft = n;
    }

    public int getLobbyTime() {
        return this.lobbyTime;
    }

    public void setLobbyTime(int n) {
        this.lobbyTime = Math.max(1, n);
    }

    public boolean isAnnouncesEnabled() {
        return this.isAnnouncesEnabled;
    }

    public void setAnnouncesEnabled(boolean bl) {
        this.isAnnouncesEnabled = bl;
    }

    public boolean isScoreboardEnabled() {
        return this.scoreboardEnabled;
    }

    public void setScoreboardEnabled(boolean bl) {
        this.scoreboardEnabled = bl && EngineUtils.hasPlugin((String)"ProtocolLib");
    }

    @NotNull
    public String getScoreboardId() {
        return this.scoreboardId;
    }

    public void setScoreboardId(@NotNull String string) {
        this.scoreboardId = string;
    }

    public boolean isHungerEnabled() {
        return this.isHungerEnabled;
    }

    public void setHungerEnabled(boolean bl) {
        this.isHungerEnabled = bl;
    }

    public boolean isRegenerationEnabled() {
        return this.isRegenerationEnabled;
    }

    public void setRegenerationEnabled(boolean bl) {
        this.isRegenerationEnabled = bl;
    }

    public boolean isItemDropEnabled() {
        return this.isItemDropEnabled;
    }

    public void setItemDropEnabled(boolean bl) {
        this.isItemDropEnabled = bl;
    }

    public boolean isItemPickupEnabled() {
        return this.isItemPickupEnabled;
    }

    public void setItemPickupEnabled(boolean bl) {
        this.isItemPickupEnabled = bl;
    }

    public boolean isItemDurabilityEnabled() {
        return this.isItemDurabilityEnabled;
    }

    public void setItemDurabilityEnabled(boolean bl) {
        this.isItemDurabilityEnabled = bl;
    }

    @NotNull
    public Set<Material> getBannedItems() {
        return this.bannedItems;
    }

    @NotNull
    public Set<CreatureSpawnEvent.SpawnReason> getAllowedSpawnReasons() {
        return this.allowedSpawnReasons;
    }

    public boolean isAllowedSpawnReason(@NotNull CreatureSpawnEvent.SpawnReason spawnReason) {
        return this.getAllowedSpawnReasons().contains(spawnReason);
    }

    public boolean isMobDropExpEnabled() {
        return this.isMobDropExpEnabled;
    }

    public void setMobDropExpEnabled(boolean bl) {
        this.isMobDropExpEnabled = bl;
    }

    public boolean isMobDropLootEnabled() {
        return this.isMobDropLootEnabled;
    }

    public void setMobDropLootEnabled(boolean bl) {
        this.isMobDropLootEnabled = bl;
    }

    public boolean isMobHighlightEnabled() {
        return this.mobHighlightEnabled;
    }

    public void setMobHighlightEnabled(boolean bl) {
        this.mobHighlightEnabled = bl;
    }

    public double getMobHighlightAmount() {
        return this.mobHighlightAmount;
    }

    public void setMobHighlightAmount(double d) {
        this.mobHighlightAmount = d;
    }

    @NotNull
    public ChatColor getMobHighlightColor() {
        return this.mobHighlightColor;
    }

    public void setMobHighlightColor(@NotNull ChatColor chatColor) {
        this.mobHighlightColor = chatColor;
    }

    public int getPlayerMinAmount() {
        return this.playerMinAmount;
    }

    public void setPlayerMinAmount(int n) {
        this.playerMinAmount = Math.max(1, n);
    }

    public int getPlayerMaxAmount() {
        return this.playerMaxAmount;
    }

    public void setPlayerMaxAmount(int n) {
        this.playerMaxAmount = Math.max(1, n);
    }

    public int getPlayerLivesAmount() {
        return this.playerLivesAmount;
    }

    public void setPlayerLivesAmount(int n) {
        this.playerLivesAmount = Math.max(1, n);
    }

    public int getPlayerReviveTime() {
        return this.playerReviveTime;
    }

    public void setPlayerReviveTime(int n) {
        this.playerReviveTime = n;
    }

    public boolean isKeepInventory() {
        return this.keepInventory;
    }

    public void setKeepInventory(boolean bl) {
        this.keepInventory = bl;
    }

    public boolean isPlayerCommandsEnabled() {
        return this.isPlayerCommandsEnabled;
    }

    public void setPlayerCommandsEnabled(boolean bl) {
        this.isPlayerCommandsEnabled = bl;
    }

    @NotNull
    public Set<String> getPlayerCommandsAllowed() {
        return this.playerCommandsAllowed;
    }

    public void setPlayerCommandsAllowed(@NotNull Set<String> set) {
        this.playerCommandsAllowed = set;
    }

    public boolean isPlayerCommandAllowed(@NotNull String string2) {
        Set set = CommandRegister.getAliases((String)string2, (boolean)true);
        return set.stream().anyMatch(string -> this.getPlayerCommandsAllowed().contains(string));
    }

    public boolean isSpectateEnabled() {
        return this.isSpectateEnabled;
    }

    public void setSpectateEnabled(boolean bl) {
        this.isSpectateEnabled = bl;
    }

    public boolean isKitsEnabled() {
        return this.isKitsEnabled;
    }

    public void setKitsEnabled(boolean bl) {
        this.isKitsEnabled = bl;
    }

    @NotNull
    public Set<String> getKitsAllowed() {
        return this.kitsAllowed;
    }

    public void setKitsAllowed(@NotNull Set<String> set) {
        this.kitsAllowed = set;
    }

    public boolean isKitAllowed(@NotNull Kit kit) {
        return this.isKitAllowed(kit.getId());
    }

    public boolean isKitAllowed(@NotNull String string) {
        return this.getKitsAllowed().contains(string) || this.getKitsAllowed().contains("*");
    }

    @NotNull
    public Map<String, Integer> getKitsLimits() {
        return this.kitsLimits;
    }

    public void setKitsLimits(@NotNull Map<String, Integer> map) {
        this.kitsLimits = map;
    }

    public int getKitLimit(@NotNull Kit kit) {
        return this.getKitLimit(kit.getId());
    }

    public int getKitLimit(@NotNull String string) {
        return this.getKitsLimits().getOrDefault(string, -1);
    }

    public boolean isPetsAllowed() {
        return this.petsAllowed;
    }

    public void setPetsAllowed(boolean bl) {
        this.petsAllowed = bl;
    }

    public boolean isMcmmoAllowed() {
        return this.mcmmoAllowed;
    }

    public void setMcmmoAllowed(boolean bl) {
        this.mcmmoAllowed = bl;
    }
}

