/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.impl;

import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Particle;
import org.bukkit.attribute.Attribute;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.permissions.Permission;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.api.lang.LangKey;
import su.nexmedia.engine.api.lang.LangMessage;
import su.nexmedia.engine.api.particle.SimpleParticle;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.EntityUtil;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.PlayerUtil;
import su.nexmedia.engine.utils.TimeUtil;
import su.nexmedia.engine.utils.random.Rnd;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.IArena;
import su.nightexpress.ama.api.MobList;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.api.arena.type.ArenaLocationType;
import su.nightexpress.ama.api.arena.type.ArenaTargetType;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.api.event.ArenaGameEndEvent;
import su.nightexpress.ama.api.event.ArenaGameGenericEvent;
import su.nightexpress.ama.api.event.ArenaGameStartEvent;
import su.nightexpress.ama.api.event.ArenaMobDeathEvent;
import su.nightexpress.ama.api.event.ArenaPlayerJoinEvent;
import su.nightexpress.ama.api.event.ArenaPlayerLeaveEvent;
import su.nightexpress.ama.api.event.ArenaPlayerSpectateEvent;
import su.nightexpress.ama.api.event.ArenaRegionEvent;
import su.nightexpress.ama.api.event.ArenaScoreChangeEvent;
import su.nightexpress.ama.api.event.ArenaWaveCompleteEvent;
import su.nightexpress.ama.api.event.ArenaWaveStartEvent;
import su.nightexpress.ama.api.type.GameResult;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.api.type.MobFaction;
import su.nightexpress.ama.api.type.PlayerType;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.impl.ArenaUpcomingWave;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.arena.util.ArenaUtils;
import su.nightexpress.ama.arena.util.LobbyItem;
import su.nightexpress.ama.arena.util.PlayerSnapshot;
import su.nightexpress.ama.arena.wave.ArenaWaveManager;
import su.nightexpress.ama.arena.wave.ArenaWaveMob;
import su.nightexpress.ama.config.Config;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.hook.level.PlayerLevelProvider;
import su.nightexpress.ama.hook.mob.MobProvider;
import su.nightexpress.ama.kit.Kit;
import su.nightexpress.ama.mob.MobManager;
import su.nightexpress.ama.sign.SignManager;
import su.nightexpress.ama.sign.type.SignType;
import su.nightexpress.ama.stats.object.StatType;

public class Arena
implements IArena,
Placeholder {
    private final AMA plugin;
    private final ArenaConfig config;
    private final Set<ArenaPlayer> players;
    private final MobList mobs;
    private final Set<Item> groundItems;
    private final Set<ArenaUpcomingWave> waveUpcoming;
    private final Map<String, double[]> waveAmplificatorValues;
    private final PlaceholderMap placeholderMap;
    private GameState state;
    private GameResult gameResult;
    private int lobbyCountdown;
    private int endCountdown;
    private long gameTimeleft;
    private int gameScore;
    private boolean mobsAboutToSpawn;
    private int gradualMobsTimer;
    private int gradualMobsPrepare;
    private int gradualMobsKilled;
    private int roundNumber;
    private int nextRoundCountdown;
    private int skipRounds;
    private int roundTotalMobsAmount;
    private static final DateTimeFormatter FORMAT_TIMELEFT = DateTimeFormatter.ofPattern("HH:mm:ss");

    public Arena(@NotNull ArenaConfig arenaConfig) {
        this.plugin = (AMA)arenaConfig.plugin();
        this.config = arenaConfig;
        this.players = new HashSet<ArenaPlayer>();
        this.mobs = new MobList();
        this.groundItems = new HashSet<Item>();
        this.waveUpcoming = new HashSet<ArenaUpcomingWave>();
        this.waveAmplificatorValues = new HashMap<String, double[]>();
        this.placeholderMap = new PlaceholderMap().add("%arena_state%", () -> this.plugin().getLangManager().getEnum((Enum)this.getState())).add("%arena_players%", () -> String.valueOf(this.getPlayers(PlayerType.REAL).size())).add("%arena_real_players%", () -> String.valueOf(this.getPlayers(PlayerType.REAL).size())).add("%arena_ghost_players%", () -> String.valueOf(this.getPlayers(PlayerType.GHOST).size())).add("%arena_dead_players%", () -> String.valueOf(this.getDeadPlayers().size())).add("%arena_alive_players%", () -> String.valueOf(this.getAlivePlayers().size())).add("%arena_players_max%", () -> String.valueOf(this.getConfig().getGameplayManager().getPlayerMaxAmount())).add("%arena_mobs_alive%", () -> String.valueOf(this.getMobs().getEnemies().size())).add("%arena_mobs_left%", () -> String.valueOf(this.getMobsAwaitingSpawn())).add("%arena_mobs_total%", () -> String.valueOf(this.getRoundTotalMobsAmount())).add("%arena_wave_number%", () -> String.valueOf(this.getRoundNumber())).add("%arena_wave_next_in%", () -> String.valueOf(this.getNextRoundCountdown())).add("%arena_end_countdown%", () -> String.valueOf(this.getEndCountdown())).add("%arena_timeleft%", () -> {
            if (this.getConfig().getGameplayManager().hasTimeleft()) {
                return TimeUtil.getLocalTimeOf((long)this.getGameTimeleft()).format(FORMAT_TIMELEFT);
            }
            return LangManager.getPlain((LangKey)Lang.OTHER_INFINITY);
        }).add("%arena_score%", () -> String.valueOf(this.getGameScore()));
        this.placeholderMap.getKeys().addAll(this.getConfig().getPlaceholders().getKeys());
    }

    @NotNull
    public AMA plugin() {
        return this.plugin;
    }

    @NotNull
    public ArenaConfig getConfig() {
        return this.config;
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @NotNull
    public String getId() {
        return this.getConfig().getId();
    }

    @NotNull
    public GameState getState() {
        return this.state;
    }

    private void setState(@NotNull GameState gameState) {
        this.state = gameState;
    }

    public int getLobbyCountdown() {
        return this.lobbyCountdown;
    }

    public void setLobbyCountdown(int n) {
        this.lobbyCountdown = Math.max(0, n);
    }

    public int getEndCountdown() {
        return this.endCountdown;
    }

    public void setEndCountdown(int n, @NotNull GameResult gameResult) {
        this.endCountdown = n;
        this.gameResult = gameResult;
    }

    public long getGameTimeleft() {
        return this.gameTimeleft;
    }

    public void setGameTimeleft(long l) {
        this.gameTimeleft = l;
    }

    public int getGameScore() {
        return this.gameScore;
    }

    public void setGameScore(int n) {
        this.gameScore = n;
    }

    @NotNull
    public Set<ArenaUpcomingWave> getUpcomingWaves() {
        return this.waveUpcoming;
    }

    private int getGradualMobsKilled() {
        return this.gradualMobsKilled;
    }

    private void setGradualMobsKilled(int n) {
        this.gradualMobsKilled = n;
    }

    @NotNull
    public Map<String, double[]> getWaveAmplificatorValues() {
        return this.waveAmplificatorValues;
    }

    public int getRoundTotalMobsAmount() {
        return this.roundTotalMobsAmount;
    }

    public void setRoundTotalMobsAmount(int n) {
        this.roundTotalMobsAmount = n;
    }

    public int getRoundNumber() {
        return this.roundNumber;
    }

    private void setRoundNumber(int n) {
        this.roundNumber = n;
    }

    public int getNextRoundCountdown() {
        return this.nextRoundCountdown;
    }

    public void setNextRoundCountdown(int n) {
        this.nextRoundCountdown = Math.max(0, n);
    }

    public int getSkipRounds() {
        return this.skipRounds;
    }

    public void setSkipRounds(int n) {
        this.skipRounds = Math.max(0, n);
    }

    @Override
    @NotNull
    public MobList getMobs() {
        return this.mobs;
    }

    @NotNull
    public Set<Item> getGroundItems() {
        return this.groundItems;
    }

    void reset() {
        this.killMobs();
        this.killGroundItems();
        int n = this.getConfig().getGameplayManager().getTimeleft();
        this.setLobbyCountdown(this.getConfig().getGameplayManager().getLobbyTime());
        this.setEndCountdown(-1, GameResult.NONE);
        this.setGameTimeleft(n > 0 ? (long)n * 1000L * 60L : -1L);
        this.setGameScore(0);
        this.setRoundNumber(0);
        this.setSkipRounds(0);
        this.setNextRoundCountdown(this.getConfig().getWaveManager().getFirstRoundCountdown());
        this.getUpcomingWaves().clear();
        this.getWaveAmplificatorValues().clear();
        this.setRoundTotalMobsAmount(0);
        this.gradualMobsTimer = 0;
        this.setGradualMobsKilled(0);
        this.gradualMobsPrepare = 0;
        ArenaUtils.getHighlightTeam(this, false).ifPresent(team -> {
            team.getEntries().forEach(arg_0 -> ((Team)team).removeEntry(arg_0));
            team.unregister();
        });
        this.mobsAboutToSpawn = false;
        this.emptySupplyChests();
        this.setState(GameState.WAITING);
        this.updateSigns();
        this.updateHolograms();
    }

    public void stop() {
        if (this.getState() == GameState.INGAME) {
            ArenaGameEndEvent arenaGameEndEvent = new ArenaGameEndEvent(this, this.gameResult);
            this.plugin.getPluginManager().callEvent((Event)arenaGameEndEvent);
            if (this.getConfig().getGameplayManager().isAnnouncesEnabled()) {
                this.plugin.getMessage(Lang.Arena_Game_Announce_End).replace(this.replacePlaceholders()).broadcast();
            }
        }
        this.getPlayers(PlayerType.ALL).forEach(arenaPlayer -> {
            if (!arenaPlayer.isGhost() && this.gameResult == GameResult.VICTORY) {
                arenaPlayer.addStats(StatType.GAMES_WON, 1);
            }
            if (this.getRoundNumber() > 0) {
                arenaPlayer.addStats(StatType.GAMES_PLAYED, 1);
            }
            this.leaveArena((ArenaPlayer)arenaPlayer);
        });
        this.reset();
    }

    public void updateSigns() {
        SignManager signManager = this.plugin.getSignManager();
        if (signManager == null) {
            return;
        }
        signManager.update(SignType.ARENA_JOIN);
    }

    public void updateHolograms() {
        this.getConfig().updateHolograms();
    }

    public void updateGameScore() {
        int n = this.getGameScore();
        int n2 = this.getPlayers(GameState.INGAME, PlayerType.REAL).stream().mapToInt(ArenaPlayer::getScore).sum();
        this.setGameScore(n2);
        ArenaScoreChangeEvent arenaScoreChangeEvent = new ArenaScoreChangeEvent(this, n, this.getGameScore());
        this.plugin.getPluginManager().callEvent((Event)arenaScoreChangeEvent);
    }

    public void emptySupplyChests() {
        this.getConfig().getSupplyManager().emptyChests();
    }

    public boolean hasPermission(@NotNull Player player) {
        return !this.getConfig().isPermissionRequired() || player.hasPermission(this.getConfig().getPermission());
    }

    public boolean isAboutToSpawnMobs() {
        return this.mobsAboutToSpawn;
    }

    public boolean isAboutToSkipRound() {
        return this.getSkipRounds() > 0;
    }

    public boolean isAboutToEnd() {
        return this.getEndCountdown() >= 0;
    }

    public boolean isAwaitingNewRound() {
        return this.getRoundNumber() < 1 || !this.getMobs().hasAliveEnemies() && this.getUpcomingWaves().isEmpty();
    }

    public boolean isLatestWave() {
        return this.getRoundNumber() == this.getConfig().getWaveManager().getFinalRound();
    }

    @Deprecated
    @NotNull
    public ArenaPlayer getHighScore(int n) {
        n = Math.max(0, n - 1);
        HashMap<ArenaPlayer, Integer> hashMap = new HashMap<ArenaPlayer, Integer>();
        for (ArenaPlayer object : this.getPlayers(GameState.INGAME, PlayerType.ALL)) {
            hashMap.put(object, object.getScore());
        }
        int n2 = 0;
        for (ArenaPlayer arenaPlayer : CollectionsUtil.sortDescent(hashMap).keySet()) {
            if (n2 != n) continue;
            return arenaPlayer;
        }
        return new ArrayList<ArenaPlayer>(this.getPlayers(GameState.INGAME, PlayerType.ALL)).get(0);
    }

    @NotNull
    public Set<ArenaPlayer> getPlayers(@NotNull ArenaTargetType arenaTargetType, @NotNull PlayerType playerType) {
        if (arenaTargetType == ArenaTargetType.PLAYER_ALL) {
            return this.getPlayers(GameState.INGAME, playerType);
        }
        if (arenaTargetType == ArenaTargetType.PLAYER_RANDOM && !this.getPlayers(GameState.INGAME, playerType).isEmpty()) {
            return Stream.of((ArenaPlayer)Rnd.get(this.getPlayers(GameState.INGAME, playerType))).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    @NotNull
    public Set<ArenaPlayer> getPlayers(@NotNull PlayerType playerType) {
        HashSet<ArenaPlayer> hashSet = new HashSet<ArenaPlayer>(this.players);
        if (playerType == PlayerType.GHOST) {
            hashSet.removeIf(ArenaPlayer::isReal);
        } else if (playerType == PlayerType.REAL) {
            hashSet.removeIf(ArenaPlayer::isGhost);
        }
        return hashSet;
    }

    @NotNull
    public Set<ArenaPlayer> getPlayers(@NotNull GameState gameState, @NotNull PlayerType playerType) {
        return this.getPlayers(playerType).stream().filter(arenaPlayer -> arenaPlayer.getState() == gameState).collect(Collectors.toSet());
    }

    @NotNull
    public Set<ArenaPlayer> getDeadPlayers() {
        return this.getPlayers(GameState.INGAME, PlayerType.REAL).stream().filter(ArenaPlayer::isDead).collect(Collectors.toSet());
    }

    @NotNull
    public Set<ArenaPlayer> getAlivePlayers() {
        return this.getPlayers(GameState.INGAME, PlayerType.REAL).stream().filter(Predicate.not(ArenaPlayer::isDead)).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public Set<Player> getAliveGamePlayers() {
        return this.getAlivePlayers().stream().map(ArenaPlayer::getPlayer).collect(Collectors.toSet());
    }

    @Nullable
    public ArenaPlayer getPlayerRandom() {
        Set<ArenaPlayer> set = this.getAlivePlayers();
        return set.isEmpty() ? null : (ArenaPlayer)Rnd.get(new ArrayList<ArenaPlayer>(set));
    }

    public int getMobsAwaitingSpawn() {
        return this.getUpcomingWaves().stream().filter(Predicate.not(ArenaUpcomingWave::isAllMobsSpawned)).mapToInt(ArenaUpcomingWave::getMobsAmount).sum();
    }

    public double[] getWaveAmplificatorValues(@NotNull String string2) {
        return this.getWaveAmplificatorValues().computeIfAbsent(string2.toLowerCase(), string -> new double[2]);
    }

    public double getWaveAmplificatorAmount(@NotNull String string) {
        return this.getWaveAmplificatorValues(string)[0];
    }

    public void addWaveAmplificatorAmount(@NotNull String string, int n) {
        double[] dArray = this.getWaveAmplificatorValues(string);
        dArray[0] = dArray[0] + (double)n;
    }

    public double getWaveAmplificatorLevel(@NotNull String string) {
        return this.getWaveAmplificatorValues(string)[1];
    }

    public void addWaveAmplificatorLevel(@NotNull String string, int n) {
        double[] dArray = this.getWaveAmplificatorValues(string);
        dArray[1] = dArray[1] + (double)n;
    }

    public void onArenaGameEvent(@NotNull ArenaGameGenericEvent arenaGameGenericEvent) {
        ArenaGameEventType arenaGameEventType;
        if (this.getState() == GameState.INGAME) {
            this.getConfig().getScriptManager().getScripts().forEach(arenaScript -> arenaScript.onArenaEvent(arenaGameGenericEvent));
        }
        if ((arenaGameEventType = arenaGameGenericEvent.getEventType()) == ArenaGameEventType.GAME_END_LOSE || arenaGameEventType == ArenaGameEventType.GAME_END_TIME || arenaGameEventType == ArenaGameEventType.GAME_END_WIN || arenaGameEventType == ArenaGameEventType.GAME_START || arenaGameEventType == ArenaGameEventType.PLAYER_JOIN || arenaGameEventType == ArenaGameEventType.PLAYER_LEAVE) {
            this.updateSigns();
            this.updateHolograms();
        }
        if (arenaGameGenericEvent.getEventType() == ArenaGameEventType.REGION_UNLOCKED) {
            ArenaRegionEvent arenaRegionEvent = (ArenaRegionEvent)arenaGameGenericEvent;
            this.broadcast(ArenaTargetType.PLAYER_ALL, this.plugin.getMessage(Lang.ARENA_REGION_UNLOCKED_NOTIFY).replace(arenaRegionEvent.getArenaRegion().replacePlaceholders()));
            return;
        }
        if (arenaGameGenericEvent.getEventType() == ArenaGameEventType.MOB_KILLED) {
            if (arenaGameGenericEvent instanceof ArenaMobDeathEvent) {
                ArenaMobDeathEvent arenaMobDeathEvent = (ArenaMobDeathEvent)arenaGameGenericEvent;
                this.getMobs().remove(arenaMobDeathEvent.getEntity());
            }
            this.countGradual();
        }
    }

    public final void tick() {
        this.tickLobby();
        this.tickGame();
    }

    public void tickOpenCloseTimes() {
        if (this.getConfig().hasProblems()) {
            return;
        }
        if (this.tickTimes(this.getConfig().getAutoOpenTimes())) {
            this.getConfig().setActive(true);
        } else if (this.tickTimes(this.getConfig().getAutoCloseTimes())) {
            this.getConfig().setActive(false);
        } else {
            return;
        }
        this.getConfig().save();
        this.plugin.getMessage(this.getConfig().isActive() ? Lang.ARENA_SCHEDULER_OPEN_ANNOUNCE : Lang.ARENA_SCHEDULER_CLOSE_ANNOUNCE).replace(this.getConfig().replacePlaceholders()).broadcast();
    }

    private boolean tickTimes(@NotNull Map<DayOfWeek, Set<LocalTime>> map) {
        if (map.isEmpty()) {
            return false;
        }
        LocalDateTime localDateTime = LocalDateTime.now();
        while (!map.containsKey(localDateTime.getDayOfWeek())) {
            localDateTime = localDateTime.plusDays(1L);
        }
        Set<LocalTime> set = map.get(localDateTime.getDayOfWeek());
        if (set == null || set.isEmpty()) {
            return false;
        }
        LocalDateTime localDateTime2 = LocalDateTime.now().truncatedTo(ChronoUnit.MINUTES);
        return localDateTime2.equals(localDateTime.truncatedTo(ChronoUnit.MINUTES));
    }

    public void tickLobby() {
        if (this.getState() == GameState.INGAME) {
            return;
        }
        if (this.getState() == GameState.WAITING && this.getPlayers(PlayerType.REAL).size() >= this.getConfig().getGameplayManager().getPlayerMinAmount()) {
            this.setState(GameState.READY);
            if (this.getConfig().getGameplayManager().isAnnouncesEnabled()) {
                this.plugin().getMessage(Lang.Arena_Game_Announce_Start).replace(this.replacePlaceholders()).replace("%time%", (Object)this.getConfig().getGameplayManager().getLobbyTime()).broadcast();
            }
        }
        if (this.getState() != GameState.READY) {
            return;
        }
        if (this.getPlayers(PlayerType.REAL).size() < this.getConfig().getGameplayManager().getPlayerMinAmount()) {
            this.setState(GameState.WAITING);
            this.setLobbyCountdown(this.getConfig().getGameplayManager().getLobbyTime());
            this.updateSigns();
            return;
        }
        int n = this.getLobbyCountdown();
        boolean bl = this.getPlayers(PlayerType.REAL).stream().allMatch(ArenaPlayer::isReady);
        if ((Integer)Config.LOBBY_READY_DROP_TIMER.get() > 0) {
            if (bl) {
                if (n > (Integer)Config.LOBBY_READY_DROP_TIMER.get()) {
                    n = (Integer)Config.LOBBY_READY_DROP_TIMER.get();
                }
            } else if (((Boolean)Config.LOBBY_READY_FREEZE_TIMER_WHEN_DROPPED.get()).booleanValue() && n > 0 && n <= (Integer)Config.LOBBY_READY_DROP_TIMER.get()) {
                return;
            }
        }
        if (n <= 0) {
            this.getPlayers(PlayerType.REAL).forEach(this::joinGame);
            this.setState(GameState.INGAME);
            ArenaGameStartEvent arenaGameStartEvent = new ArenaGameStartEvent(this);
            this.plugin().getPluginManager().callEvent((Event)arenaGameStartEvent);
            return;
        }
        if (n % 15 == 0 || n % 10 == 0 || n <= 10) {
            for (ArenaPlayer arenaPlayer : this.getPlayers(PlayerType.ALL)) {
                this.plugin().getMessage(Lang.Arena_Game_Lobby_Timer).replace("%time%", (Object)n).send((CommandSender)arenaPlayer.getPlayer());
            }
        }
        this.setLobbyCountdown(n - 1);
    }

    private void tickGame() {
        if (this.getState() != GameState.INGAME) {
            return;
        }
        if (this.isAboutToEnd()) {
            --this.endCountdown;
            this.showGameStatus();
            if (this.endCountdown <= 0) {
                this.stop();
            }
            return;
        }
        this.showGameStatus();
        if (this.getGameTimeleft() > 0L) {
            this.setGameTimeleft(Math.max(0L, this.getGameTimeleft() - 1000L));
            if (this.getGameTimeleft() <= 0L) {
                this.setEndCountdown((Integer)Config.ARENA_END_COUNTDOWN_DEFEAT.get(), GameResult.DEFEAT);
                this.broadcast(this.plugin.getMessage(Lang.ARENA_GAME_END_TIMEOUT).replace(this.replacePlaceholders()));
                return;
            }
        }
        this.tickMobs();
        if (!this.tickPlayers()) {
            return;
        }
        if (!this.getConfig().getGameplayManager().isItemPickupEnabled()) {
            this.burnGroundItems();
        }
        if (this.getNextRoundCountdown() == 0) {
            this.newRound();
            ArenaRegion arenaRegion = this.getConfig().getRegionManager().getFirstUnlocked();
            if (arenaRegion == null) {
                this.stop();
                return;
            }
            return;
        }
        if (this.isAboutToSkipRound()) {
            this.getUpcomingWaves().clear();
            this.killMobs(MobFaction.ENEMY);
        }
        if (this.isAwaitingNewRound()) {
            if (this.getNextRoundCountdown() == this.getConfig().getWaveManager().getRoundCountdown()) {
                ArenaWaveCompleteEvent arenaWaveCompleteEvent = new ArenaWaveCompleteEvent(this);
                this.plugin.getPluginManager().callEvent((Event)arenaWaveCompleteEvent);
                this.getDeadPlayers().forEach(ArenaPlayer::revive);
                this.getPlayers(GameState.READY, PlayerType.REAL).forEach(this::joinGame);
                if (this.isLatestWave()) {
                    this.setEndCountdown((Integer)Config.ARENA_END_COUNTDOWN_VICTORY.get(), GameResult.VICTORY);
                    this.broadcast(this.plugin.getMessage(Lang.ARENA_GAME_END_COMPLETED).replace(this.replacePlaceholders()));
                    return;
                }
            }
            if (this.isAboutToSkipRound()) {
                this.setNextRoundCountdown(1);
                this.setSkipRounds(this.getSkipRounds() - 1);
            }
            this.setNextRoundCountdown(this.getNextRoundCountdown() - 1);
        }
    }

    private boolean tickPlayers() {
        if (this.getAlivePlayers().isEmpty() && this.getDeadPlayers().stream().noneMatch(ArenaPlayer::isAutoRevive)) {
            this.setEndCountdown((Integer)Config.ARENA_END_COUNTDOWN_DEFEAT.get(), GameResult.DEFEAT);
            this.broadcast(this.plugin.getMessage(Lang.ARENA_GAME_END_ALL_DEAD).replace(this.replacePlaceholders()));
            return false;
        }
        for (ArenaPlayer arenaPlayer : this.getPlayers(GameState.INGAME, PlayerType.ALL)) {
            ArenaRegion arenaRegion;
            arenaPlayer.tick();
            if (!this.isAwaitingNewRound() || arenaPlayer.isGhost() || (arenaRegion = arenaPlayer.getRegion()) != null && !arenaRegion.isLocked()) continue;
            this.plugin.getMessage(Lang.ARENA_REGION_LOCKED_NOTIFY).send((CommandSender)arenaPlayer.getPlayer());
        }
        return true;
    }

    private void tickMobs() {
        double d;
        if (this.getConfig().getWaveManager().isGradualSpawnEnabled() && ++this.gradualMobsTimer % this.getConfig().getWaveManager().getGradualSpawnNextInterval() == 0) {
            this.gradualMobsTimer = 0;
            if (this.gradualMobsPrepare > 0) {
                d = this.getConfig().getWaveManager().getGradualSpawnNextPercent();
                this.spawnMobs(d);
                --this.gradualMobsPrepare;
            }
        }
        this.getMobs().getEnemies().removeIf(livingEntity -> {
            if (!livingEntity.isValid() || livingEntity.isDead()) {
                this.countGradual();
                return true;
            }
            return false;
        });
        if (this.getConfig().getGameplayManager().isMobHighlightEnabled()) {
            double d2;
            d = this.getMobs().getEnemies().size();
            double d3 = d / (d2 = (double)this.getRoundTotalMobsAmount()) * 100.0;
            this.highlightMobs(d3 <= this.getConfig().getGameplayManager().getMobHighlightAmount());
        }
    }

    private void showGameStatus() {
        if (this.isAboutToEnd()) {
            this.broadcast(this.plugin.getMessage(Lang.ARENA_GAME_STATUS_ENDING).replace(this.replacePlaceholders()));
            return;
        }
        LangMessage langMessage = this.isAwaitingNewRound() ? this.plugin.getMessage(Lang.ARENA_GAME_STATUS_ROUND_PREPARE).replace(this.replacePlaceholders()) : this.plugin.getMessage(Lang.ARENA_GAME_STATUS_ROUND_ACTIVE).replace(this.replacePlaceholders());
        this.getAlivePlayers().forEach(arenaPlayer -> langMessage.send((CommandSender)arenaPlayer.getPlayer()));
    }

    public boolean checkJoinRequirements(@NotNull Arena arena, @NotNull Player player) {
        ArenaConfig arenaConfig = this.getConfig();
        if (arenaConfig.isPermissionRequired() && !this.hasPermission(player)) {
            return false;
        }
        if (!arenaConfig.getJoinPaymentRequirements().entrySet().stream().allMatch(entry -> ((Currency)entry.getKey()).getHandler().getBalance(player) >= (Double)entry.getValue())) {
            return false;
        }
        return arenaConfig.getJoinLevelRequirements().entrySet().stream().allMatch(entry -> ((PlayerLevelProvider)entry.getKey()).getLevel(player) >= (Integer)entry.getValue());
    }

    public void payJoinRequirements(@NotNull Arena arena, @NotNull Player player) {
        this.getConfig().getJoinPaymentRequirements().forEach((currency, d) -> currency.getHandler().take(player, (double)d));
    }

    public boolean canJoin(@NotNull Player player, boolean bl) {
        ArenaConfig arenaConfig = this.getConfig();
        if (!arenaConfig.isActive() || arenaConfig.hasProblems()) {
            if (bl) {
                this.plugin.getMessage(Lang.ARENA_ERROR_DISABLED).replace(this.replacePlaceholders()).send((CommandSender)player);
            }
            return false;
        }
        if (this.isAboutToEnd()) {
            if (bl) {
                this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_ENDING).replace(this.replacePlaceholders()).send((CommandSender)player);
            }
            return false;
        }
        if (this.getState() == GameState.INGAME && !player.hasPermission((Permission)Perms.BYPASS_ARENA_JOIN_INGAME)) {
            if (bl) {
                this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_STARTED).replace(this.replacePlaceholders()).send((CommandSender)player);
            }
            return false;
        }
        int n = arenaConfig.getGameplayManager().getPlayerMaxAmount();
        if (n > 0 && this.getPlayers(PlayerType.REAL).size() >= n) {
            if (bl) {
                this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_MAXIMUM).send((CommandSender)player);
            }
            return false;
        }
        if (this.getConfig().isPermissionRequired() && !this.hasPermission(player)) {
            if (bl) {
                this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_PERMISSION).send((CommandSender)player);
            }
            return false;
        }
        if (!player.hasPermission((Permission)Perms.BYPASS_ARENA_JOIN_PAYMENT) && !this.getConfig().getJoinPaymentRequirements().entrySet().stream().allMatch(entry -> ((Currency)entry.getKey()).getHandler().getBalance(player) >= (Double)entry.getValue())) {
            if (bl) {
                this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_PAYMENT).replace(this.replacePlaceholders()).send((CommandSender)player);
            }
            return false;
        }
        if (!player.hasPermission((Permission)Perms.BYPASS_ARENA_JOIN_LEVEL) && !this.getConfig().getJoinLevelRequirements().entrySet().stream().allMatch(entry -> ((PlayerLevelProvider)entry.getKey()).getLevel(player) >= (Integer)entry.getValue())) {
            if (bl) {
                this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_LEVEL).replace(this.replacePlaceholders()).send((CommandSender)player);
            }
            return false;
        }
        return true;
    }

    public boolean joinLobby(@NotNull Player player) {
        if (ArenaPlayer.isPlaying(player)) {
            this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_IN_GAME).send((CommandSender)player);
            return false;
        }
        if (!this.canJoin(player, true)) {
            return false;
        }
        ArenaPlayerJoinEvent arenaPlayerJoinEvent = new ArenaPlayerJoinEvent(this, player);
        this.plugin.getPluginManager().callEvent((Event)arenaPlayerJoinEvent);
        if (arenaPlayerJoinEvent.isCancelled()) {
            return false;
        }
        ArenaPlayer arenaPlayer3 = ArenaPlayer.create(player, this);
        PlayerSnapshot.doSnapshot(player);
        arenaPlayer3.setTransfer(true);
        player.teleport(this.getConfig().getLocation(ArenaLocationType.LOBBY));
        SimpleParticle.of((Particle)Particle.CLOUD).play(player.getLocation(), 0.25, 0.15, 30);
        arenaPlayer3.setTransfer(false);
        PlayerSnapshot.clear(player);
        if (this.getConfig().getGameplayManager().isKitsEnabled()) {
            player.getInventory().clear();
            if (this.plugin().getKitManager().isSavePurchasedKits()) {
                LobbyItem.give(LobbyItem.Type.KIT_SELECT, player);
            }
            LobbyItem.give(LobbyItem.Type.KIT_SHOP, player);
            LobbyItem.give(LobbyItem.Type.EXIT, player);
            LobbyItem.give(LobbyItem.Type.STATS, player);
            LobbyItem.give(LobbyItem.Type.READY, player);
        }
        this.plugin().getMessage(Lang.Arena_Game_Lobby_Enter).replace(this.replacePlaceholders()).send((CommandSender)player);
        this.getPlayers(PlayerType.ALL).forEach(arenaPlayer2 -> this.plugin().getMessage(Lang.Arena_Game_Lobby_Joined).replace(arenaPlayer3.replacePlaceholders()).send((CommandSender)arenaPlayer2.getPlayer()));
        this.players.add(arenaPlayer3);
        this.payJoinRequirements(this, player);
        this.updateSigns();
        if (this.getState() == GameState.INGAME) {
            return true;
        }
        int n = this.getConfig().getGameplayManager().getPlayerMinAmount();
        int n2 = this.getPlayers(PlayerType.REAL).size();
        if (n2 == 1) {
            this.setLobbyCountdown(this.getConfig().getGameplayManager().getLobbyTime());
        }
        if (n2 < n) {
            this.getPlayers(PlayerType.ALL).forEach(arenaPlayer -> this.plugin().getMessage(Lang.Arena_Game_Lobby_MinPlayers).replace("%min%", (Object)n).send((CommandSender)arenaPlayer.getPlayer()));
        }
        return true;
    }

    private void joinGame(@NotNull ArenaPlayer arenaPlayer) {
        Object object;
        Object object2;
        Placeholder placeholder;
        if (this.getConfig().getGameplayManager().isKitsEnabled()) {
            placeholder = arenaPlayer.getKit();
            if (placeholder == null) {
                object2 = this.plugin.getKitManager();
                if (object2.isSavePurchasedKits() && !((ArenaUser)((Object)(object = (ArenaUser)this.plugin.getUserManager().getUserData(arenaPlayer.getPlayer())))).getKits().isEmpty()) {
                    String string = (String)Rnd.get(new ArrayList<String>(((ArenaUser)((Object)object)).getKits()));
                    placeholder = object2.getKitById(string);
                }
                if (placeholder == null || !placeholder.isAvailable(arenaPlayer, false)) {
                    placeholder = this.plugin.getKitManager().getDefaultKit();
                }
                if (placeholder == null) {
                    arenaPlayer.leaveArena();
                    this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_NO_KIT).send((CommandSender)arenaPlayer.getPlayer());
                    return;
                }
            }
            arenaPlayer.setKit((Kit)placeholder);
            placeholder.give(arenaPlayer);
        }
        placeholder = this.getConfig().getRegionManager();
        Object object3 = object2 = this.getRoundNumber() > 0 ? placeholder.getFirstUnlocked() : placeholder.getDefaultRegion();
        if (object2 == null) {
            arenaPlayer.leaveArena();
            this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_NO_REGION).send((CommandSender)arenaPlayer.getPlayer());
            return;
        }
        arenaPlayer.setTransfer(true);
        object = arenaPlayer.getPlayer();
        object.teleport(((ArenaRegion)object2).getSpawnLocation());
        arenaPlayer.setTransfer(false);
        object.setHealth(EntityUtil.getAttribute((LivingEntity)object, (Attribute)Attribute.GENERIC_MAX_HEALTH));
        arenaPlayer.addBoard();
        arenaPlayer.setState(GameState.INGAME);
        this.plugin().getMessage(Lang.Arena_Game_Notify_Start).send((CommandSender)object);
    }

    public boolean joinSpectate(@NotNull Player player) {
        if (ArenaPlayer.isPlaying(player)) {
            this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_IN_GAME).send((CommandSender)player);
            return false;
        }
        if (!this.getConfig().isActive() || this.getConfig().hasProblems()) {
            this.plugin.getMessage(Lang.ARENA_ERROR_DISABLED).replace(this.replacePlaceholders()).send((CommandSender)player);
            return false;
        }
        if (!this.hasPermission(player)) {
            this.plugin.getMessage(Lang.ARENA_JOIN_ERROR_PERMISSION).send((CommandSender)player);
            return false;
        }
        if (!this.getConfig().getGameplayManager().isSpectateEnabled()) {
            this.plugin.getMessage(Lang.ARENA_JOIN_SPECTATE_ERROR_DISABLED).send((CommandSender)player);
            return false;
        }
        if (this.getState() != GameState.INGAME) {
            this.plugin.getMessage(Lang.ARENA_SPECTATE_ERROR_NOTHING).replace(this.replacePlaceholders()).send((CommandSender)player);
            return false;
        }
        ArenaPlayerSpectateEvent arenaPlayerSpectateEvent = new ArenaPlayerSpectateEvent(this, player);
        this.plugin.getPluginManager().callEvent((Event)arenaPlayerSpectateEvent);
        if (arenaPlayerSpectateEvent.isCancelled()) {
            return false;
        }
        PlayerSnapshot.doSnapshot(player);
        ArenaPlayer arenaPlayer = ArenaPlayer.create(player, this);
        arenaPlayer.setGhost();
        arenaPlayer.setLifes(0);
        arenaPlayer.setState(GameState.INGAME);
        player.teleport(this.getConfig().getLocation(ArenaLocationType.SPECTATE));
        this.plugin.getMessage(Lang.ARENA_JOIN_SPECTATE_SUCCESS).replace(this.replacePlaceholders()).send((CommandSender)player);
        this.players.add(arenaPlayer);
        PlayerSnapshot.clear(player);
        player.setGameMode(GameMode.SPECTATOR);
        return true;
    }

    public boolean leaveArena(@NotNull ArenaPlayer arenaPlayer) {
        if (!arenaPlayer.getArena().equals(this)) {
            return false;
        }
        Player player = arenaPlayer.getPlayer();
        player.closeInventory();
        arenaPlayer.setTransfer(true);
        arenaPlayer.removeBoard();
        ArenaUtils.removeMobBossBars(player);
        this.players.remove(arenaPlayer);
        if (!this.isAboutToEnd() && !this.getConfig().getRewardManager().isRetainOnLeave()) {
            arenaPlayer.getRewards().clear();
        }
        PlayerSnapshot.restore(arenaPlayer);
        arenaPlayer.saveStats();
        arenaPlayer.getRewards().forEach(arenaReward -> arenaReward.give(player));
        ArenaPlayer.remove(player);
        ArenaPlayerLeaveEvent arenaPlayerLeaveEvent = new ArenaPlayerLeaveEvent(this, arenaPlayer);
        this.plugin.getPluginManager().callEvent((Event)arenaPlayerLeaveEvent);
        this.plugin.getMessage(Lang.ARENA_GAME_LEAVE_INFO).replace(this.replacePlaceholders()).send((CommandSender)player);
        return true;
    }

    public void broadcast(@NotNull LangMessage langMessage) {
        this.broadcast(PlayerType.ALL, langMessage);
    }

    public void broadcast(@NotNull PlayerType playerType, @NotNull LangMessage langMessage) {
        this.getPlayers(playerType).forEach(arenaPlayer -> langMessage.send((CommandSender)arenaPlayer.getPlayer()));
    }

    public void broadcast(@NotNull ArenaTargetType arenaTargetType, @NotNull LangMessage langMessage) {
        this.getPlayers(arenaTargetType, PlayerType.ALL).forEach(arenaPlayer -> langMessage.send((CommandSender)arenaPlayer.getPlayer()));
    }

    public void broadcast(@NotNull ArenaTargetType arenaTargetType, @NotNull String string) {
        this.getPlayers(arenaTargetType, PlayerType.ALL).forEach(arenaPlayer -> arenaPlayer.getPlayer().sendMessage(string));
    }

    public void runCommand(@NotNull String string, @NotNull ArenaTargetType arenaTargetType) {
        if (arenaTargetType == ArenaTargetType.GLOBAL) {
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), string);
            return;
        }
        this.getPlayers(arenaTargetType, PlayerType.REAL).forEach(arenaPlayer -> PlayerUtil.dispatchCommand((Player)arenaPlayer.getPlayer(), (String)string));
    }

    public void addGroundItem(@NotNull Item item2) {
        this.getGroundItems().removeIf(item -> !item.isValid());
        this.getGroundItems().add(item2);
        if (this.getState() == GameState.INGAME && !this.getConfig().getGameplayManager().isItemPickupEnabled()) {
            item2.setPickupDelay(Short.MAX_VALUE);
        }
    }

    public void burnGroundItems() {
        SimpleParticle simpleParticle = SimpleParticle.of((Particle)Particle.SMOKE_NORMAL);
        this.getGroundItems().forEach(item -> {
            if (item.isValid() && item.isOnGround()) {
                simpleParticle.play(item.getLocation(), 0.1, 0.05, 15);
                item.remove();
            }
        });
    }

    public void killGroundItems() {
        this.getGroundItems().forEach(Entity::remove);
        this.getGroundItems().clear();
    }

    public void highlightMobs(boolean bl) {
        ArenaUtils.getHighlightTeam(this, true).ifPresent(team -> {
            this.getMobs().getEnemies().stream().map(livingEntity -> livingEntity.getUniqueId().toString()).forEach(string -> {
                if (bl) {
                    team.addEntry(string);
                } else {
                    team.removeEntry(string);
                }
            });
            this.getMobs().getEnemies().forEach(livingEntity -> livingEntity.setGlowing(bl));
        });
    }

    public void killMobs() {
        for (MobFaction mobFaction : MobFaction.values()) {
            this.killMobs(mobFaction);
        }
    }

    public void killMobs(@NotNull MobFaction mobFaction) {
        this.getMobs().removeAll(mobFaction);
    }

    public void injectWave(@NotNull ArenaUpcomingWave arenaUpcomingWave) {
        this.getUpcomingWaves().add(arenaUpcomingWave);
        this.setRoundTotalMobsAmount(this.getRoundTotalMobsAmount() + arenaUpcomingWave.getMobsAmount());
        ArenaWaveManager arenaWaveManager = this.getConfig().getWaveManager();
        if (!this.getConfig().getWaveManager().isGradualSpawnEnabled()) {
            this.spawnMobs(100.0);
        }
    }

    public void newRound() {
        this.getUpcomingWaves().clear();
        this.gradualMobsTimer = 0;
        if (this.isLatestWave()) {
            this.killMobs();
        } else {
            this.killMobs(MobFaction.ENEMY);
        }
        if (this.isLatestWave()) {
            return;
        }
        this.setRoundNumber(this.getRoundNumber() + 1);
        this.setRoundTotalMobsAmount(0);
        ArenaRegion arenaRegion = this.getConfig().getRegionManager().getFirstUnlocked();
        this.getPlayers(GameState.INGAME, PlayerType.REAL).forEach(arenaPlayer -> {
            arenaPlayer.addStats(StatType.WAVES_PASSED, 1);
            ArenaRegion arenaRegion2 = arenaPlayer.getRegion();
            if ((arenaRegion2 == null || arenaRegion2.isLocked()) && arenaRegion != null) {
                arenaPlayer.getPlayer().teleport(arenaRegion.getSpawnLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
        });
        ArenaWaveStartEvent arenaWaveStartEvent = new ArenaWaveStartEvent(this);
        this.plugin.getPluginManager().callEvent((Event)arenaWaveStartEvent);
        this.setNextRoundCountdown(this.getConfig().getWaveManager().getRoundCountdown());
        this.setGradualMobsKilled(0);
        ArenaWaveManager arenaWaveManager = this.getConfig().getWaveManager();
        if (arenaWaveManager.isGradualSpawnEnabled()) {
            this.spawnMobs(arenaWaveManager.getGradualSpawnPercentFirst());
        }
        this.updateHolograms();
        this.getPlayers(PlayerType.ALL).stream().map(ArenaPlayer::getPlayer).forEach(player -> this.plugin().getMessage(Lang.Arena_Game_Wave_Start).replace(this.replacePlaceholders()).send((CommandSender)player));
    }

    @Nullable
    public LivingEntity spawnMob(@NotNull ArenaWaveMob arenaWaveMob, @NotNull Location location) {
        String string = arenaWaveMob.getMobId();
        int n = arenaWaveMob.getLevel();
        Location location2 = location.getBlock().getRelative(BlockFace.UP).getLocation();
        MobProvider mobProvider = arenaWaveMob.getProvider();
        LivingEntity livingEntity = mobProvider.spawn(this, arenaWaveMob.getMobId(), location2, n).orElse(null);
        if (livingEntity == null) {
            this.plugin.warn("Could not spawn '" + string + "' from the '" + arenaWaveMob.getArenaWave().getId() + "' arena wave in '" + this.getId() + "' arena!");
            return null;
        }
        livingEntity.setRemoveWhenFarAway(false);
        MobManager.setArena(livingEntity, this);
        MobManager.setProvider(livingEntity, mobProvider, string);
        MobManager.setLevel(livingEntity, n);
        this.getMobs().getEnemies().add(livingEntity);
        return livingEntity;
    }

    @Nullable
    public LivingEntity spawnAllyMob(@NotNull EntityType entityType, @NotNull Location location) {
        LivingEntity livingEntity = this.plugin.getArenaNMS().spawnMob(this, MobFaction.ALLY, entityType, location);
        if (livingEntity != null) {
            MobManager.setArena(livingEntity, this);
            this.getMobs().getAllies().add(livingEntity);
        }
        return livingEntity;
    }

    public void spawnMobs(double d) {
        int n;
        int n2;
        int n3;
        this.mobsAboutToSpawn = true;
        if (d == 0.0) {
            d = 100.0;
        }
        d /= 100.0;
        if (((Boolean)Config.DEBUG_MOB_SPAWN.get()).booleanValue()) {
            System.out.println("[Spawn Processor] 0. Percent of Total Mobs: " + d);
        }
        ArrayList<ArenaUpcomingWave> arrayList = new ArrayList<ArenaUpcomingWave>(this.getUpcomingWaves());
        int[] nArray = new int[arrayList.size()];
        int n4 = (int)Math.max(1.0, (double)this.getRoundTotalMobsAmount() * d);
        for (n3 = 0; n3 < nArray.length; ++n3) {
            ArenaUpcomingWave arenaUpcomingWave = (ArenaUpcomingWave)arrayList.get(n3);
            double d2 = arenaUpcomingWave.getPreparedMobs().stream().mapToInt(ArenaWaveMob::getAmount).sum();
            if (((Boolean)Config.DEBUG_MOB_SPAWN.get()).booleanValue()) {
                System.out.println("[Spawn Processor] 2. Total Mobs for Wave #" + this.getRoundNumber() + ": " + d2);
            }
            nArray[n3] = (int)Math.ceil(d2 * d);
            if (Arrays.stream(nArray).sum() >= n4) break;
        }
        if (((Boolean)Config.DEBUG_MOB_SPAWN.get()).booleanValue()) {
            System.out.println("[Spawn Processor] 3. Mobs Per Each Wave:" + Arrays.toString(nArray));
        }
        if ((n3 = Arrays.stream(nArray).sum()) != n4) {
            int n5 = n4 - n3;
            int[] nArray2 = NumberUtil.splitIntoParts((int)n5, (int)nArray.length);
            for (int i = 0; i < nArray.length; ++i) {
                int n6 = i;
                nArray[n6] = nArray[n6] + nArray2[i];
            }
        }
        int n7 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n8 = nArray[n2];
            ArenaUpcomingWave arenaUpcomingWave = (ArenaUpcomingWave)arrayList.get(n2);
            n = arenaUpcomingWave.getPreparedMobs().stream().mapToInt(ArenaWaveMob::getAmount).sum();
            if (n8 > n) {
                n7 += n8 - n;
                nArray[n2] = n;
                continue;
            }
            if (n <= n8 || n7 <= 0) continue;
            int n9 = n - n8;
            n7 -= n9;
            int n10 = n2;
            nArray[n10] = nArray[n10] + n9;
        }
        if (((Boolean)Config.DEBUG_MOB_SPAWN.get()).booleanValue()) {
            System.out.println("[Spawn Processor] 4. Planned For Whole Arena Round:" + n4);
            System.out.println("[Spawn Processor] 5. Calculated to Spawn:" + n3);
            System.out.println("[Spawn Processor] 6. Mobs Per Each Wave:" + Arrays.toString(nArray));
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            ArenaUpcomingWave arenaUpcomingWave = (ArenaUpcomingWave)arrayList.get(n2);
            List<Location> list = arenaUpcomingWave.getPreparedSpawners();
            n = nArray[n2];
            int[] nArray3 = NumberUtil.splitIntoParts((int)n, (int)list.size());
            if (((Boolean)Config.DEBUG_MOB_SPAWN.get()).booleanValue()) {
                System.out.println("[Spawn Processor] 7. Mobs Per Region Spawner for '" + arenaUpcomingWave + "': " + Arrays.toString(nArray3));
            }
            for (int i = 0; i < nArray3.length; ++i) {
                int n11 = nArray3[i];
                for (int j = 0; j < n11; ++j) {
                    if (arenaUpcomingWave.getPreparedMobs().isEmpty()) {
                        if (!((Boolean)Config.DEBUG_MOB_SPAWN.get()).booleanValue()) continue;
                        System.out.println("Invalid mob");
                        continue;
                    }
                    ArenaWaveMob arenaWaveMob = (ArenaWaveMob)Rnd.get(arenaUpcomingWave.getPreparedMobs());
                    int n12 = Math.min(arenaWaveMob.getAmount(), 1);
                    arenaWaveMob.setAmount(arenaWaveMob.getAmount() - n12);
                    for (int k = 0; k < n12; ++k) {
                        this.spawnMob(arenaWaveMob, list.get(i));
                    }
                    if (arenaWaveMob.getAmount() > 0) continue;
                    arenaUpcomingWave.getPreparedMobs().remove(arenaWaveMob);
                }
            }
        }
        this.getUpcomingWaves().removeIf(ArenaUpcomingWave::isAllMobsSpawned);
        this.mobsAboutToSpawn = false;
    }

    private void countGradual() {
        if (this.getConfig().getWaveManager().isGradualSpawnEnabled()) {
            boolean bl;
            this.setGradualMobsKilled(this.getGradualMobsKilled() + 1);
            boolean bl2 = this.getUpcomingWaves().stream().allMatch(ArenaUpcomingWave::isAllMobsSpawned);
            if (bl2) {
                return;
            }
            double d = this.getRoundTotalMobsAmount();
            double d2 = this.getConfig().getWaveManager().getGradualSpawnNextKillPercent();
            int n = this.getGradualMobsKilled();
            int n2 = (int)Math.max(1.0, d * d2 / 100.0);
            if (((Boolean)Config.DEBUG_MOB_SPAWN.get()).booleanValue()) {
                System.out.println("Game Event: Mob Killed | Gradual Spawning");
                System.out.println("[Gradual] Total Mobs (All Waves): " + d);
                System.out.println("[Gradual] Killed (Raw): " + n);
                System.out.println("[Gradual] Need Killed (Raw): " + n2);
            }
            boolean bl3 = bl = !this.getMobs().hasAliveEnemies() && this.gradualMobsPrepare == 0;
            if (n >= n2 || bl) {
                ++this.gradualMobsPrepare;
                this.setGradualMobsKilled(0);
                if (((Boolean)Config.DEBUG_MOB_SPAWN.get()).booleanValue()) {
                    System.out.println("[Gradual] Prepared Groups: " + this.gradualMobsPrepare);
                }
            }
        }
    }
}

