/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.impl;

import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.LocationUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.arena.Problematic;
import su.nightexpress.ama.api.arena.type.ArenaLocationType;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.api.hologram.HologramHolder;
import su.nightexpress.ama.api.hologram.HologramType;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.ArenaStatsHologram;
import su.nightexpress.ama.arena.editor.arena.ArenaMainEditor;
import su.nightexpress.ama.arena.game.ArenaGameplayManager;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.region.ArenaRegionManager;
import su.nightexpress.ama.arena.reward.ArenaRewardManager;
import su.nightexpress.ama.arena.script.ArenaScriptManager;
import su.nightexpress.ama.arena.shop.ShopManager;
import su.nightexpress.ama.arena.spot.ArenaSpotManager;
import su.nightexpress.ama.arena.supply.ArenaSupplyManager;
import su.nightexpress.ama.arena.util.ArenaUtils;
import su.nightexpress.ama.arena.wave.ArenaWaveManager;
import su.nightexpress.ama.hologram.HologramManager;
import su.nightexpress.ama.hook.level.PlayerLevelProvider;
import su.nightexpress.ama.hook.level.PluginLevelProvider;
import su.nightexpress.ama.stats.object.StatType;

public class ArenaConfig
extends AbstractConfigHolder<AMA>
implements HologramHolder,
Problematic,
Placeholder {
    private final Map<DayOfWeek, Set<LocalTime>> autoOpenTimes = new HashMap<DayOfWeek, Set<LocalTime>>();
    private final Map<DayOfWeek, Set<LocalTime>> autoCloseTimes = new HashMap<DayOfWeek, Set<LocalTime>>();
    private final Map<ArenaLocationType, Location> locations = new HashMap<ArenaLocationType, Location>();
    private final Map<StatType, ArenaStatsHologram> statsHolograms = new HashMap<StatType, ArenaStatsHologram>();
    private final Set<UUID> hologramIds = new HashSet<UUID>();
    private final Set<Location> hologramLocations = new HashSet<Location>();
    private final Map<Currency, Double> joinPaymentRequirements = new HashMap<Currency, Double>();
    private final Map<PlayerLevelProvider, Integer> joinLevelRequirements = new HashMap<PlayerLevelProvider, Integer>();
    private final Arena arena;
    private final ArenaWaveManager waveManager;
    private final ArenaRegionManager regionManager;
    private final ArenaGameplayManager gameplayManager;
    private final ArenaSupplyManager supplyManager;
    private final ArenaSpotManager spotManager;
    private final ArenaRewardManager rewardManager;
    private final ShopManager shopManager;
    private final ArenaScriptManager scriptManager;
    private final PlaceholderMap placeholderMap;
    private boolean isActive;
    private String name;
    private boolean isPermissionRequired;
    private ArenaMainEditor editorMain;

    public ArenaConfig(@NotNull AMA aMA, @NotNull JYML jYML, @NotNull String string) {
        super((NexPlugin)aMA, jYML, string);
        String string2 = this.getFile().getParentFile().getAbsolutePath();
        this.waveManager = new ArenaWaveManager(this);
        this.regionManager = new ArenaRegionManager(this);
        this.gameplayManager = new ArenaGameplayManager(this);
        this.supplyManager = new ArenaSupplyManager(this, new JYML(string2, "supply.yml"));
        this.spotManager = new ArenaSpotManager(this);
        this.rewardManager = new ArenaRewardManager(this);
        this.shopManager = new ShopManager(this);
        this.scriptManager = new ArenaScriptManager(this);
        this.placeholderMap = new PlaceholderMap().add("%problems%", () -> String.join((CharSequence)"\n", this.getProblems())).add("%arena_id%", () -> ((ArenaConfig)this).getId()).add("%arena_active%", () -> LangManager.getBoolean((boolean)this.isActive())).add("%arena_name%", this::getName).add("%arena_permission%", this::getPermission).add("%arena_auto_state_open_times%", () -> this.getAutoOpenTimes().entrySet().stream().map(entry -> ((DayOfWeek)entry.getKey()).name() + ": " + ((Set)entry.getValue()).stream().map(localTime -> localTime.format(ArenaUtils.TIME_FORMATTER)).collect(Collectors.joining(", "))).collect(Collectors.joining("\n"))).add("%arena_auto_state_close_times%", () -> this.getAutoCloseTimes().entrySet().stream().map(entry -> ((DayOfWeek)entry.getKey()).name() + ": " + ((Set)entry.getValue()).stream().map(localTime -> localTime.format(ArenaUtils.TIME_FORMATTER)).collect(Collectors.joining(", "))).collect(Collectors.joining("\n"))).add("%arena_requirement_permission%", () -> LangManager.getBoolean((boolean)this.isPermissionRequired())).add("%arena_requirement_payment%", () -> this.getJoinPaymentRequirements().keySet().stream().map(currency -> currency.format(this.getJoinPaymentRequirements().getOrDefault(currency, 0.0))).collect(Collectors.joining(", "))).add("%arena_requirement_level%", () -> this.getJoinLevelRequirements().entrySet().stream().map(entry -> ((PlayerLevelProvider)entry.getKey()).getName() + ": " + entry.getValue()).collect(Collectors.joining(", ")));
        this.arena = new Arena(this);
    }

    public boolean load() {
        Object object;
        Object object2;
        this.setActive(this.cfg.getBoolean("Active"));
        this.setName(this.cfg.getString("Name", this.getId() + " Arena"));
        for (String string2 : this.cfg.getSection("Auto_State_Schedulers")) {
            for (String string3 : this.cfg.getSection("Auto_State_Schedulers." + string2)) {
                object2 = StringUtil.getEnum((String)string3, DayOfWeek.class).orElse(null);
                if (object2 == null) continue;
                (string2.equalsIgnoreCase("open") ? this.autoOpenTimes : this.autoCloseTimes).put((DayOfWeek)object2, this.cfg.getStringList("Auto_State_Schedulers." + string2 + "." + string3).stream().map(string -> LocalTime.parse(string, ArenaUtils.TIME_FORMATTER)).collect(Collectors.toSet()));
            }
        }
        this.setPermissionRequired(this.cfg.getBoolean("Join_Requirements.Permission"));
        for (String string2 : this.cfg.getSection("Join_Requirements.Payment")) {
            double d;
            object = ((AMA)this.plugin()).getCurrencyManager().getCurrency(string2);
            if (object == null || (d = this.cfg.getDouble("Join_Requirements.Payment." + string2, 0.0)) <= 0.0) continue;
            this.getJoinPaymentRequirements().put((Currency)object, d);
        }
        for (String string2 : this.cfg.getSection("Join_Requirements.Level")) {
            int n;
            object = PluginLevelProvider.getProvider(string2);
            if (object == null || (n = this.cfg.getInt("Join_Requirements.Level." + string2, 0)) <= 0) continue;
            this.getJoinLevelRequirements().put((PlayerLevelProvider)object, n);
        }
        for (ArenaLocationType arenaLocationType : ArenaLocationType.values()) {
            this.locations.put(arenaLocationType, this.cfg.getLocation("Locations." + arenaLocationType.name()));
        }
        for (Enum enum_ : StatType.values()) {
            object2 = this.cfg.getStringList("Hologram." + enum_.name() + ".Locations").stream().map(LocationUtil::deserialize).filter(Objects::nonNull).collect(Collectors.toSet());
            ArenaStatsHologram arenaStatsHologram = new ArenaStatsHologram(this, (StatType)enum_, (Set<Location>)object2);
            this.statsHolograms.put((StatType)enum_, arenaStatsHologram);
        }
        this.hologramLocations.addAll(this.cfg.getStringList("Hologram.Default.Locations").stream().map(LocationUtil::deserialize).filter(Objects::nonNull).collect(Collectors.toSet()));
        this.waveManager.setup();
        this.regionManager.setup();
        this.gameplayManager.setup();
        this.supplyManager.load();
        this.spotManager.setup();
        this.rewardManager.setup();
        this.shopManager.setup();
        this.scriptManager.setup();
        this.getConfig().saveChanges();
        this.getArena().reset();
        this.createHolograms();
        return true;
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    public void clear() {
        this.removeHolograms();
        this.statsHolograms.values().forEach(HologramHolder::removeHolograms);
        this.statsHolograms.clear();
        if (this.editorMain != null) {
            this.editorMain.clear();
            this.editorMain = null;
        }
        this.spotManager.shutdown();
        this.regionManager.shutdown();
        this.gameplayManager.shutdown();
        this.supplyManager.clear();
        this.waveManager.shutdown();
        this.rewardManager.shutdown();
        this.shopManager.shutdown();
        this.scriptManager.shutdown();
    }

    public void onSave() {
        this.cfg.set("Active", (Object)this.isActive());
        this.cfg.set("Name", (Object)this.getName());
        this.autoOpenTimes.forEach((dayOfWeek, set) -> this.cfg.set("Auto_State_Schedulers.Open." + dayOfWeek.name(), set.stream().map(localTime -> localTime.format(ArenaUtils.TIME_FORMATTER)).toList()));
        this.autoCloseTimes.forEach((dayOfWeek, set) -> this.cfg.set("Auto_State_Schedulers.Close." + dayOfWeek.name(), set.stream().map(localTime -> localTime.format(ArenaUtils.TIME_FORMATTER)).toList()));
        String string = "Join_Requirements.";
        this.cfg.set(string + "Permission", (Object)this.isPermissionRequired());
        this.cfg.set(string + "Payment", null);
        this.getJoinPaymentRequirements().forEach((currency, d) -> this.cfg.set(string + "Payment." + currency.getId(), d));
        this.cfg.remove(string + "Level");
        this.getJoinLevelRequirements().forEach((playerLevelProvider, n) -> this.cfg.set(string + "Level." + playerLevelProvider.getName(), n));
        this.locations.forEach((arenaLocationType, location) -> this.cfg.set("Locations." + arenaLocationType.name(), location));
        this.statsHolograms.forEach((statType, arenaStatsHologram) -> this.cfg.set("Hologram." + statType.name() + ".Locations", arenaStatsHologram.getHologramLocations().stream().map(LocationUtil::serialize).toList()));
        this.cfg.set("Hologram.Default.Locations", this.getHologramLocations().stream().map(LocationUtil::serialize).toList());
        this.waveManager.save();
        this.regionManager.save();
        this.gameplayManager.save();
        this.supplyManager.save();
        this.rewardManager.save();
        this.shopManager.save();
        this.scriptManager.save();
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getLocation(ArenaLocationType.LOBBY) == null) {
            arrayList.add(this.problem("No Lobby Location"));
        }
        if (this.getLocation(ArenaLocationType.SPECTATE) == null) {
            arrayList.add(this.problem("No Spectate Location"));
        }
        if (this.getRegionManager().hasProblems()) {
            arrayList.add(this.problem("Problems in Region Manager"));
        }
        if (this.getGameplayManager().hasProblems()) {
            arrayList.add(this.problem("Problems in Gameplay Manager"));
        }
        if (this.getWaveManager().hasProblems()) {
            arrayList.add(this.problem("Problems in Wave Manager"));
        }
        if (this.getSpotManager().hasProblems()) {
            arrayList.add(this.problem("Problems in Spot Manager"));
        }
        if (this.getRewardManager().hasProblems()) {
            arrayList.add(this.problem("Problems in Reward Manager"));
        }
        return arrayList;
    }

    @NotNull
    public ArenaMainEditor getEditor() {
        if (this.editorMain == null) {
            this.editorMain = new ArenaMainEditor((AMA)this.plugin, this);
        }
        return this.editorMain;
    }

    @NotNull
    public Arena getArena() {
        return this.arena;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        this.name = Colorizer.apply((String)string);
    }

    public boolean isPermissionRequired() {
        return this.isPermissionRequired;
    }

    public void setPermissionRequired(boolean bl) {
        this.isPermissionRequired = bl;
    }

    @NotNull
    public String getPermission() {
        return "advancedmobarena.arena." + this.getId();
    }

    @NotNull
    public Map<DayOfWeek, Set<LocalTime>> getAutoOpenTimes() {
        return this.autoOpenTimes;
    }

    @NotNull
    public Map<DayOfWeek, Set<LocalTime>> getAutoCloseTimes() {
        return this.autoCloseTimes;
    }

    @NotNull
    public Map<Currency, Double> getJoinPaymentRequirements() {
        return this.joinPaymentRequirements;
    }

    @NotNull
    public Map<PlayerLevelProvider, Integer> getJoinLevelRequirements() {
        return this.joinLevelRequirements;
    }

    public Location getLocation(@NotNull ArenaLocationType arenaLocationType) {
        return this.locations.get((Object)arenaLocationType);
    }

    public void setLocation(@NotNull ArenaLocationType arenaLocationType, @Nullable Location location) {
        this.locations.put(arenaLocationType, location);
    }

    @NotNull
    public Map<StatType, ArenaStatsHologram> getStatsHolograms() {
        return this.statsHolograms;
    }

    @NotNull
    public ArenaStatsHologram getStatsHologram(@NotNull StatType statType) {
        return this.getStatsHolograms().computeIfAbsent(statType, statType2 -> new ArenaStatsHologram(this, statType, new HashSet<Location>()));
    }

    @Override
    public void updateHolograms() {
        if (this.arena == null) {
            return;
        }
        HologramHolder.super.updateHolograms();
        this.setHologramClick(player -> {
            Arena arena = this.getArena();
            if (arena.getState() == GameState.INGAME && !player.hasPermission((Permission)Perms.BYPASS_ARENA_JOIN_INGAME)) {
                arena.joinSpectate(player);
            } else {
                arena.joinLobby(player);
            }
        });
    }

    @Override
    @NotNull
    public HologramType getHologramType() {
        return HologramType.ARENA;
    }

    @Override
    @NotNull
    public List<String> getHologramFormat() {
        List<String> list = HologramManager.getFormat(this.getHologramType());
        list.replaceAll(this.getArena().replacePlaceholders());
        return list;
    }

    @Override
    @NotNull
    public Set<UUID> getHologramIds() {
        return this.hologramIds;
    }

    @Override
    @NotNull
    public Set<Location> getHologramLocations() {
        return this.hologramLocations;
    }

    @NotNull
    public ArenaWaveManager getWaveManager() {
        return this.waveManager;
    }

    @NotNull
    public ArenaRegionManager getRegionManager() {
        return this.regionManager;
    }

    @NotNull
    public ArenaGameplayManager getGameplayManager() {
        return this.gameplayManager;
    }

    @NotNull
    public ArenaSupplyManager getSupplyManager() {
        return this.supplyManager;
    }

    @NotNull
    public ArenaSpotManager getSpotManager() {
        return this.spotManager;
    }

    @NotNull
    public ArenaRewardManager getRewardManager() {
        return this.rewardManager;
    }

    @NotNull
    public ShopManager getShopManager() {
        return this.shopManager;
    }

    @NotNull
    public ArenaScriptManager getScriptManager() {
        return this.scriptManager;
    }
}

