/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.region;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.Chest;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.LocationUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.Problematic;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.api.event.ArenaRegionEvent;
import su.nightexpress.ama.api.hologram.HologramHolder;
import su.nightexpress.ama.api.hologram.HologramType;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.api.type.PlayerType;
import su.nightexpress.ama.arena.editor.region.RegionMainEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.lock.LockState;
import su.nightexpress.ama.arena.lock.Lockable;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.Parameters;
import su.nightexpress.ama.arena.script.action.ScriptActions;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ArenaScript;
import su.nightexpress.ama.arena.supply.ArenaSupplyChest;
import su.nightexpress.ama.arena.util.ArenaCuboid;
import su.nightexpress.ama.hologram.HologramManager;

public class ArenaRegion
extends AbstractConfigHolder<AMA>
implements ArenaChild,
Lockable,
HologramHolder,
Problematic,
Placeholder {
    private final ArenaConfig arenaConfig;
    private final Map<String, Location> mobSpawners;
    private final Set<Location> hologramLocations;
    private final Set<UUID> hologramIds;
    private final PlaceholderMap placeholderMap;
    private boolean isActive;
    private boolean isDefault;
    private LockState lockState;
    private String name;
    private ArenaCuboid cuboid;
    private Location spawnLocation;
    private RegionMainEditor editor;

    public ArenaRegion(@NotNull ArenaConfig arenaConfig, @NotNull JYML jYML) {
        super((NexPlugin)((AMA)arenaConfig.plugin()), jYML);
        this.arenaConfig = arenaConfig;
        this.mobSpawners = new HashMap<String, Location>();
        this.hologramLocations = new HashSet<Location>();
        this.hologramIds = new HashSet<UUID>();
        this.lockState = LockState.UNLOCKED;
        this.placeholderMap = new PlaceholderMap().add("%problems%", () -> String.join((CharSequence)"\n", this.getProblems())).add("%region_file%", () -> this.getFile().getName()).add("%region_id%", () -> ((ArenaRegion)this).getId()).add("%region_name%", this::getName).add("%region_active%", () -> LangManager.getBoolean((boolean)this.isActive())).add("%region_default%", () -> LangManager.getBoolean((boolean)this.isDefault())).add("%region_state%", () -> ((AMA)this.plugin()).getLangManager().getEnum((Enum)this.getLockState()));
    }

    public boolean load() {
        Object object;
        Object object2;
        Map<String, List<ScriptPreparedCondition>> map;
        Object object3;
        Object object4;
        Object object5;
        Object object62;
        this.setActive(this.cfg.getBoolean("Enabled"));
        this.setDefault(this.cfg.getBoolean("Is_Default"));
        this.lockState = LockState.UNLOCKED;
        this.setName(this.cfg.getString("Name", this.getId()));
        Location location = this.cfg.getLocation("Bounds.From");
        Location location2 = this.cfg.getLocation("Bounds.To");
        if (location != null && location2 != null) {
            this.setCuboid(new ArenaCuboid(location, location2));
        }
        this.spawnLocation = this.cfg.getLocation("Spawn_Location");
        for (Object object8 : this.cfg.getSection("Mob_Spawners")) {
            Location location3 = this.cfg.getLocation("Mob_Spawners." + (String)object8);
            if (location3 == null) {
                ((AMA)this.plugin).error("Invalid location for '" + (String)object8 + "' mob spawner in '" + this.getFile().getName() + "' region!");
                continue;
            }
            this.mobSpawners.put(((String)object8).toLowerCase(), location3);
        }
        Object object9 = "Entrance.State.";
        for (LockState object72 : LockState.values()) {
            for (Object object7 : this.cfg.getSection((String)object9 + object72.name() + ".Triggers")) {
                Object object8 = StringUtil.getEnum((String)object7, ArenaGameEventType.class).orElse(null);
                if (object8 == null) continue;
                object62 = "region_" + this.getId() + "_" + object72.name().toLowerCase();
                object5 = new ArenaScript(this.arenaConfig, (String)object62, (ArenaGameEventType)((Object)object8));
                object4 = this.cfg.getString((String)object9 + object72.name() + ".Triggers." + (String)object7, "");
                object3 = ArenaScript.ofGameTrigger(object8, (String)object4);
                object5.getConditions().putAll((Map<String, List<ScriptPreparedCondition>>)object3);
                map = new ScriptPreparedAction(object72 == LockState.LOCKED ? ScriptActions.LOCK_REGION : ScriptActions.UNLOCK_REGION, new ParameterResult());
                ((ScriptPreparedAction)((Object)map)).getParameters().add(Parameters.REGION, this.getId());
                object5.getActions().add((ScriptPreparedAction)((Object)map));
                this.getArenaConfig().getScriptManager().addConverted((ArenaScript)object5);
            }
            this.cfg.remove((String)object9 + object72.name() + ".Triggers");
        }
        object9 = "Hologram.";
        this.hologramLocations.addAll(this.cfg.getStringSet((String)object9 + "Locations").stream().map(LocationUtil::deserialize).filter(Objects::nonNull).toList());
        for (String string2 : this.cfg.getSection("Waves.List")) {
            Object object7;
            String string3 = "Waves.List." + string2 + ".";
            String string4 = this.cfg.getString(string3 + "Arena_Wave_Id", "");
            object2 = this.cfg.getStringSet(string3 + "Arena_Wave_Ids");
            if (!string4.isEmpty() && object2.isEmpty()) {
                object2.add(string4);
            }
            object7 = this.cfg.getStringSet(string3 + "Spawners");
            for (Object object62 : this.cfg.getSection(string3 + "Triggers")) {
                object5 = StringUtil.getEnum((String)object62, ArenaGameEventType.class).orElse(null);
                if (object5 == null) continue;
                object4 = "region_" + this.getId() + "_spawn_wave_" + string2;
                object3 = new ArenaScript(this.arenaConfig, (String)object4, (ArenaGameEventType)((Object)object5));
                map = this.cfg.getString(string3 + "Triggers." + (String)object62, "");
                object = ArenaScript.ofGameTrigger((ArenaGameEventType)((Object)object5), (String)((Object)map));
                ((ArenaScript)object3).getConditions().putAll((Map<String, List<ScriptPreparedCondition>>)object);
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    ScriptPreparedAction scriptPreparedAction = new ScriptPreparedAction(ScriptActions.INJECT_WAVE, new ParameterResult());
                    scriptPreparedAction.getParameters().add(Parameters.WAVE, string5);
                    scriptPreparedAction.getParameters().add(Parameters.REGION, this.getId());
                    if (!object7.isEmpty()) {
                        scriptPreparedAction.getParameters().add(Parameters.SPAWNERS, String.join((CharSequence)",", (Iterable<? extends CharSequence>)object7));
                    }
                    ((ArenaScript)object3).getActions().add(scriptPreparedAction);
                }
                this.getArenaConfig().getScriptManager().addConverted((ArenaScript)object3);
            }
            this.cfg.remove(string3 + "Triggers");
        }
        for (String string5 : this.cfg.getSection("Containers")) {
            Object object10;
            String string6 = "Containers." + string5 + ".";
            Location location3 = this.cfg.getLocation(string6 + "Location");
            if (location3 == null || !((object10 = location3.getBlock().getState()) instanceof Chest)) continue;
            object2 = (Chest)object10;
            object10 = this.cfg.getSection(string6 + "Refill.Triggers").iterator();
            while (object10.hasNext()) {
                String string7 = (String)object10.next();
                object62 = StringUtil.getEnum((String)string7, ArenaGameEventType.class).orElse(null);
                if (object62 == null) continue;
                object5 = "refill_supply_chest_" + string5;
                object4 = new ArenaScript(this.arenaConfig, (String)object5, (ArenaGameEventType)((Object)object62));
                object3 = this.cfg.getString(string6 + "Refill.Triggers." + string7, "");
                map = ArenaScript.ofGameTrigger(object62, (String)object3);
                ((ArenaScript)object4).getConditions().putAll(map);
                object = new ScriptPreparedAction(ScriptActions.REFILL_SUPPLY_CHEST, new ParameterResult());
                ((ScriptPreparedAction)object).getParameters().add(Parameters.NAME, string5);
                ((ArenaScript)object4).getActions().add((ScriptPreparedAction)object);
                this.getArenaConfig().getScriptManager().addConverted((ArenaScript)object4);
            }
            this.cfg.remove(string6 + "Refill.Triggers");
            int n = this.cfg.getInt(string6 + "Refill.Items.Min");
            int n2 = this.cfg.getInt(string6 + "Refill.Items.Max");
            object62 = Arrays.asList(this.cfg.getItemsEncoded(string6 + "Items"));
            object5 = this.getId() + "_" + string5;
            object4 = new ArenaSupplyChest(this.arenaConfig, (String)object5, object2.getLocation(), n, n2, (List<ItemStack>)object62);
            this.getArenaConfig().getSupplyManager().getChestsMap().put(((ArenaSupplyChest)object4).getId(), (ArenaSupplyChest)object4);
        }
        if (this.cfg.remove("Containers")) {
            this.getArenaConfig().getSupplyManager().save();
        }
        this.updateHolograms();
        this.getProblems().forEach(string -> ((AMA)this.plugin()).warn("Problem in '" + this.getFile().getName() + "' Region: " + string));
        this.cfg.saveChanges();
        return true;
    }

    public void onSave() {
        this.cfg.set("Enabled", (Object)this.isActive());
        this.cfg.set("Is_Default", (Object)this.isDefault());
        this.cfg.set("Name", (Object)this.getName());
        this.cfg.remove("Bounds");
        this.getCuboid().ifPresent(arenaCuboid -> {
            this.cfg.set("Bounds.From", (Object)arenaCuboid.getMin());
            this.cfg.set("Bounds.To", (Object)arenaCuboid.getMax());
        });
        this.cfg.set("Spawn_Location", (Object)this.getSpawnLocation());
        this.cfg.set("Mob_Spawners", null);
        this.mobSpawners.forEach((string, location) -> this.cfg.set("Mob_Spawners." + string, location));
        this.cfg.set("Hologram.Locations", this.getHologramLocations().stream().map(LocationUtil::serialize).toList());
    }

    public void clear() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        this.removeHolograms();
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @Override
    @NotNull
    public List<String> getProblems() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.getCuboid().isEmpty()) {
            arrayList.add(this.problem("Invalid Cuboid Selection!"));
        }
        if (this.getSpawnLocation() == null || !this.getCuboid().get().contains(this.getSpawnLocation())) {
            arrayList.add(this.problem("Invalid Spawn Location!"));
        }
        if (this.getMobSpawners().isEmpty()) {
            arrayList.add(this.problem("No Mob Spawners!"));
        }
        return arrayList;
    }

    @NotNull
    public Set<ArenaPlayer> getPlayers() {
        return this.getArena().getPlayers(GameState.INGAME, PlayerType.REAL).stream().filter(arenaPlayer -> this.equals(arenaPlayer.getRegion())).collect(Collectors.toSet());
    }

    @NotNull
    public RegionMainEditor getEditor() {
        if (this.editor == null) {
            this.editor = new RegionMainEditor(this);
        }
        return this.editor;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @Override
    @NotNull
    public LockState getLockState() {
        return this.lockState;
    }

    @Override
    public void setLockState(@NotNull LockState lockState) {
        this.removeHolograms();
        this.lockState = lockState;
        ArenaGameEventType arenaGameEventType = this.isLocked() ? ArenaGameEventType.REGION_LOCKED : ArenaGameEventType.REGION_UNLOCKED;
        ArenaRegionEvent arenaRegionEvent = new ArenaRegionEvent(this.getArena(), arenaGameEventType, this);
        ((AMA)this.plugin).getPluginManager().callEvent((Event)arenaRegionEvent);
        this.updateHolograms();
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String string) {
        this.name = Colorizer.apply((String)string);
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setActive(boolean bl) {
        this.isActive = bl;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    @NotNull
    public Optional<ArenaCuboid> getCuboid() {
        return Optional.ofNullable(this.cuboid);
    }

    public void setCuboid(@Nullable ArenaCuboid arenaCuboid) {
        this.cuboid = arenaCuboid;
    }

    public Location getSpawnLocation() {
        return this.spawnLocation == null ? null : this.spawnLocation.clone();
    }

    public void setSpawnLocation(Location location) {
        this.spawnLocation = location == null ? null : location.clone();
    }

    @NotNull
    public Map<String, Location> getMobSpawners() {
        return this.mobSpawners;
    }

    @Nullable
    public Location getMobSpawner(@NotNull String string) {
        Location location = this.getMobSpawners().get(string.toLowerCase());
        return location == null ? null : location.clone();
    }

    public boolean addMobSpawner(@NotNull Location location) {
        if (this.getMobSpawners().containsValue(location)) {
            return false;
        }
        Block block = location.getBlock();
        String string = "s";
        int n = 0;
        String string2 = string + n;
        while (this.getMobSpawners().containsKey(string2)) {
            string2 = string + ++n;
        }
        this.getMobSpawners().put(string2, location);
        return true;
    }

    @Override
    @NotNull
    public HologramType getHologramType() {
        return this.isLocked() ? HologramType.REGION_LOCKED : HologramType.REGION_UNLOCKED;
    }

    @Override
    @NotNull
    public Set<Location> getHologramLocations() {
        return this.hologramLocations;
    }

    @Override
    @NotNull
    public Set<UUID> getHologramIds() {
        return this.hologramIds;
    }

    @Override
    @NotNull
    public List<String> getHologramFormat() {
        List<String> list = HologramManager.getFormat(this.getHologramType());
        list.replaceAll(this.replacePlaceholders());
        return list;
    }
}

