/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.condition;

import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.TriFunction;
import su.nightexpress.ama.arena.lock.LockState;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.arena.region.ArenaRegionManager;
import su.nightexpress.ama.arena.script.condition.ScriptCondition;
import su.nightexpress.ama.arena.shop.ShopManager;
import su.nightexpress.ama.arena.shop.impl.ShopCategory;
import su.nightexpress.ama.arena.shop.impl.ShopProduct;

public class ScriptConditionPrefabs {
    @NotNull
    public static TriFunction<ArenaRegionManager, String, ScriptCondition.Operator, Boolean> forRegion(@NotNull LockState lockState) {
        return (arenaRegionManager, string, operator) -> {
            ArenaRegion arenaRegion = arenaRegionManager.getRegion((String)string);
            return arenaRegion == null || arenaRegion.getLockState() == lockState;
        };
    }

    @NotNull
    public static TriFunction<ShopManager, String, ScriptCondition.Operator, Boolean> forShopCategory(@NotNull LockState lockState) {
        return (shopManager, string, operator) -> {
            ShopCategory shopCategory = shopManager.getCategory((String)string);
            return shopCategory == null || shopCategory.getLockState() == lockState;
        };
    }

    @NotNull
    public static TriFunction<ShopManager, String, ScriptCondition.Operator, Boolean> forShopProduct(@NotNull LockState lockState) {
        return (shopManager, string, operator) -> {
            String[] stringArray = string.split(":");
            if (stringArray.length < 2) {
                return false;
            }
            ShopCategory shopCategory = shopManager.getCategory(stringArray[0]);
            if (shopCategory == null) {
                return true;
            }
            ShopProduct shopProduct = shopCategory.getProduct(stringArray[1]);
            return shopProduct == null || shopProduct.getLockState() == lockState;
        };
    }
}

