/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.condition;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.StringUtil;
import su.nexmedia.engine.utils.TriFunction;
import su.nexmedia.engine.utils.random.Rnd;
import su.nightexpress.ama.api.event.ArenaGameGenericEvent;
import su.nightexpress.ama.api.event.ArenaRegionEvent;
import su.nightexpress.ama.api.event.ArenaShopCategoryEvent;
import su.nightexpress.ama.api.event.ArenaShopProductEvent;
import su.nightexpress.ama.api.event.ArenaSpotStateChangeEvent;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.api.type.PlayerType;
import su.nightexpress.ama.arena.lock.LockState;
import su.nightexpress.ama.arena.region.ArenaRegion;
import su.nightexpress.ama.arena.region.ArenaRegionManager;
import su.nightexpress.ama.arena.script.condition.ScriptCondition;
import su.nightexpress.ama.arena.script.condition.ScriptConditionPrefabs;
import su.nightexpress.ama.arena.shop.ShopManager;

public class ScriptConditions {
    private static final Map<String, ScriptCondition<?, ?>> REGISTRY = new HashMap();
    public static final ScriptCondition<Number, Number> CHANCE = ScriptConditions.numeric("chance", arenaGameGenericEvent -> Float.valueOf(Rnd.get((boolean)true)));
    public static final ScriptCondition<Number, Number> WAVE_NUMBER = ScriptConditions.numeric("wave_number", arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getRoundNumber());
    public static final ScriptCondition<Number[], Number> ROUND_NUMBER = ScriptConditions.numerics("round_number", arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getRoundNumber());
    public static final ScriptCondition<Number, Number> PLAYERS_AMOUNT = ScriptConditions.numeric("players_amount", arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getPlayers(GameState.INGAME, PlayerType.REAL).size());
    public static final ScriptCondition<Number, Number> ENEMY_MOBS_AMOUNT = ScriptConditions.numeric("enemy_mobs_amount", arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getMobs().getEnemies().size());
    public static final ScriptCondition<Number, Number> ALLY_MOBS_AMOUNT = ScriptConditions.numeric("ally_mobs_amount", arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getMobs().getAllies().size());
    public static final ScriptCondition<Number, Number> GAME_SCORE = ScriptConditions.numeric("game_score", arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getGameScore());
    public static final ScriptCondition<String, ArenaRegionManager> REGION_UNLOCKED = ScriptConditions.register("region_unlocked", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getRegionManager(), ScriptConditionPrefabs.forRegion(LockState.UNLOCKED));
    public static final ScriptCondition<String, ArenaRegionManager> REGION_LOCKED = ScriptConditions.register("region_locked", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getRegionManager(), ScriptConditionPrefabs.forRegion(LockState.LOCKED));
    public static final ScriptCondition<String, ShopManager> SHOP_UNLOCKED = ScriptConditions.register("shop_unlocked", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getShopManager(), (shopManager, string, operator) -> shopManager.isUnlocked());
    public static final ScriptCondition<String, ShopManager> SHOP_LOCKED = ScriptConditions.register("shop_locked", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getShopManager(), (shopManager, string, operator) -> shopManager.isLocked());
    public static final ScriptCondition<String, ShopManager> SHOP_CATEGORY_UNLOCKED = ScriptConditions.register("shop_category_unlocked", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getShopManager(), ScriptConditionPrefabs.forShopCategory(LockState.UNLOCKED));
    public static final ScriptCondition<String, ShopManager> SHOP_CATEGORY_LOCKED = ScriptConditions.register("shop_category_locked", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getShopManager(), ScriptConditionPrefabs.forShopCategory(LockState.LOCKED));
    public static final ScriptCondition<String, ShopManager> SHOP_PRODUCT_UNLOCKED = ScriptConditions.register("shop_product_unlocked", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getShopManager(), ScriptConditionPrefabs.forShopProduct(LockState.UNLOCKED));
    public static final ScriptCondition<String, ShopManager> SHOP_PRODUCT_LOCKED = ScriptConditions.register("shop_product_locked", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getShopManager(), ScriptConditionPrefabs.forShopProduct(LockState.LOCKED));
    public static final ScriptCondition<String, ArenaRegionManager> REGION_IS_EMPTY = ScriptConditions.register("region_is_empty", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getRegionManager(), (arenaRegionManager, string, operator) -> {
        ArenaRegion arenaRegion = arenaRegionManager.getRegion((String)string);
        return arenaRegion == null || arenaRegion.getPlayers().isEmpty();
    });
    public static final ScriptCondition<String, ArenaRegionManager> REGION_NOT_EMPTY = ScriptConditions.register("region_not_empty", string -> string, arenaGameGenericEvent -> arenaGameGenericEvent.getArena().getConfig().getRegionManager(), (arenaRegionManager, string, operator) -> {
        ArenaRegion arenaRegion = arenaRegionManager.getRegion((String)string);
        return arenaRegion == null || !arenaRegion.getPlayers().isEmpty();
    });
    public static final ScriptCondition<String, String> REGION_ID = ScriptConditions.string("region_id", arenaGameGenericEvent -> ((ArenaRegionEvent)((Object)arenaGameGenericEvent)).getArenaRegion().getId());
    public static final ScriptCondition<String, String> SHOP_CATEGORY_ID = ScriptConditions.string("shop_category_id", arenaGameGenericEvent -> {
        String string;
        if (arenaGameGenericEvent instanceof ArenaShopProductEvent) {
            ArenaShopProductEvent arenaShopProductEvent = (ArenaShopProductEvent)((Object)arenaGameGenericEvent);
            string = arenaShopProductEvent.getShopProduct().getShopCategory().getId();
        } else {
            string = ((ArenaShopCategoryEvent)((Object)arenaGameGenericEvent)).getShopCategory().getId();
        }
        return string;
    });
    public static final ScriptCondition<String, String> SHOP_PRODUCT_ID = ScriptConditions.string("shop_product_id", arenaGameGenericEvent -> ((ArenaShopProductEvent)((Object)arenaGameGenericEvent)).getShopProduct().getId());
    public static final ScriptCondition<String, String> SPOT_ID = ScriptConditions.string("spot_id", arenaGameGenericEvent -> ((ArenaSpotStateChangeEvent)((Object)arenaGameGenericEvent)).getSpot().getId());
    public static final ScriptCondition<String, String> SPOT_STATE_ID = ScriptConditions.string("spot_state_id", arenaGameGenericEvent -> ((ArenaSpotStateChangeEvent)((Object)arenaGameGenericEvent)).getNewState().getId());

    @NotNull
    public static <C, E> ScriptCondition<C, E> register(@NotNull String string, @NotNull Function<String, C> function, @NotNull Function<ArenaGameGenericEvent, E> function2, @NotNull TriFunction<E, C, ScriptCondition.Operator, Boolean> triFunction) {
        ScriptCondition<C, E> scriptCondition = new ScriptCondition<C, E>(string, function, function2, triFunction);
        return ScriptConditions.register(scriptCondition);
    }

    @NotNull
    public static ScriptCondition<Number, Number> numeric(@NotNull String string2, @NotNull Function<ArenaGameGenericEvent, Number> function) {
        Function<String, Number> function2 = string -> StringUtil.getDouble((String)string, (double)0.0);
        TriFunction triFunction = (number, number2, operator) -> switch (operator) {
            default -> throw new IncompatibleClassChangeError();
            case ScriptCondition.Operator.EQUAL -> number.doubleValue() == number2.doubleValue();
            case ScriptCondition.Operator.NOT_EQUAL -> number.doubleValue() != number2.doubleValue();
            case ScriptCondition.Operator.GREATER -> number.doubleValue() > number2.doubleValue();
            case ScriptCondition.Operator.SMALLER -> number.doubleValue() < number2.doubleValue();
            case ScriptCondition.Operator.EACH -> number.intValue() % number2.intValue() == 0;
            case ScriptCondition.Operator.EACH_NOT -> number.intValue() % number2.intValue() != 0;
        };
        return ScriptConditions.register(string2, function2, function, triFunction);
    }

    @NotNull
    public static ScriptCondition<Number[], Number> numerics(@NotNull String string2, @NotNull Function<ArenaGameGenericEvent, Number> function) {
        Function<String, Number[]> function2 = string -> {
            String[] stringArray = StringUtil.noSpace((String)string).split(",");
            Number[] numberArray = new Integer[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    numberArray[i] = Integer.parseInt(stringArray[i]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    numberArray[i] = 0;
                }
            }
            return numberArray;
        };
        TriFunction triFunction = (number, numberArray, operator) -> Arrays.stream(numberArray).anyMatch(number2 -> switch (operator) {
            default -> throw new IncompatibleClassChangeError();
            case ScriptCondition.Operator.EQUAL -> {
                if (number.doubleValue() == number2.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case ScriptCondition.Operator.NOT_EQUAL -> {
                if (number.doubleValue() != number2.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case ScriptCondition.Operator.GREATER -> {
                if (number.doubleValue() > number2.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case ScriptCondition.Operator.SMALLER -> {
                if (number.doubleValue() < number2.doubleValue()) {
                    yield true;
                }
                yield false;
            }
            case ScriptCondition.Operator.EACH -> {
                if (number.intValue() % number2.intValue() == 0) {
                    yield true;
                }
                yield false;
            }
            case ScriptCondition.Operator.EACH_NOT -> number.intValue() % number2.intValue() != 0;
        });
        return ScriptConditions.register(string2, function2, function, triFunction);
    }

    @NotNull
    public static ScriptCondition<String, String> string(@NotNull String string3, @NotNull Function<ArenaGameGenericEvent, String> function) {
        Function<String, String> function2 = Colorizer::strip;
        TriFunction triFunction = (string, string2, operator) -> {
            if (operator == ScriptCondition.Operator.NOT_EQUAL) {
                return !string.equalsIgnoreCase((String)string2);
            }
            return string.equalsIgnoreCase((String)string2) || string2.equalsIgnoreCase("*");
        };
        return ScriptConditions.register(string3, function2, function, triFunction);
    }

    @NotNull
    public static <C, E> ScriptCondition<C, E> register(@NotNull ScriptCondition<C, E> scriptCondition) {
        REGISTRY.put(scriptCondition.getName(), scriptCondition);
        return scriptCondition;
    }

    @Nullable
    public static ScriptCondition<?, ?> getByName(@NotNull String string) {
        return REGISTRY.get(string.toLowerCase());
    }

    @NotNull
    public static Set<ScriptCondition<?, ?>> getConditions() {
        return new HashSet(REGISTRY.values());
    }
}

