/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.api.event.ArenaGameGenericEvent;
import su.nightexpress.ama.arena.editor.script.ScriptActionsEditor;
import su.nightexpress.ama.arena.editor.script.ScriptConditionsEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.script.action.ParameterResult;
import su.nightexpress.ama.arena.script.action.ScriptAction;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.condition.ScriptCondition;
import su.nightexpress.ama.arena.script.condition.ScriptConditions;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ScriptCategory;

public class ArenaScript
implements ArenaChild {
    private final ArenaConfig arenaConfig;
    private final String id;
    private ArenaGameEventType eventType;
    private final Map<String, List<ScriptPreparedCondition>> conditions;
    private final List<ScriptPreparedAction> actions;
    private ScriptActionsEditor actionsEditor;
    private ScriptConditionsEditor conditionsEditor;

    public ArenaScript(@NotNull ArenaConfig arenaConfig, @NotNull String string, @NotNull ArenaGameEventType arenaGameEventType) {
        this.arenaConfig = arenaConfig;
        this.id = string.toLowerCase();
        this.setEventType(arenaGameEventType);
        this.conditions = new HashMap<String, List<ScriptPreparedCondition>>();
        this.actions = new ArrayList<ScriptPreparedAction>();
    }

    @NotNull
    public static Map<String, List<ScriptPreparedCondition>> ofGameTrigger(@NotNull ArenaGameEventType arenaGameEventType, @NotNull String string) {
        ScriptCondition<Object, Object> scriptCondition;
        HashMap<String, List<ScriptPreparedCondition>> hashMap = new HashMap<String, List<ScriptPreparedCondition>>();
        String[] stringArray = string.split(" OR ");
        switch (arenaGameEventType) {
            case WAVE_END: 
            case WAVE_START: {
                ScriptCondition<Object, Object> scriptCondition2 = ScriptConditions.WAVE_NUMBER;
                break;
            }
            case SHOP_LOCKED: {
                ScriptCondition<Object, Object> scriptCondition2 = ScriptConditions.SHOP_LOCKED;
                break;
            }
            case SHOP_UNLOCKED: {
                ScriptCondition<Object, Object> scriptCondition2 = ScriptConditions.SHOP_UNLOCKED;
                break;
            }
            case REGION_LOCKED: {
                ScriptCondition<Object, Object> scriptCondition2 = ScriptConditions.REGION_LOCKED;
                break;
            }
            case REGION_UNLOCKED: {
                ScriptCondition<Object, Object> scriptCondition2 = ScriptConditions.REGION_UNLOCKED;
                break;
            }
            case SHOP_ITEM_LOCKED: {
                ScriptCondition<Object, Object> scriptCondition2 = ScriptConditions.SHOP_PRODUCT_LOCKED;
                break;
            }
            case SHOP_ITEM_UNLOCKED: {
                ScriptCondition<Object, Object> scriptCondition2 = ScriptConditions.SHOP_PRODUCT_UNLOCKED;
                break;
            }
            case SHOP_CATEGORY_LOCKED: {
                ScriptCondition<Object, Object> scriptCondition2 = ScriptConditions.SHOP_CATEGORY_LOCKED;
                break;
            }
            case SHOP_CATEGORY_UNLOCKED: {
                ScriptCondition<Object, Object> scriptCondition2 = ScriptConditions.SHOP_CATEGORY_UNLOCKED;
                break;
            }
            default: {
                ScriptCondition<Object, Object> scriptCondition2 = scriptCondition = null;
            }
        }
        if (scriptCondition == null) {
            return hashMap;
        }
        for (String string2 : stringArray) {
            String[] stringArray2 = string.split(",");
            ArrayList<ScriptPreparedCondition> arrayList = new ArrayList<ScriptPreparedCondition>();
            String string3 = UUID.randomUUID().toString();
            for (String string4 : stringArray2) {
                ScriptCondition.Operator operator = ScriptCondition.Operator.EQUAL;
                for (ScriptCondition.Operator operator2 : ScriptCondition.Operator.values()) {
                    if (!string4.startsWith(operator2.getRaw())) continue;
                    string4 = string4.substring(operator2.getRaw().length());
                    operator = operator2;
                    break;
                }
                ScriptPreparedCondition object = new ScriptPreparedCondition(scriptCondition, scriptCondition.getParser().apply(string4), operator);
                arrayList.add(object);
            }
            hashMap.put(string3, arrayList);
        }
        return hashMap;
    }

    public void clear() {
        if (this.actionsEditor != null) {
            this.actionsEditor.clear();
            this.actionsEditor = null;
        }
        if (this.conditionsEditor != null) {
            this.conditionsEditor.clear();
            this.conditionsEditor = null;
        }
    }

    @NotNull
    public ScriptActionsEditor getActionsEditor(@NotNull ScriptCategory scriptCategory) {
        if (this.actionsEditor == null) {
            this.actionsEditor = new ScriptActionsEditor(scriptCategory, this);
        }
        return this.actionsEditor;
    }

    @NotNull
    public ScriptConditionsEditor getConditionsEditor(@NotNull ScriptCategory scriptCategory) {
        if (this.conditionsEditor == null) {
            this.conditionsEditor = new ScriptConditionsEditor(scriptCategory, this);
        }
        return this.conditionsEditor;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public ArenaGameEventType getEventType() {
        return this.eventType;
    }

    public void setEventType(@NotNull ArenaGameEventType arenaGameEventType) {
        this.eventType = arenaGameEventType;
    }

    @NotNull
    public Map<String, List<ScriptPreparedCondition>> getConditions() {
        return this.conditions;
    }

    @NotNull
    public List<ScriptPreparedAction> getActions() {
        return this.actions;
    }

    public boolean onArenaEvent(@NotNull ArenaGameGenericEvent arenaGameGenericEvent) {
        if (this.getEventType() != arenaGameGenericEvent.getEventType()) {
            return false;
        }
        if (!this.conditions.isEmpty() && this.conditions.values().stream().noneMatch(list -> list.stream().allMatch(scriptPreparedCondition -> {
            ScriptCondition<?, ?> scriptCondition = scriptPreparedCondition.getCondition();
            Object object = scriptPreparedCondition.getValue();
            ScriptCondition.Operator operator = scriptPreparedCondition.getOperator();
            return scriptCondition.test(arenaGameGenericEvent, object, operator);
        }))) {
            return false;
        }
        this.actions.forEach(scriptPreparedAction -> {
            ScriptAction scriptAction = scriptPreparedAction.getAction();
            ParameterResult parameterResult = scriptPreparedAction.getParameters();
            scriptAction.run(arenaGameGenericEvent, parameterResult);
        });
        return true;
    }
}

