/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.script.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.arena.type.ArenaGameEventType;
import su.nightexpress.ama.arena.editor.script.ScriptsCategoryEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.script.action.ScriptPreparedAction;
import su.nightexpress.ama.arena.script.condition.ScriptPreparedCondition;
import su.nightexpress.ama.arena.script.impl.ArenaScript;

public class ScriptCategory
extends AbstractConfigHolder<AMA>
implements ArenaChild {
    private final ArenaConfig arenaConfig;
    private final Map<String, ArenaScript> scripts;
    private ScriptsCategoryEditor editor;

    public ScriptCategory(@NotNull ArenaConfig arenaConfig, @NotNull JYML jYML) {
        super((NexPlugin)((AMA)arenaConfig.plugin()), jYML);
        this.arenaConfig = arenaConfig;
        this.scripts = new HashMap<String, ArenaScript>();
    }

    public boolean load() {
        for (String string : this.cfg.getSection("")) {
            Object object;
            String string2 = string + ".";
            ArenaGameEventType arenaGameEventType = (ArenaGameEventType)this.cfg.getEnum(string2 + "Event", ArenaGameEventType.class);
            if (arenaGameEventType == null) {
                ((AMA)this.plugin()).warn("Invalid event type in '" + string + "' arena script.");
                continue;
            }
            ArenaScript arenaScript = new ArenaScript(this.arenaConfig, string, arenaGameEventType);
            for (String string3 : this.cfg.getSection(string2 + "Conditions")) {
                object = new ArrayList();
                for (String string4 : this.cfg.getStringList(string2 + "Conditions." + string3)) {
                    ScriptPreparedCondition scriptPreparedCondition = ScriptPreparedCondition.parse(string4);
                    if (scriptPreparedCondition == null) {
                        ((AMA)this.plugin()).warn("Could not parse script condition: '" + string4 + "'!");
                        continue;
                    }
                    object.add(scriptPreparedCondition);
                }
                arenaScript.getConditions().put(string3.toLowerCase(), (List<ScriptPreparedCondition>)object);
            }
            for (String string3 : this.cfg.getStringList(string2 + "Actions")) {
                object = ScriptPreparedAction.parse(string3);
                if (object == null) {
                    ((AMA)this.plugin()).warn("Could not parse script action: '" + string3 + "'!");
                    continue;
                }
                arenaScript.getActions().add((ScriptPreparedAction)object);
            }
            this.getScriptsMap().put(arenaScript.getId(), arenaScript);
        }
        return true;
    }

    public void onSave() {
        this.cfg.getSection("").forEach(arg_0 -> ((JYML)this.cfg).remove(arg_0));
        this.getScripts().forEach(arenaScript -> {
            String string = arenaScript.getId() + ".";
            this.cfg.set(string + "Event", (Object)arenaScript.getEventType().name());
            arenaScript.getConditions().forEach((string2, list) -> this.cfg.set(string + "Conditions." + string2, list.stream().map(ScriptPreparedCondition::toRaw).toList()));
            this.cfg.set(string + "Actions", arenaScript.getActions().stream().map(ScriptPreparedAction::toRaw).toList());
        });
    }

    public void clear() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        this.getScripts().forEach(ArenaScript::clear);
        this.getScripts().clear();
    }

    @NotNull
    public ScriptsCategoryEditor getEditor() {
        if (this.editor == null) {
            this.editor = new ScriptsCategoryEditor(this);
        }
        return this.editor;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public Map<String, ArenaScript> getScriptsMap() {
        return this.scripts;
    }

    @NotNull
    public Collection<ArenaScript> getScripts() {
        return this.scripts.values();
    }

    @NotNull
    public Optional<ArenaScript> getScript(@NotNull String string) {
        return Optional.ofNullable(this.getScriptsMap().get(string.toLowerCase()));
    }

    public boolean createScript(@NotNull String string) {
        if (this.getScript(string).isPresent()) {
            return false;
        }
        ArenaScript arenaScript = new ArenaScript(this.getArenaConfig(), string, ArenaGameEventType.WAVE_START);
        this.getScriptsMap().put(arenaScript.getId(), arenaScript);
        return true;
    }
}

