/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.setup;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.LocationUtil;
import su.nightexpress.ama.api.ArenaAPI;

public class ArenaSetupUtils {
    private static final Map<Player, List<Integer>> VISUALS_MAP = new WeakHashMap<Player, List<Integer>>();

    public static void removeVisuals(@NotNull Player player) {
        List<Integer> list = VISUALS_MAP.remove(player);
        if (list == null) {
            return;
        }
        list.forEach(n -> ArenaAPI.getArenaNMS().visualEntityRemove(player, (int)n));
    }

    public static void addVisualText(@NotNull Player player2, @NotNull String string, @NotNull Location location) {
        List list = VISUALS_MAP.computeIfAbsent(player2, player -> new ArrayList());
        int n = ArenaAPI.getArenaNMS().visualEntityAdd(player2, string, LocationUtil.getCenter((Location)location.clone().add(0.0, 0.5, 0.0), (boolean)false));
        list.add(n);
    }

    public static void addVisualBlock(@NotNull Player player2, @NotNull Location location) {
        List list = VISUALS_MAP.computeIfAbsent(player2, player -> new ArrayList());
        Location location2 = new Location(location.getWorld(), location.getX(), location.getY(), location.getZ());
        int n = ArenaAPI.getArenaNMS().visualGlowBlockAdd(player2, LocationUtil.getCenter((Location)location2, (boolean)false));
        list.add(n);
    }
}

