/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.setup.manager;

import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.arena.type.ArenaLocationType;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.setup.ArenaSetupUtils;
import su.nightexpress.ama.arena.setup.SetupItemType;
import su.nightexpress.ama.arena.setup.manager.AbstractSetupManager;
import su.nightexpress.ama.config.Lang;

public class ArenaConfigSetupManager
extends AbstractSetupManager<ArenaConfig> {
    public ArenaConfigSetupManager(@NotNull AMA aMA) {
        super(aMA);
    }

    @Override
    protected void onSetupStart(@NotNull Player player, @NotNull ArenaConfig arenaConfig) {
        PlayerInventory playerInventory = player.getInventory();
        playerInventory.setItem(2, SetupItemType.ARENA_LOCATION_LOBBY.getItem());
        playerInventory.setItem(4, SetupItemType.ARENA_LOCATION_LEAVE.getItem());
        playerInventory.setItem(6, SetupItemType.ARENA_LOCATION_SPECTATE.getItem());
        playerInventory.setItem(8, SetupItemType.ARENA_EXIT.getItem());
    }

    @Override
    protected void onSetupEnd(@NotNull Player player, @NotNull ArenaConfig arenaConfig) {
        arenaConfig.getEditor().open(player, 1);
    }

    @Override
    protected void handleItem(@NotNull PlayerInteractEvent playerInteractEvent, @NotNull Player player, @NotNull ArenaConfig arenaConfig, @NotNull ItemStack itemStack, @NotNull SetupItemType setupItemType) {
        switch (setupItemType) {
            case ARENA_LOCATION_LOBBY: {
                Location location = player.getLocation();
                arenaConfig.setLocation(ArenaLocationType.LOBBY, location);
                arenaConfig.save();
                ((AMA)this.plugin).getMessage(Lang.Setup_Arena_Lobby_Set).replace(arenaConfig.replacePlaceholders()).send((CommandSender)player);
                break;
            }
            case ARENA_LOCATION_LEAVE: {
                Location location = player.getLocation();
                Action action = playerInteractEvent.getAction();
                if (action == Action.RIGHT_CLICK_BLOCK || action == Action.RIGHT_CLICK_AIR) {
                    ((AMA)this.plugin).getMessage(Lang.Setup_Arena_Leave_Set).replace(arenaConfig.replacePlaceholders()).send((CommandSender)player);
                    arenaConfig.setLocation(ArenaLocationType.LEAVE, location);
                } else if (action == Action.LEFT_CLICK_BLOCK || action == Action.LEFT_CLICK_AIR) {
                    ((AMA)this.plugin).getMessage(Lang.Setup_Arena_Leave_UnSet).replace(arenaConfig.replacePlaceholders()).send((CommandSender)player);
                    arenaConfig.setLocation(ArenaLocationType.LEAVE, null);
                } else {
                    return;
                }
                arenaConfig.save();
                break;
            }
            case ARENA_LOCATION_SPECTATE: {
                Location location = player.getLocation();
                arenaConfig.setLocation(ArenaLocationType.SPECTATE, location);
                arenaConfig.save();
                ((AMA)this.plugin).getMessage(Lang.Setup_Arena_Spectate_Set).replace(arenaConfig.replacePlaceholders()).send((CommandSender)player);
                break;
            }
            case ARENA_EXIT: {
                this.endSetup(player);
            }
        }
    }

    @Override
    protected void updateVisuals() {
        Location location;
        Location location2;
        Location location3 = ((ArenaConfig)this.object).getLocation(ArenaLocationType.LOBBY);
        if (location3 != null) {
            ArenaSetupUtils.addVisualText(this.player, "&a\u00ab Lobby Location \u00bb", location3);
            ArenaSetupUtils.addVisualBlock(this.player, location3);
        }
        if ((location2 = ((ArenaConfig)this.object).getLocation(ArenaLocationType.LEAVE)) != null) {
            ArenaSetupUtils.addVisualText(this.player, "&c\u00ab Leave Location \u00bb", location2);
            ArenaSetupUtils.addVisualBlock(this.player, location2);
        }
        if ((location = ((ArenaConfig)this.object).getLocation(ArenaLocationType.SPECTATE)) != null) {
            ArenaSetupUtils.addVisualText(this.player, "&b\u00ab Spectate Location \u00bb", location);
            ArenaSetupUtils.addVisualBlock(this.player, location);
        }
    }

    @Override
    protected void removeVisuals() {
        ArenaSetupUtils.removeVisuals(this.player);
    }
}

