/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.spot;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.placeholder.Placeholder;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.utils.LocationUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.api.event.ArenaSpotStateChangeEvent;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.spot.ArenaSpot;

public class ArenaSpotState
implements ArenaChild,
Placeholder {
    private final ArenaSpot spot;
    private final String id;
    private List<String> schemeRaw;
    private final Map<Location, BlockData> scheme;
    private final PlaceholderMap placeholderMap;

    public ArenaSpotState(@NotNull ArenaSpot arenaSpot, @NotNull String string, @NotNull List<String> list) {
        this.spot = arenaSpot;
        this.id = string.toLowerCase();
        this.scheme = new HashMap<Location, BlockData>();
        this.setSchemeRaw(list);
        this.placeholderMap = new PlaceholderMap().add("%spot_state_id%", this::getId);
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    @NotNull
    public ArenaSpot getSpot() {
        return this.spot;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.getSpot().getArenaConfig();
    }

    public void setSchemeRaw(@NotNull List<String> list) {
        this.schemeRaw = list;
        this.scheme.clear();
        AMA aMA = (AMA)this.getSpot().plugin();
        for (String string : list) {
            String[] stringArray = string.split("~");
            if (stringArray.length != 2) {
                aMA.error("Invalid block '" + string + "' in '" + this.id + "' state of '" + this.spot.getFile().getName() + "' spot in '" + this.spot.getArenaConfig().getId() + "' arena!");
                continue;
            }
            Location location = LocationUtil.deserialize((String)stringArray[0]);
            if (location == null) {
                aMA.error("Invalid block location '" + string + "' in '" + this.id + "' state of '" + this.spot.getFile().getName() + "' spot in '" + this.spot.getArenaConfig().getId() + "' arena!");
                continue;
            }
            if (this.spot.getCuboid().isEmpty() || !this.spot.getCuboid().get().contains(location)) {
                aMA.error("Block is outside of the spot region: '" + string + "' in '" + this.id + "' state of '" + this.spot.getFile().getName() + "' spot in '" + this.spot.getArenaConfig().getId() + "' arena!");
                continue;
            }
            BlockData blockData = aMA.getServer().createBlockData(stringArray[1]);
            this.scheme.put(location, blockData);
        }
    }

    @NotNull
    public List<String> getSchemeRaw() {
        return this.schemeRaw;
    }

    @NotNull
    public Map<Location, BlockData> getScheme() {
        return this.scheme;
    }

    public void build() {
        this.getScheme().forEach((location, blockData) -> {
            Block block = location.getBlock();
            if (block.getBlockData().matches(blockData)) {
                return;
            }
            block.setBlockData(blockData);
        });
    }

    public void build(@NotNull Arena arena) {
        this.build();
        ArenaSpotStateChangeEvent arenaSpotStateChangeEvent = new ArenaSpotStateChangeEvent(arena, this.getSpot(), this);
        ((AMA)this.getSpot().plugin()).getPluginManager().callEvent((Event)arenaSpotStateChangeEvent);
    }
}

