/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.arena.supply;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.Container;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.arena.ArenaChild;
import su.nightexpress.ama.arena.editor.supply.SupplyChestListEditor;
import su.nightexpress.ama.arena.impl.ArenaConfig;
import su.nightexpress.ama.arena.supply.ArenaSupplyChest;

public class ArenaSupplyManager
extends AbstractConfigHolder<AMA>
implements ArenaChild {
    public static final String CONFIG_NAME = "supply.yml";
    private final ArenaConfig arenaConfig;
    private final Map<String, ArenaSupplyChest> chests;
    private SupplyChestListEditor editor;

    public ArenaSupplyManager(@NotNull ArenaConfig arenaConfig, @NotNull JYML jYML) {
        super((NexPlugin)((AMA)arenaConfig.plugin()), jYML);
        this.arenaConfig = arenaConfig;
        this.chests = new HashMap<String, ArenaSupplyChest>();
    }

    public boolean load() {
        for (String string : this.cfg.getSection("Chests")) {
            BlockState blockState;
            String string2 = "Chests." + string + ".";
            Location location = this.cfg.getLocation(string2 + "Location");
            if (location == null || !((blockState = location.getBlock().getState()) instanceof Container)) {
                ((AMA)this.plugin).error("No valid container at location of the '" + string + "' supply chest!");
                continue;
            }
            Container container = (Container)blockState;
            int n = this.cfg.getInt(string2 + "Refill.Items.Min");
            int n2 = this.cfg.getInt(string2 + "Refill.Items.Max");
            List<ItemStack> list = Arrays.asList(this.cfg.getItemsEncoded(string2 + "Items"));
            ArenaSupplyChest arenaSupplyChest = new ArenaSupplyChest(this.arenaConfig, string, container.getLocation(), n, n2, list);
            this.getArenaConfig().getSupplyManager().getChestsMap().put(arenaSupplyChest.getId(), arenaSupplyChest);
        }
        return true;
    }

    public void onSave() {
        this.cfg.remove("Chests");
        this.getChests().forEach(arenaSupplyChest -> {
            String string = "Chests." + arenaSupplyChest.getId() + ".";
            this.cfg.set(string + "Location", (Object)arenaSupplyChest.getLocation());
            this.cfg.set(string + "Refill.Items.Min", (Object)arenaSupplyChest.getMinItems());
            this.cfg.set(string + "Refill.Items.Max", (Object)arenaSupplyChest.getMaxItems());
            this.cfg.setItemsEncoded(string + "Items", arenaSupplyChest.getItems());
        });
    }

    public void clear() {
        if (this.editor != null) {
            this.editor.clear();
            this.editor = null;
        }
        this.getChests().forEach(ArenaSupplyChest::clear);
        this.getChestsMap().clear();
    }

    @NotNull
    public SupplyChestListEditor getEditor() {
        if (this.editor == null) {
            this.editor = new SupplyChestListEditor(this);
        }
        return this.editor;
    }

    @Override
    @NotNull
    public ArenaConfig getArenaConfig() {
        return this.arenaConfig;
    }

    @NotNull
    public Map<String, ArenaSupplyChest> getChestsMap() {
        return this.chests;
    }

    @NotNull
    public Collection<ArenaSupplyChest> getChests() {
        return this.getChestsMap().values();
    }

    public boolean createChest(@NotNull String string) {
        if (this.getChest(string) != null) {
            return false;
        }
        ArenaSupplyChest arenaSupplyChest = new ArenaSupplyChest(this.getArenaConfig(), string);
        this.getChestsMap().put(arenaSupplyChest.getId(), arenaSupplyChest);
        this.save();
        return true;
    }

    @Nullable
    public ArenaSupplyChest getChest(@NotNull Block block) {
        return this.getChests().stream().filter(arenaSupplyChest -> arenaSupplyChest.getLocation() != null && arenaSupplyChest.getLocation().getBlock().equals(block)).findFirst().orElse(null);
    }

    @Nullable
    public ArenaSupplyChest getChest(@NotNull String string) {
        return this.getChestsMap().get(string.toLowerCase());
    }

    public void emptyChests() {
        this.getChests().forEach(arenaSupplyChest -> arenaSupplyChest.getContainer().ifPresent(container -> container.getInventory().clear()));
    }
}

