/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command;

import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.config.Lang;

public class JoinCommand
extends AbstractCommand<AMA> {
    public JoinCommand(@NotNull AMA aMA) {
        super((NexPlugin)aMA, new String[]{"join"}, (Permission)Perms.COMMAND_JOIN);
        this.setDescription(aMA.getMessage(Lang.COMMAND_JOIN_DESC));
        this.setUsage(aMA.getMessage(Lang.COMMAND_JOIN_USAGE));
        this.setPlayerOnly(true);
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 1) {
            return ((AMA)this.plugin).getArenaManager().getArenas(player).stream().map(Arena::getId).toList();
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        Arena arena;
        Player player = (Player)commandSender;
        if (commandResult.length() == 2) {
            arena = ((AMA)this.plugin).getArenaManager().getArenaById(commandResult.getArg(1));
            if (arena == null) {
                ((AMA)this.plugin).getMessage(Lang.ARENA_ERROR_INVALID).send(commandSender);
                return;
            }
        } else {
            arena = ((AMA)this.plugin).getArenaManager().getArenas(player).stream().findFirst().orElse(null);
            if (arena == null) {
                ((AMA)this.plugin).getMessage(Lang.COMMAND_JOIN_NOTHING).send((CommandSender)player);
                return;
            }
        }
        arena.joinLobby(player);
    }
}

