/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.type.PlayerType;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.config.Lang;

public class ScoreCmd
extends AbstractCommand<AMA> {
    public ScoreCmd(@NotNull AMA aMA) {
        super((NexPlugin)aMA, new String[]{"score"}, (Permission)Perms.COMMAND_SCORE);
    }

    @NotNull
    public String getUsage() {
        return ((AMA)this.plugin).getMessage(Lang.Command_Score_Usage).getLocalized();
    }

    @NotNull
    public String getDescription() {
        return ((AMA)this.plugin).getMessage(Lang.Command_Score_Desc).getLocalized();
    }

    public boolean isPlayerOnly() {
        return false;
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 1) {
            return Arrays.asList("add", "take", "set");
        }
        if (n == 2) {
            ArrayList<String> arrayList = new ArrayList<String>();
            ((AMA)this.plugin).getArenaManager().getArenas().forEach(arena -> arrayList.addAll(arena.getPlayers(PlayerType.REAL).stream().map(arenaPlayer -> arenaPlayer.getPlayer().getName()).collect(Collectors.toList())));
            return arrayList;
        }
        if (n == 3) {
            return Arrays.asList("<amount>", "10", "50", "100");
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        if (commandResult.length() != 4) {
            ((AMA)this.plugin).getMessage(Lang.Help_Score).send(commandSender);
            return;
        }
        if (commandResult.getArg(1).equalsIgnoreCase("add")) {
            Player player = ((AMA)this.plugin).getServer().getPlayer(commandResult.getArg(2));
            if (player == null) {
                this.errorPlayer(commandSender);
                return;
            }
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                ((AMA)this.plugin).getMessage(Lang.Command_Score_Error_NotInGame).send(commandSender);
                return;
            }
            int n = commandResult.getInt(3, -1);
            if (n < 0) {
                return;
            }
            arenaPlayer.addScore(n);
            ((AMA)this.plugin).getMessage(Lang.Command_Score_Add_Done).replace("%player%", (Object)player.getName()).replace("%points%", (Object)n).send(commandSender);
        } else if (commandResult.getArg(1).equalsIgnoreCase("take")) {
            Player player = ((AMA)this.plugin).getServer().getPlayer(commandResult.getArg(2));
            if (player == null) {
                this.errorPlayer(commandSender);
                return;
            }
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                ((AMA)this.plugin).getMessage(Lang.Command_Score_Error_NotInGame).send(commandSender);
                return;
            }
            int n = StringUtil.getInteger((String)commandResult.getArg(3), (int)-1);
            if (n < 0) {
                return;
            }
            arenaPlayer.addScore(-n);
            ((AMA)this.plugin).getMessage(Lang.Command_Score_Take_Done).replace("%player%", (Object)player.getName()).replace("%points%", (Object)n).send(commandSender);
        } else if (commandResult.getArg(1).equalsIgnoreCase("set")) {
            Player player = ((AMA)this.plugin).getServer().getPlayer(commandResult.getArg(2));
            if (player == null) {
                this.errorPlayer(commandSender);
                return;
            }
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                ((AMA)this.plugin).getMessage(Lang.Command_Score_Error_NotInGame).send(commandSender);
                return;
            }
            int n = StringUtil.getInteger((String)commandResult.getArg(3), (int)-1);
            if (n < 0) {
                return;
            }
            arenaPlayer.setScore(n);
            ((AMA)this.plugin).getMessage(Lang.Command_Score_Set_Done).replace("%player%", (Object)player.getName()).replace("%score%", (Object)n).send(commandSender);
        }
    }
}

