/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command;

import java.util.Arrays;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nexmedia.engine.utils.NumberUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.config.Lang;

public class SkipRoundCommand
extends AbstractCommand<AMA> {
    public SkipRoundCommand(@NotNull AMA aMA) {
        super((NexPlugin)aMA, new String[]{"skipround"}, (Permission)Perms.COMMAND_SKIPROUND);
        this.setDescription(aMA.getMessage(Lang.COMMAND_SKIP_ROUND_DESC));
        this.setUsage(aMA.getMessage(Lang.COMMAND_SKIP_ROUND_USAGE));
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 1) {
            return ((AMA)this.plugin).getArenaManager().getArenas().stream().filter(arena -> arena.getState() == GameState.INGAME && !arena.isAboutToEnd()).map(Arena::getId).toList();
        }
        if (n == 2) {
            return Arrays.asList("1", "5", "10");
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        Arena arena;
        if (commandResult.length() >= 2) {
            arena = ((AMA)this.plugin).getArenaManager().getArenaById(commandResult.getArg(1));
            if (arena == null) {
                ((AMA)this.plugin).getMessage(Lang.ARENA_ERROR_INVALID).send(commandSender);
                return;
            }
        } else if (commandSender instanceof Player) {
            Player player = (Player)commandSender;
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                ((AMA)this.plugin).getMessage(Lang.ARENA_GAME_ERROR_NOT_IN_GAME).send((CommandSender)player);
                return;
            }
            arena = arenaPlayer.getArena();
        } else {
            this.printUsage(commandSender);
            return;
        }
        if (arena.getState() != GameState.INGAME || arena.isAboutToEnd()) {
            ((AMA)this.plugin).getMessage(Lang.COMMAND_SKIP_ROUND_ERROR_NOT_IN_GAME).replace(arena.replacePlaceholders()).send(commandSender);
            return;
        }
        int n = commandResult.getInt(2, 1);
        arena.setSkipRounds(arena.getSkipRounds() + n);
        ((AMA)this.plugin).getMessage(Lang.COMMAND_SKIP_ROUND_DONE).replace("%amount%", (Object)NumberUtil.format((double)n)).replace(arena.replacePlaceholders()).send(commandSender);
    }
}

