/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Perms;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.arena.spot.ArenaSpot;
import su.nightexpress.ama.arena.spot.ArenaSpotState;
import su.nightexpress.ama.config.Lang;

public class SpotCommand
extends AbstractCommand<AMA> {
    public SpotCommand(@NotNull AMA aMA) {
        super((NexPlugin)aMA, new String[]{"spot"}, (Permission)Perms.COMMAND_SPOT);
    }

    public boolean isPlayerOnly() {
        return true;
    }

    @NotNull
    public String getUsage() {
        return ((AMA)this.plugin).getMessage(Lang.Command_Spot_Usage).getLocalized();
    }

    @NotNull
    public String getDescription() {
        return ((AMA)this.plugin).getMessage(Lang.Command_Spot_Desc).getLocalized();
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 1) {
            return Arrays.asList("state");
        }
        if (n == 2) {
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                return super.getTab(player, n, stringArray);
            }
            return arenaPlayer.getArena().getConfig().getSpotManager().getSpotsMap().values().stream().map(AbstractConfigHolder::getId).collect(Collectors.toList());
        }
        if (n == 3) {
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                return super.getTab(player, n, stringArray);
            }
            String string = stringArray[2];
            ArenaSpot arenaSpot = arenaPlayer.getArena().getConfig().getSpotManager().getSpot(string);
            if (arenaSpot == null) {
                return super.getTab(player, n, stringArray);
            }
            return new ArrayList<String>(arenaSpot.getStates().keySet());
        }
        return super.getTab(player, n, stringArray);
    }

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        if (commandResult.length() < 2) {
            this.printUsage(commandSender);
            return;
        }
        if (commandResult.getArg(1).equalsIgnoreCase("state")) {
            if (commandResult.length() != 4) {
                this.printUsage(commandSender);
                return;
            }
            Player player = (Player)commandSender;
            ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
            if (arenaPlayer == null) {
                ((AMA)this.plugin).getMessage(Lang.Command_Spot_State_Error_NotInGame).send(commandSender);
                return;
            }
            String string = commandResult.getArg(2);
            ArenaSpot arenaSpot = arenaPlayer.getArena().getConfig().getSpotManager().getSpot(string);
            if (arenaSpot == null) {
                ((AMA)this.plugin).getMessage(Lang.Command_Spot_State_Error_InvalidSpot).send(commandSender);
                return;
            }
            String string2 = commandResult.getArg(3);
            ArenaSpotState arenaSpotState = arenaSpot.getState(string2);
            if (arenaSpotState == null) {
                ((AMA)this.plugin).getMessage(Lang.Command_Spot_State_Error_InvalidState).send(commandSender);
                return;
            }
            arenaSpot.setState(arenaPlayer.getArena(), string2);
            ((AMA)this.plugin).getMessage(Lang.Command_Spot_State_Done).replace("%spot%", (Object)arenaSpot.getName()).replace("%state%", (Object)arenaSpotState.getId()).send(commandSender);
        }
    }
}

