/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.command.hologram;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.command.AbstractCommand;
import su.nexmedia.engine.api.command.CommandResult;
import su.nexmedia.engine.api.manager.AbstractConfigHolder;
import su.nexmedia.engine.api.manager.ConfigHolder;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.hologram.HologramHolder;
import su.nightexpress.ama.api.hologram.HologramType;
import su.nightexpress.ama.arena.ArenaStatsHologram;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.kit.Kit;
import su.nightexpress.ama.stats.object.StatType;

public abstract class AbstractHologramCommand
extends AbstractCommand<AMA> {
    public AbstractHologramCommand(@NotNull AMA aMA, @NotNull String[] stringArray, @NotNull Permission permission) {
        super((NexPlugin)aMA, stringArray, permission);
    }

    @NotNull
    public List<String> getTab(@NotNull Player player, int n, @NotNull String[] stringArray) {
        if (n == 2) {
            return Stream.of(HologramType.values()).filter(Predicate.not(HologramType::isDummy)).map(Enum::name).toList();
        }
        if (n > 2) {
            HologramType hologramType = StringUtil.getEnum((String)stringArray[2], HologramType.class).orElse(null);
            if (hologramType == null || hologramType.isDummy()) {
                return super.getTab(player, n, stringArray);
            }
            if (n == 3) {
                switch (hologramType) {
                    case ARENA: 
                    case ARENA_STATS: 
                    case REGION_UNLOCKED: 
                    case REGION_LOCKED: {
                        return ((AMA)this.plugin).getArenaManager().getArenaIds();
                    }
                    case KIT: {
                        return ((AMA)this.plugin).getKitManager().getKitIds();
                    }
                }
            }
            if (n == 4) {
                switch (hologramType) {
                    case REGION_UNLOCKED: 
                    case REGION_LOCKED: {
                        Arena arena = ((AMA)this.plugin).getArenaManager().getArenaById(stringArray[3]);
                        if (arena == null) {
                            return super.getTab(player, n, stringArray);
                        }
                        return arena.getConfig().getRegionManager().getRegions().stream().map(AbstractConfigHolder::getId).toList();
                    }
                    case ARENA_STATS: {
                        return CollectionsUtil.getEnumsList(StatType.class);
                    }
                }
            }
        }
        return super.getTab(player, n, stringArray);
    }

    protected abstract void perform(@NotNull CommandSender var1, @NotNull HologramType var2, @NotNull HologramHolder var3);

    public void onExecute(@NotNull CommandSender commandSender, @NotNull CommandResult commandResult) {
        Object object;
        Arena arena;
        if (commandResult.length() < 4) {
            this.printUsage(commandSender);
            return;
        }
        HologramType hologramType = StringUtil.getEnum((String)commandResult.getArg(2), HologramType.class).orElse(null);
        if (hologramType == null) {
            this.printUsage(commandSender);
            return;
        }
        Kit kit = switch (hologramType) {
            default -> throw new IncompatibleClassChangeError();
            case HologramType.ARENA -> {
                arena = ((AMA)this.plugin).getArenaManager().getArenaById(commandResult.getArg(3));
                if (arena == null) {
                    yield null;
                }
                yield arena.getConfig();
            }
            case HologramType.DEFAULT -> null;
            case HologramType.REGION_UNLOCKED, HologramType.REGION_LOCKED -> {
                if (commandResult.length() < 5) {
                    yield null;
                }
                arena = ((AMA)this.plugin).getArenaManager().getArenaById(commandResult.getArg(3));
                if (arena == null) {
                    yield null;
                }
                yield arena.getConfig().getRegionManager().getRegion(commandResult.getArg(4));
            }
            case HologramType.KIT -> ((AMA)this.plugin).getKitManager().getKitById(commandResult.getArg(3));
            case HologramType.ARENA_STATS -> {
                if (commandResult.length() < 5) {
                    yield null;
                }
                arena = ((AMA)this.plugin).getArenaManager().getArenaById(commandResult.getArg(3));
                if (arena == null) {
                    yield null;
                }
                object = StringUtil.getEnum((String)commandResult.getArg(4), StatType.class).orElse(null);
                if (object == null) {
                    yield null;
                }
                yield arena.getConfig().getStatsHologram((StatType)((Object)object));
            }
        };
        if (kit == null) {
            ((AMA)this.plugin).getMessage(Lang.COMMAND_HOLOGRAM_ERROR).send(commandSender);
            return;
        }
        this.perform(commandSender, hologramType, kit);
        if (kit instanceof ConfigHolder) {
            arena = kit;
            arena.save();
        } else if (kit instanceof ArenaStatsHologram) {
            object = (ArenaStatsHologram)((Object)kit);
            object.getArenaConfig().save();
        }
    }
}

