/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.currency.impl;

import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.placeholder.PlaceholderMap;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.currency.Currency;
import su.nightexpress.ama.api.currency.CurrencyHandler;

public class ConfigCurrency
implements Currency {
    private String name;
    private String format;
    private final AMA plugin;
    private final String id;
    private final CurrencyHandler handler;
    private final PlaceholderMap placeholderMap;

    public ConfigCurrency(@NotNull AMA aMA, @NotNull String string, @NotNull CurrencyHandler currencyHandler) {
        this.plugin = aMA;
        this.id = StringUtil.lowerCaseUnderscore((String)string);
        this.handler = currencyHandler;
        this.placeholderMap = new PlaceholderMap().add("%currency_id%", this::getId).add("%currency_name%", this::getName);
    }

    public boolean load() {
        JYML jYML = this.plugin.getConfig();
        String string = "Currency." + this.getId();
        jYML.addMissing(string + ".Enabled", (Object)true);
        jYML.addMissing(string + ".Name", (Object)StringUtil.capitalizeUnderscored((String)this.getId()));
        jYML.addMissing(string + ".Format", (Object)"%amount% %currency_name%");
        jYML.saveChanges();
        if (!jYML.getBoolean(string + ".Enabled")) {
            return false;
        }
        this.name = Colorizer.apply((String)jYML.getString(string + ".Name", StringUtil.capitalizeUnderscored((String)this.getId())));
        this.format = Colorizer.apply((String)jYML.getString(string + ".Format", "%amount% %currency_name%"));
        return true;
    }

    @NotNull
    public PlaceholderMap getPlaceholders() {
        return this.placeholderMap;
    }

    @Override
    @NotNull
    public CurrencyHandler getHandler() {
        return this.handler;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getFormat() {
        return this.format;
    }
}

