/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.hook.external;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nexmedia.engine.utils.TimeUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.api.ArenaAPI;
import su.nightexpress.ama.api.type.GameState;
import su.nightexpress.ama.api.type.PlayerType;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.stats.object.StatType;

public class PlaceholderHook {
    private static AMAExpansion expansion;

    public static void setup() {
        if (expansion == null) {
            expansion = new AMAExpansion();
            expansion.register();
        }
    }

    public void shutdown() {
        if (expansion != null) {
            expansion.unregister();
            expansion = null;
        }
    }

    static class AMAExpansion
    extends PlaceholderExpansion {
        AMAExpansion() {
        }

        @NotNull
        public String getAuthor() {
            return (String)ArenaAPI.PLUGIN.getDescription().getAuthors().get(0);
        }

        @NotNull
        public String getIdentifier() {
            return "ama";
        }

        @NotNull
        public String getVersion() {
            return ArenaAPI.PLUGIN.getDescription().getVersion();
        }

        public boolean persist() {
            return true;
        }

        public String onPlaceholderRequest(Player player, String string) {
            AMA aMA = ArenaAPI.PLUGIN;
            if (string.startsWith("stats_")) {
                String string2 = string.replace("stats_", "");
                StatType statType = StringUtil.getEnum((String)string2, StatType.class).orElse(null);
                if (statType == null) {
                    return "NaN";
                }
                ArenaUser arenaUser = (ArenaUser)aMA.getUserManager().getUserData(player);
                return String.valueOf(arenaUser.getStats(statType));
            }
            if (string.equalsIgnoreCase("coins")) {
                ArenaUser arenaUser = (ArenaUser)aMA.getUserManager().getUserData(player);
                return NumberUtil.format((double)arenaUser.getCoins());
            }
            if (string.equalsIgnoreCase("coins_raw")) {
                ArenaUser arenaUser = (ArenaUser)aMA.getUserManager().getUserData(player);
                return String.valueOf(arenaUser.getCoins());
            }
            if (string.startsWith("arena_")) {
                Object object;
                String string3;
                String string4 = string3 = string.substring("arena_".length());
                Arena arena = null;
                ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
                int n = string3.indexOf("_");
                if (n >= 0) {
                    object = string3.substring(0, n);
                    arena = aMA.getArenaManager().getArenaById((String)object);
                }
                if (arena != null) {
                    string4 = string3.substring(n + 1);
                } else if (arenaPlayer != null) {
                    arena = arenaPlayer.getArena();
                } else {
                    return "-";
                }
                if (string4.equalsIgnoreCase("mobs")) {
                    return String.valueOf(arena.getMobs().getEnemies().size());
                }
                if (string4.equalsIgnoreCase("name")) {
                    return arena.getConfig().getName();
                }
                if (string4.equalsIgnoreCase("timeleft")) {
                    object = DateTimeFormatter.ofPattern("HH:mm:ss");
                    return TimeUtil.getLocalTimeOf((long)arena.getGameTimeleft()).format((DateTimeFormatter)object);
                }
                if (string4.equalsIgnoreCase("wave")) {
                    return String.valueOf(arena.getRoundNumber());
                }
                if (string4.equalsIgnoreCase("players")) {
                    return String.valueOf(arena.getPlayers(GameState.INGAME, PlayerType.REAL).size());
                }
                if (string4.equalsIgnoreCase("next_wave")) {
                    return String.valueOf(arena.getNextRoundCountdown());
                }
                if (string4.equalsIgnoreCase("score")) {
                    return String.valueOf(arenaPlayer != null ? arenaPlayer.getScore() : arena.getGameScore());
                }
                if (arenaPlayer == null) {
                    return "-";
                }
                if (string4.equalsIgnoreCase("streak_length")) {
                    return String.valueOf(arenaPlayer.getKillStreak());
                }
                if (string4.equalsIgnoreCase("streak_decay")) {
                    object = DateTimeFormatter.ofPattern("ss");
                    LocalTime localTime = TimeUtil.getLocalTimeOf((long)arenaPlayer.getKillStreakDecay());
                    return localTime.format((DateTimeFormatter)object);
                }
                if (string4.equalsIgnoreCase("kills")) {
                    return String.valueOf(arenaPlayer.getStats(StatType.MOB_KILLS));
                }
            }
            return null;
        }
    }
}

