/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.hook.mob;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nightexpress.ama.api.ArenaAPI;
import su.nightexpress.ama.hook.mob.MobProvider;

public class PluginMobProvider {
    private static final Map<String, MobProvider> PROVIDERS = new HashMap<String, MobProvider>();

    public static void registerProvider(@NotNull MobProvider mobProvider) {
        if (!PROVIDERS.containsKey(mobProvider.getName().toLowerCase())) {
            PROVIDERS.put(mobProvider.getName().toLowerCase(), mobProvider);
            ArenaAPI.PLUGIN.info("Registered mob provider: " + mobProvider.getName());
        }
    }

    @Nullable
    public static MobProvider getProvider(@NotNull String string) {
        return PROVIDERS.get(string.toLowerCase());
    }

    @NotNull
    public static Map<String, MobProvider> getProvidersMap() {
        return PROVIDERS;
    }

    @NotNull
    public static Collection<MobProvider> getProviders() {
        return PluginMobProvider.getProvidersMap().values();
    }
}

