/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.hook.mob.impl;

import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfig;
import com.magmaguy.elitemobs.config.custombosses.CustomBossesConfigFields;
import com.magmaguy.elitemobs.config.mobproperties.MobPropertiesConfig;
import com.magmaguy.elitemobs.config.mobproperties.MobPropertiesConfigFields;
import com.magmaguy.elitemobs.mobconstructor.EliteEntity;
import com.magmaguy.elitemobs.mobconstructor.custombosses.CustomBossEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.hook.mob.MobProvider;

public class EliteMobsProvider
implements MobProvider {
    @Override
    @NotNull
    public String getName() {
        return "EliteMobs";
    }

    @Override
    @NotNull
    public Optional<LivingEntity> spawn(@NotNull Arena arena, @NotNull String string, @NotNull Location location, int n) {
        CustomBossesConfigFields customBossesConfigFields = CustomBossesConfig.getCustomBoss((String)string);
        if (customBossesConfigFields != null) {
            CustomBossEntity customBossEntity = new CustomBossEntity(customBossesConfigFields);
            customBossEntity.setSpawnLocation(location);
            customBossEntity.setLevel(n);
            customBossEntity.spawn(false);
            return Optional.of(customBossEntity.getLivingEntity());
        }
        EntityType entityType = StringUtil.getEnum((String)string, EntityType.class).orElse(null);
        if (entityType == null || !entityType.isAlive()) {
            return Optional.empty();
        }
        MobPropertiesConfigFields mobPropertiesConfigFields = (MobPropertiesConfigFields)MobPropertiesConfig.getMobProperties().get(entityType);
        if (mobPropertiesConfigFields == null || !mobPropertiesConfigFields.isEnabled()) {
            return Optional.empty();
        }
        World world = location.getWorld();
        if (world == null) {
            return Optional.empty();
        }
        LivingEntity livingEntity = (LivingEntity)world.spawnEntity(location, entityType);
        EliteEntity eliteEntity = new EliteEntity(livingEntity, n, CreatureSpawnEvent.SpawnReason.CUSTOM);
        return Optional.of(eliteEntity.getLivingEntity());
    }

    @Override
    @NotNull
    public List<String> getMobNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(MobPropertiesConfig.getMobProperties().values().stream().filter(MobPropertiesConfigFields::isEnabled).map(MobPropertiesConfigFields::getEntityType).map(Enum::name).map(String::toLowerCase).toList());
        arrayList.addAll(CustomBossesConfig.getCustomBosses().keySet().stream().toList());
        return arrayList;
    }
}

