/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.kit.menu;

import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.MenuItemType;
import su.nexmedia.engine.api.menu.click.ClickHandler;
import su.nexmedia.engine.api.menu.impl.ConfigMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.lang.LangManager;
import su.nexmedia.engine.utils.Colorizer;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.arena.impl.ArenaPlayer;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.kit.Kit;

public abstract class AbstractKitListMenu
extends ConfigMenu<AMA>
implements AutoPaged<Kit> {
    private final String objectName;
    private final List<String> objectLore;
    private final int[] objectSlots;

    public AbstractKitListMenu(@NotNull AMA aMA, @NotNull JYML jYML) {
        super((NexPlugin)aMA, jYML);
        this.objectName = Colorizer.apply((String)jYML.getString("Object.Name", "%kit_name%"));
        this.objectLore = Colorizer.apply((List)jYML.getStringList("Object.Lore"));
        this.objectSlots = jYML.getIntArray("Object.Slots");
        this.registerHandler(MenuItemType.class).addClick((Enum)MenuItemType.CLOSE, (menuViewer, inventoryClickEvent) -> aMA.runTask(bukkitTask -> menuViewer.getPlayer().closeInventory())).addClick((Enum)MenuItemType.PAGE_NEXT, ClickHandler.forNextPage((Menu)this)).addClick((Enum)MenuItemType.PAGE_PREVIOUS, ClickHandler.forPreviousPage((Menu)this));
        this.load();
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((AbstractKitListMenu)this).addItem(arg_0));
    }

    @NotNull
    public abstract Predicate<Kit> getFilter(@Nullable ArenaUser var1);

    public int[] getObjectSlots() {
        return this.objectSlots;
    }

    @NotNull
    public List<Kit> getObjects(@NotNull Player player) {
        ArenaUser arenaUser = (ArenaUser)((AMA)this.plugin).getUserManager().getUserData(player);
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return Collections.emptyList();
        }
        Predicate<Kit> predicate = this.getFilter(arenaUser);
        Predicate<Kit> predicate2 = kit -> arenaPlayer.getArena().getConfig().getGameplayManager().isKitAllowed(kit.getId());
        return ((AMA)this.plugin).getKitManager().getKits().stream().filter(kit -> predicate.and(predicate2).test((Kit)kit)).toList();
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull Kit kit) {
        ItemStack itemStack = new ItemStack(kit.getIcon());
        ItemMeta itemMeta = itemStack.getItemMeta();
        if (itemMeta == null) {
            return itemStack;
        }
        ArenaPlayer arenaPlayer = ArenaPlayer.getPlayer(player);
        if (arenaPlayer == null) {
            return itemStack;
        }
        itemMeta.setDisplayName(this.objectName);
        itemMeta.setLore(this.objectLore);
        itemStack.setItemMeta(itemMeta);
        ItemUtil.replace((ItemStack)itemStack, string -> (String)kit.replacePlaceholders().apply(string.replace("%kit_is_available%", LangManager.getBoolean((boolean)kit.isAvailable(arenaPlayer, false)))));
        return itemStack;
    }
}

