/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.kit.menu;

import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.MenuItemType;
import su.nexmedia.engine.api.menu.impl.ConfigMenu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.data.impl.ArenaUser;
import su.nightexpress.ama.kit.Kit;

public class KitPreviewMenu
extends ConfigMenu<AMA> {
    private final Kit kit;
    public static int[] itemSlots;
    public static int[] armorSlots;

    public KitPreviewMenu(@NotNull Kit kit) {
        super((NexPlugin)((AMA)kit.plugin()), ((AMA)kit.plugin()).getKitManager().getConfigPreview());
        this.kit = kit;
        if (itemSlots == null || armorSlots == null) {
            itemSlots = this.cfg.getIntArray("Item_Slots");
            armorSlots = this.cfg.getIntArray("Armor_Slots");
        }
        this.registerHandler(MenuItemType.class).addClick((Enum)MenuItemType.CLOSE, (menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).runTask(bukkitTask -> menuViewer.getPlayer().closeInventory())).addClick((Enum)MenuItemType.RETURN, (menuViewer, inventoryClickEvent) -> {
            Player player = menuViewer.getPlayer();
            ArenaUser arenaUser = (ArenaUser)((AMA)this.plugin).getUserManager().getUserData(player);
            if (arenaUser.hasKit(kit)) {
                ((AMA)this.plugin).getKitManager().getSelectMenu().openNextTick(player, 1);
            } else {
                ((AMA)this.plugin).getKitManager().getShopMenu().openNextTick(player, 1);
            }
        });
        this.load();
    }

    public void onReady(@NotNull MenuViewer menuViewer, @NotNull Inventory inventory) {
        ItemStack itemStack;
        int n;
        ItemStack[] itemStackArray = this.kit.getItems();
        ItemStack[] itemStackArray2 = this.kit.getArmor();
        for (n = 0; n < itemSlots.length && n < itemStackArray.length; ++n) {
            itemStack = itemStackArray[n];
            if (itemStack == null) continue;
            inventory.setItem(itemSlots[n], itemStack);
        }
        for (n = 0; n < armorSlots.length && n < itemStackArray2.length; ++n) {
            itemStack = itemStackArray2[n];
            if (itemStack == null) continue;
            inventory.setItem(armorSlots[n], itemStack);
        }
        Player player = menuViewer.getPlayer();
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
    }
}

