/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.persistence.PersistentDataHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.config.JYML;
import su.nexmedia.engine.api.manager.AbstractManager;
import su.nexmedia.engine.utils.NumberUtil;
import su.nexmedia.engine.utils.PDCUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.Keys;
import su.nightexpress.ama.api.type.MobFaction;
import su.nightexpress.ama.arena.impl.Arena;
import su.nightexpress.ama.arena.util.ArenaUtils;
import su.nightexpress.ama.hologram.HologramManager;
import su.nightexpress.ama.hook.mob.MobProvider;
import su.nightexpress.ama.hook.mob.impl.InternalMobProvider;
import su.nightexpress.ama.mob.config.MobConfig;
import su.nightexpress.ama.mob.config.MobsConfig;
import su.nightexpress.ama.mob.kill.MobKillReward;
import su.nightexpress.ama.mob.kill.MobKillStreak;

public class MobManager
extends AbstractManager<AMA> {
    public static final String DIR_MOBS = "/mobs/";
    private Map<String, MobConfig> mobConfigMap;

    public MobManager(@NotNull AMA aMA) {
        super((NexPlugin)aMA);
        DirMctLeUksmXxYhyQckpM3wxEWJVKy.1EjfNFBbuR(Class.forName("DiTectLeaSsnRcxog9aAnPQPPPboQo"));
    }

    public void onLoad() {
        this.mobConfigMap = new HashMap<String, MobConfig>();
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "\u001c=A\u00076\u0017_'\u000b\u0006)A\f=\b[,\nA+\u0000\u00075\u0006Ul,\u0000&\t\u00004\"S,\u000e\b-\u001d", (Object)"\n0\u001b\u001b2\fF\u0010\n\u001c'\u001a\u001b0\nA", "G\u0004\u0005\b%\u000e\u001d.\u000e\u0001/@:'\u001d[,\bTa9", 75, -1.4668173734242274, "MokPSMxIFA0WrVMncH4TFxYmmeB2llUtizKC5xa", DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "\u0001\u0007\\\u0007&\u0015Z6\u0017\n\u0002\u0000\f<\u0001\u001c#\u001f\u0013\\3$\u000e", (Object)"\u0015\u0017\u0006* \u001cT+\u0015?\u0013\u001c\b(\u0017@", "Z[>\u001a:]\\'\n\u001f\u0017\u0016\u0000.]W,\u0015\u001b\u001c\u0017F,\u001d\\$\u001b\u0015]1\u0006!\u0014[%?\u0013\u001c\u0013\u000e*\u0000\t", 75, 9.118116535902175, "trhLO1eRB2KEQeqT1rLPN55VBTmcWSGuozbI", (Object)((AMA)this.plugin)), DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "\u0013$\u0003\f\u0013#~'6\u0004>9;\u0013/]%n6\f99!\u0007b\u001258\u001c8", (Object)"\u0003\u0003\r\u001e\u001faC(-\u0011\u001f0#7\u001cK%f?|", "\u007f\u0001=\b\u00066\u001d.69*x:\u0004%[,0l\u0001=\b\u00066\u001d.69*x:\u0004%[,0ld\u001b\u0003\u0011!Sm;6#0F##@+90v", 76, -2.52076521612125, "eWQQpvhaX6voRUZiZMNpI105V8wnNcMdic9b29lD7", "D\u0019\u0004\u0016\u0018[", "oxMd2t0M526bLF91KkioTtd0Kuop9q0crdcHAuxPx9ED"));
        Iterator iterator = DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "\u0015\u0014H\u0007<\u001e_'\u0002\u000f\u0000H\f7\u0001[,\u0003H\u0000\u0016\u0000w\u0005],\u0000\u000f\u0006H#\u0000+~", (Object)"\n\u000e\u0007\r\u0018\n^", "N-\f\b/\u0007\u001d.\u0007\b\u0006I:-\u0014[,\u0001];O%3\u0007D#I\u0013\u0015\u000f\u0005v*[1\u0012]", 76, -0.2782424f, "dfCNY6jSrPb2ZTXwvaeLskWqMROpcamo80bOl1hgL0wUxm5eg54jUA", (File)DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "9?d\u0007$-Z6/2:8\f>9\u001c#'+d\u000b$\f", (Object)"-/>-,>S\u0004%&./\u001b", "bc\u0006\u0003,<Sm#%e\f\u0000!/\t", 77, -0.8435449f, "bJELMQai3F0nJOYaMJ9XYI2grq1gwJdD7gSR7", (Object)((AMA)this.plugin)) + DIR_MOBS, false).iterator();
        while (iterator.hasNext()) {
            JYML jYML = (JYML)iterator.next();
            MobConfig mobConfig = new MobConfig((AMA)this.plugin, jYML);
            if (DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "\u001f\u0016B\u00073\u000bZ6\t\u0014\u0013\u001e\f)\u001f\u001c#\u0001\rM\u0001\u00068BQ-\u0002\n\n\u000bG\u0017\u0003P\u0001\u0003\u0002\u0005\u0005\u000e", (Object)"\u0000\f\r\r", "DJ6", 75, -10.170588554442546, "xlRsZTWoHTeLcZLhDcZ0fmgNbf8ByB1JYAZxqVnf2jz2JFFi", (Object)mobConfig) != false) {
                this.mobConfigMap.put((String)DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", ">\u0003\"\bH8S,3z1 \u001b\u000f:U", (Object)" \r\u0018\u0006\u00111@\u00015'\u0007", "|K\u0018\u0003\u0007\"Sm85\f3F5 @+:3Y", 77, -0.6031538f, "TTiyfIqsZxYnXvJCUbgwcGCRMrEBC4ekxIFSWpYMimaFjGwMujM1XL", DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "J=\u0017\u0007\\^Z6\\A8K\fFJ\u001c#TXfT\u0006W\u0017Q-W_!^GxVP\u0001VW.P\u000e", (Object)"^-M Q", "\u0011au\u0003TOSmUX&^FfM@+W^s", 75, -2090975975, "A9DC5HPiFmBcmIvYKH7Jnwgbusy610fmEIZNIq0B", (Object)mobConfig)), mobConfig);
                continue;
            }
            DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "5\u0019h\u0007\u0004!Z6#>\u001c4\f\u001e5\u001c#+'B\u0007$,", (Object)"1\r4\u0007", "n ,\b\u001b'\u001d.'(\u000bi:\u00194[,!}E\u0010", 75, 0.76015264f, "QFwfmJVbmUI3uEiPUllQelZ5CiZvw5CxIeab8luGK6OiLYSQSrL", (Object)((AMA)this.plugin), "AMA mob not loaded: '" + (String)DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "$\u000b8\bh']l\b'\u0006+", (Object)")\u000f:''#W", "fC\u0002\u0003'8Sm\"/\u0004)F\u0015:@+ )Q", 75, 0.47652680298799255, "uNY8Fx5VfShfSFJlLjELaP1e2nAyWCe5qsvecUQ6smHT", DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "2%o\u0007\u00179_'%(1o\f\u001c&[,$o11\u0000\\\"],'(7o#+\f~", (Object)"&55/\u001b-W", "iy\r\u0003\u00137Sm(.\u007f\u0007\u0000\u001e$\t", 77, -1.9076972089309012, "xAuerIwjuThros3B8Pk2EBDJr3O70MyVPDL35WDibo5E", jYML)) + "'!");
        }
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "E/\u0018\u0007]QZ6SN*D\fGE\u001c#[Wtw$u", (Object)"_4P\u0006", "\u001e\u0016\\\bBW\u001d.WX=\u0019:@D[,Q\rs`", 77, -350423429013320247L, "J65A4in1au2RbKh4gZ626zWNy3a71XYtHWeSccFNoN8rvVkuGh2cuhs", (Object)((AMA)this.plugin), "Mobs Loaded: " + this.mobConfigMap.size());
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "&\"{\u0007]-_'1<6{\fV2[,0{6%\u0000\u00166],3<0{#a\u0018~", (Object)"<9<\u001dQ4^+/0\u0018%\u001dQ:\\1", "}\u001b?\bN4\u001d.4;0z&Z?W!!n~\u0003", 75, -0.305581381884712, "SUaI8we8zOZ5TFYsqWHTyeAmUDnmYreb2vQX9", DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "08m\u0007\u000b$Z6&;=1\f\u00110\u001c#.\"c\u0002$#", (Object)"$(7*\r-T+$", "kd\u000f\u001a\u0017l\\';.('\u0000\u0003lW,$*#&F\u00033[m ,#%\u0000\u0005lx\u001b\u000e\u000fv", 77, -0.1724680287538382, "LCf8b7uKV0dVJ3MR2MySFokiLUAXN2BpvgZoo3AUMlNI24a0l", (Object)((AMA)this.plugin)), MobsConfig.class);
        DiTectLeaSsnRcxog9aAnPQPPPboQo.OSwuk7TWcVJYHYB("dIRecCle1ks", "D\u001d\u0019\u00078PZ6RO\u0018E\f\"D\u001c#ZVF_\u0006>\\\u001c/XUFg\u0005$P[,zX\ng\u001b>A[&RE", (Object)"E\rP\u0000\"CW0gE\u0007A\u00005R@", "\u001f$D\u001c~Y[%_C\rO\u0019#RA1\u0018V\u0005VF9X])\u0018Z\u0007UF\u001cXP\u0012EX\u001e^\r4E\tka", 76, -874245583, "F7mEQIrDQ2nCvbVy3hmgbiANokfKvoGU2h3hPPpRYD13Z9iZoUppgcE", new InternalMobProvider((AMA)this.plugin));
    }

    public void onShutdown() {
        this.mobConfigMap.values().forEach(MobConfig::clear);
        this.mobConfigMap.clear();
    }

    public boolean createMobConfig(@NotNull String string) {
        if (this.getMobConfigById(string = StringUtil.lowerCaseUnderscore((String)string)) != null) {
            return false;
        }
        JYML jYML = new JYML(((AMA)this.plugin).getDataFolder() + DIR_MOBS, string + ".yml");
        MobConfig mobConfig = new MobConfig((AMA)this.plugin, jYML);
        mobConfig.setEntityType(EntityType.ZOMBIE);
        mobConfig.setName(StringUtil.capitalizeUnderscored((String)mobConfig.getEntityType().name().toLowerCase()));
        mobConfig.setNameVisible(true);
        mobConfig.setLevelMin(1);
        mobConfig.setLevelMax(10);
        mobConfig.setBarEnabled(false);
        mobConfig.setBarStyle(BarStyle.SEGMENTED_12);
        mobConfig.setBarColor(BarColor.RED);
        mobConfig.getAttributes().put(Attribute.GENERIC_MAX_HEALTH, new double[]{20.0, 1.0});
        mobConfig.save();
        mobConfig.load();
        this.getMobConfigMap().put(mobConfig.getId(), mobConfig);
        return true;
    }

    @NotNull
    public List<String> getMobIds() {
        return new ArrayList<String>(this.mobConfigMap.keySet());
    }

    @NotNull
    public Map<String, MobConfig> getMobConfigMap() {
        return this.mobConfigMap;
    }

    @NotNull
    public Collection<MobConfig> getMobConfigs() {
        return this.mobConfigMap.values();
    }

    @Nullable
    public MobConfig getMobConfigById(@NotNull String string) {
        return this.mobConfigMap.get(string.toLowerCase());
    }

    @Nullable
    public LivingEntity spawnMob(@NotNull Arena arena, @NotNull MobFaction mobFaction, @NotNull String string, @NotNull Location location, int n) {
        MobConfig mobConfig = this.getMobConfigById(string);
        if (mobConfig == null) {
            return null;
        }
        EntityType entityType = mobConfig.getEntityType();
        LivingEntity livingEntity = ((AMA)this.plugin).getArenaNMS().spawnMob(arena, mobFaction, entityType, location);
        if (livingEntity == null) {
            return null;
        }
        mobConfig.applySettings(livingEntity, n);
        mobConfig.applyAttributes(livingEntity, n);
        if (mobConfig.isBarEnabled()) {
            ArenaUtils.addMobBossBar(arena, livingEntity, mobConfig.createOrUpdateBar(livingEntity));
        }
        this.setMobConfig(livingEntity, mobConfig);
        return livingEntity;
    }

    public static void setArena(@NotNull LivingEntity livingEntity, @NotNull Arena arena) {
        PDCUtil.set((PersistentDataHolder)livingEntity, (NamespacedKey)Keys.ENTITY_ARENA_ID, (String)arena.getId());
    }

    public static void setProvider(@NotNull LivingEntity livingEntity, @NotNull MobProvider mobProvider, @NotNull String string) {
        PDCUtil.set((PersistentDataHolder)livingEntity, (NamespacedKey)Keys.ENTITY_MOB_ID, (String)(mobProvider.getName() + ":" + string).toLowerCase());
    }

    private void setMobConfig(@NotNull LivingEntity livingEntity, @NotNull MobConfig mobConfig) {
        PDCUtil.set((PersistentDataHolder)livingEntity, (NamespacedKey)Keys.ENTITY_MOB_ID, (String)mobConfig.getId());
    }

    public static void setLevel(@NotNull LivingEntity livingEntity, int n) {
        PDCUtil.set((PersistentDataHolder)livingEntity, (NamespacedKey)Keys.ENTITY_MOB_LEVEL, (int)n);
    }

    @NotNull
    public static String getMobIdProvider(@NotNull LivingEntity livingEntity) {
        return PDCUtil.getString((PersistentDataHolder)livingEntity, (NamespacedKey)Keys.ENTITY_MOB_ID).orElse("");
    }

    @NotNull
    public static String getMobId(@NotNull LivingEntity livingEntity) {
        String[] stringArray = MobManager.getMobIdProvider(livingEntity).split(":");
        return stringArray.length == 2 ? stringArray[1] : "";
    }

    @NotNull
    public static String getMobProvider(@NotNull LivingEntity livingEntity) {
        String[] stringArray = MobManager.getMobIdProvider(livingEntity).split(":");
        return stringArray[0];
    }

    @Nullable
    public static MobKillReward getMobKillReward(@NotNull LivingEntity livingEntity) {
        if (!((Boolean)MobsConfig.KILL_REWARD_ENABLED.get()).booleanValue()) {
            return null;
        }
        Map map = (Map)MobsConfig.KILL_REWARD_VALUES.get();
        return map.getOrDefault(MobManager.getMobIdProvider(livingEntity), (MobKillReward)map.get("default"));
    }

    @Nullable
    public static MobKillStreak getMobKillStreak(int n) {
        if (!((Boolean)MobsConfig.KILL_STREAK_ENABLED.get()).booleanValue()) {
            return null;
        }
        return (MobKillStreak)((Map)MobsConfig.KILL_STREAK_TABLE.get()).get(n);
    }

    public void displayMobKillReward(@NotNull LivingEntity livingEntity, @NotNull MobKillReward mobKillReward) {
        if (!((Boolean)MobsConfig.KILL_REWARD_HOLOGRAM_ENABLED.get()).booleanValue()) {
            return;
        }
        HologramManager hologramManager = ((AMA)this.plugin).getHologramManager();
        if (hologramManager == null) {
            return;
        }
        int n = (Integer)MobsConfig.KILL_REWARD_HOLOGRAM_LIFETIME.get();
        if (n <= 0) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        mobKillReward.getPayment().forEach((currency, d) -> arrayList.add(((String)MobsConfig.KILL_REWARD_HOLOGRAM_FORMAT_PAYMENT.get()).replace("%amount%", currency.format((double)d))));
        if (mobKillReward.getScore() > 0) {
            arrayList.add(((String)MobsConfig.KILL_REWARD_HOLOGRAM_FORMAT_SCORE.get()).replace("%amount%", NumberUtil.format((double)mobKillReward.getScore())));
        }
        hologramManager.create(livingEntity.getEyeLocation(), arrayList, n);
    }

    public boolean isArenaEntity(@NotNull Entity entity) {
        return this.getEntityArena(entity) != null;
    }

    @Nullable
    public Arena getEntityArena(@NotNull Entity entity) {
        String string = PDCUtil.getString((PersistentDataHolder)entity, (NamespacedKey)Keys.ENTITY_ARENA_ID).orElse(null);
        return string == null ? null : ((AMA)this.plugin).getArenaManager().getArenaById(string);
    }

    @Nullable
    public MobConfig getEntityMobConfig(@NotNull LivingEntity livingEntity) {
        return this.getMobConfigById(MobManager.getMobId(livingEntity));
    }

    public static int getEntityLevel(@NotNull LivingEntity livingEntity) {
        return PDCUtil.getInt((PersistentDataHolder)livingEntity, (NamespacedKey)Keys.ENTITY_MOB_LEVEL).orElse(0);
    }
}

