/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.editor;

import java.util.HashMap;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.Menu;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.CollectionsUtil;
import su.nexmedia.engine.utils.ItemUtil;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;
import su.nightexpress.ama.mob.config.MobConfig;
import su.nightexpress.ama.mob.editor.MobStylesEditor;

public class MobMainEditor
extends EditorMenu<AMA, MobConfig> {
    private MobStylesEditor mobStylesEditor;

    public MobMainEditor(@NotNull MobConfig mobConfig) {
        super((NexPlugin)((AMA)mobConfig.plugin()), (Object)mobConfig, "Arena Mob Editor", 45);
        this.addReturn(new int[]{40}).setClick((menuViewer, inventoryClickEvent) -> ((AMA)this.plugin).getEditor().getMobEditor().openNextTick(menuViewer, 1));
        this.addItem(Material.NAME_TAG, EditorLocales.MOB_NAME, new int[]{10}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isRightClick()) {
                mobConfig.setNameVisible(!mobConfig.isNameVisible());
                this.save(menuViewer);
                return;
            }
            this.handleInput(menuViewer, Lang.EDITOR_GENERIC_ENTER_NAME, inputWrapper -> {
                mobConfig.setName(inputWrapper.getText());
                mobConfig.save();
                return true;
            });
        });
        this.addItem(Material.CREEPER_SPAWN_EGG, EditorLocales.MOB_ENTITY_TYPE, new int[]{11}).setClick((menuViewer, inventoryClickEvent) -> {
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), Stream.of(EntityType.values()).filter(EntityType::isSpawnable).filter(EntityType::isAlive).map(Enum::name).toList(), (boolean)true);
            this.handleInput(menuViewer, Lang.Editor_Mob_Enter_Type, inputWrapper -> {
                EntityType entityType = StringUtil.getEnum((String)inputWrapper.getTextRaw(), EntityType.class).orElse(null);
                if (entityType == null || !entityType.isSpawnable() || !entityType.isAlive()) {
                    return false;
                }
                mobConfig.setEntityType(entityType);
                mobConfig.save();
                return true;
            });
        });
        this.addItem(Material.EXPERIENCE_BOTTLE, EditorLocales.MOB_LEVEL, new int[]{12}).setClick((menuViewer, inventoryClickEvent) -> this.handleInput(menuViewer, Lang.Editor_Mob_Enter_Level, inputWrapper -> {
            if (inventoryClickEvent.isLeftClick()) {
                mobConfig.setLevelMin(inputWrapper.asInt(1));
            } else {
                mobConfig.setLevelMax(inputWrapper.asInt(1));
            }
            mobConfig.save();
            return true;
        }));
        this.addItem(Material.MAP, EditorLocales.MOB_BOSSBAR, new int[]{13}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick()) {
                if (inventoryClickEvent.isLeftClick()) {
                    mobConfig.setBarColor((BarColor)CollectionsUtil.next((Enum)mobConfig.getBarColor()));
                } else if (inventoryClickEvent.isRightClick()) {
                    mobConfig.setBarStyle((BarStyle)CollectionsUtil.next((Enum)mobConfig.getBarStyle()));
                }
            } else if (inventoryClickEvent.isLeftClick()) {
                mobConfig.setBarEnabled(!mobConfig.isBarEnabled());
            } else if (inventoryClickEvent.isRightClick()) {
                return;
            }
            this.save(menuViewer);
        });
        this.addItem(Material.APPLE, EditorLocales.MOB_ATTRIBUTES, new int[]{14}).setClick((menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isShiftClick()) {
                if (inventoryClickEvent.isLeftClick()) {
                    mobConfig.getAttributes().clear();
                    this.save(menuViewer);
                }
                return;
            }
            EditorManager.suggestValues((Player)menuViewer.getPlayer(), Stream.of(Attribute.values()).map(Enum::name).toList(), (boolean)false);
            this.handleInput(menuViewer, Lang.Editor_Mob_Enter_Attribute, inputWrapper -> {
                String[] stringArray = inputWrapper.getTextRaw().split(" ");
                if (stringArray.length != 2) {
                    return false;
                }
                Attribute attribute2 = StringUtil.getEnum((String)stringArray[0], Attribute.class).orElse(null);
                if (attribute2 == null) {
                    return false;
                }
                double d = StringUtil.getDouble((String)stringArray[1], (double)0.0);
                double[] dArray = mobConfig.getAttributes().computeIfAbsent(attribute2, attribute -> new double[2]);
                int n = inventoryClickEvent.isLeftClick() ? 0 : 1;
                dArray[n] = d;
                mobConfig.getAttributes().put(attribute2, dArray);
                mobConfig.save();
                return true;
            });
        });
        this.addItem(Material.ARMOR_STAND, EditorLocales.MOB_EQUIPMENT, new int[]{15}).setClick((menuViewer, inventoryClickEvent) -> new EquipmentEditor(mobConfig).openNextTick(menuViewer, 1));
        this.addItem(Material.ORANGE_DYE, EditorLocales.MOB_STYLES, new int[]{16}).setClick((menuViewer, inventoryClickEvent) -> this.getEditorMobStyles().openNextTick(menuViewer, 1));
        this.getItems().forEach(menuItem -> menuItem.getOptions().addDisplayModifier((menuViewer, itemStack) -> ItemUtil.replace((ItemStack)itemStack, (UnaryOperator)mobConfig.replacePlaceholders())));
    }

    private void save(@NotNull MenuViewer menuViewer) {
        ((MobConfig)((Object)this.object)).save();
        this.openNextTick(menuViewer, menuViewer.getPage());
    }

    @NotNull
    public MobStylesEditor getEditorMobStyles() {
        if (this.mobStylesEditor == null) {
            this.mobStylesEditor = new MobStylesEditor((AMA)this.plugin, (MobConfig)((Object)this.object));
        }
        return this.mobStylesEditor;
    }

    private static class EquipmentEditor
    extends Menu<AMA> {
        private final MobConfig mob;
        private final Map<EquipmentSlot, Integer> equipmentSlots;

        public EquipmentEditor(@NotNull MobConfig mobConfig) {
            super((NexPlugin)((AMA)mobConfig.plugin()), "Arena Mob Editor", 9);
            this.mob = mobConfig;
            this.equipmentSlots = new HashMap<EquipmentSlot, Integer>();
            this.equipmentSlots.put(EquipmentSlot.FEET, 0);
            this.equipmentSlots.put(EquipmentSlot.LEGS, 1);
            this.equipmentSlots.put(EquipmentSlot.CHEST, 2);
            this.equipmentSlots.put(EquipmentSlot.HEAD, 3);
            this.equipmentSlots.put(EquipmentSlot.HAND, 4);
            this.equipmentSlots.put(EquipmentSlot.OFF_HAND, 5);
        }

        public boolean isPersistent() {
            return false;
        }

        @Nullable
        private EquipmentSlot getTypeBySlot(int n) {
            return this.equipmentSlots.entrySet().stream().filter(entry -> (Integer)entry.getValue() == n).findFirst().map(Map.Entry::getKey).orElse(null);
        }

        private void saveEquipment(@NotNull Player player, @NotNull Inventory inventory) {
            this.equipmentSlots.forEach((equipmentSlot, n) -> this.mob.setEquipment((EquipmentSlot)equipmentSlot, inventory.getItem(n.intValue())));
            this.mob.save();
        }

        public void onReady(@NotNull MenuViewer menuViewer, @NotNull Inventory inventory) {
            super.onReady(menuViewer, inventory);
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                inventory.setItem(this.equipmentSlots.getOrDefault(equipmentSlot, 0).intValue(), this.mob.getEquipment(equipmentSlot));
            }
        }

        public void onClick(@NotNull MenuViewer menuViewer, @Nullable ItemStack itemStack, @NotNull Menu.SlotType slotType, int n, @NotNull InventoryClickEvent inventoryClickEvent) {
            super.onClick(menuViewer, itemStack, slotType, n, inventoryClickEvent);
            inventoryClickEvent.setCancelled(slotType != Menu.SlotType.PLAYER && slotType != Menu.SlotType.PLAYER_EMPTY && this.getTypeBySlot(inventoryClickEvent.getRawSlot()) == null);
        }

        public void onDrag(@NotNull MenuViewer menuViewer, @NotNull InventoryDragEvent inventoryDragEvent) {
            super.onDrag(menuViewer, inventoryDragEvent);
            inventoryDragEvent.setCancelled(inventoryDragEvent.getRawSlots().stream().anyMatch(n -> this.getTypeBySlot((int)n) == null));
        }

        public void onClose(@NotNull MenuViewer menuViewer, @NotNull InventoryCloseEvent inventoryCloseEvent) {
            this.saveEquipment(menuViewer.getPlayer(), inventoryCloseEvent.getInventory());
            this.mob.getEditor().openNextTick(menuViewer, 1);
            super.onClose(menuViewer, inventoryCloseEvent);
        }
    }
}

