/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.NexPlugin;
import su.nexmedia.engine.api.menu.AutoPaged;
import su.nexmedia.engine.api.menu.click.ItemClick;
import su.nexmedia.engine.api.menu.impl.EditorMenu;
import su.nexmedia.engine.api.menu.impl.MenuOptions;
import su.nexmedia.engine.api.menu.impl.MenuViewer;
import su.nexmedia.engine.editor.EditorManager;
import su.nexmedia.engine.utils.ItemUtil;
import su.nightexpress.ama.AMA;
import su.nightexpress.ama.config.Lang;
import su.nightexpress.ama.editor.EditorLocales;
import su.nightexpress.ama.mob.config.MobConfig;
import su.nightexpress.ama.mob.style.MobStyleType;

public class MobStylesEditor
extends EditorMenu<AMA, MobConfig>
implements AutoPaged<MobStyleType> {
    public MobStylesEditor(@NotNull AMA aMA, @NotNull MobConfig mobConfig) {
        super((NexPlugin)aMA, (Object)mobConfig, "Arena Mob Editor", 45);
        this.addReturn(new int[]{39}).setClick((menuViewer, inventoryClickEvent) -> mobConfig.getEditor().openNextTick(menuViewer, 1));
        this.addNextPage(new int[]{44});
        this.addPreviousPage(new int[]{36});
    }

    public void onPrepare(@NotNull MenuViewer menuViewer, @NotNull MenuOptions menuOptions) {
        super.onPrepare(menuViewer, menuOptions);
        this.getItemsForPage(menuViewer).forEach(arg_0 -> ((MobStylesEditor)this).addItem(arg_0));
    }

    public int[] getObjectSlots() {
        return IntStream.range(0, 36).toArray();
    }

    @NotNull
    public List<MobStyleType> getObjects(@NotNull Player player) {
        return new ArrayList<MobStyleType>(Arrays.asList(MobStyleType.get(((MobConfig)((Object)this.object)).getEntityType())));
    }

    @NotNull
    public ItemStack getObjectStack(@NotNull Player player, @NotNull MobStyleType mobStyleType) {
        ItemStack itemStack = new ItemStack(Material.NAME_TAG);
        ItemUtil.mapMeta((ItemStack)itemStack, itemMeta -> {
            itemMeta.setDisplayName(EditorLocales.MOB_STYLE_OBJECT.getLocalizedName());
            itemMeta.setLore(EditorLocales.MOB_STYLE_OBJECT.getLocalizedLore());
            itemMeta.addItemFlags(ItemFlag.values());
            ItemUtil.replace((ItemMeta)itemMeta, string -> string.replace("%mob_style_type%", ((AMA)this.plugin).getLangManager().getEnum((Enum)mobStyleType)).replace("%mob_style_value%", ((MobConfig)((Object)((Object)((Object)this.object)))).getStyle(mobStyleType)));
        });
        return itemStack;
    }

    @NotNull
    public ItemClick getObjectClick(@NotNull MobStyleType mobStyleType) {
        return (menuViewer, inventoryClickEvent) -> {
            if (inventoryClickEvent.isLeftClick()) {
                EditorManager.suggestValues((Player)menuViewer.getPlayer(), Stream.of(mobStyleType.getWrapper().getWriter().values()).map(String::valueOf).toList(), (boolean)true);
                this.handleInput(menuViewer, Lang.EDITOR_MOB_ENTER_STYLE, inputWrapper -> {
                    ((MobConfig)((Object)((Object)((Object)this.object)))).addStyle(mobStyleType, inputWrapper.getTextRaw());
                    ((MobConfig)((Object)((Object)((Object)this.object)))).save();
                    return true;
                });
            } else if (inventoryClickEvent.isRightClick()) {
                ((MobConfig)((Object)((Object)this.object))).removeStyle(mobStyleType);
                this.openNextTick(menuViewer, menuViewer.getPage());
            }
        };
    }
}

