/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.style;

import java.util.stream.Stream;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import su.nightexpress.ama.mob.style.MobStyleWrapper;

public enum MobStyleType {
    BABY(MobStyleWrapper.BABY),
    SHEEP_COLOR(MobStyleWrapper.SHEEP_COLOR),
    HORSE_COLOR(MobStyleWrapper.HORSE_COLOR),
    HORSE_STYLE(MobStyleWrapper.HORSE_STYLE),
    FOX_TYPE(MobStyleWrapper.FOX_TYPE),
    CREEPER_CHARGE(MobStyleWrapper.CREEPER_CHARGE),
    SLIME_SIZE(MobStyleWrapper.SLIME_SIZE),
    LLAMA_COLOR(MobStyleWrapper.LLAMA_COLOR),
    PARROT_VARIANT(MobStyleWrapper.PARROT_VARIANT),
    RABBIT_TYPE(MobStyleWrapper.RABBIT_TYPE),
    CAT_TYPE(MobStyleWrapper.CAT_TYPE),
    MUSHROOM_VARIANT(MobStyleWrapper.MUSHROOM_VARIANT),
    VILLAGER_PROFESSION(MobStyleWrapper.VILLAGER),
    ZOMBIE_VILLAGER_PROFESSION(MobStyleWrapper.VILLAGER_ZOMBIE);

    private final MobStyleWrapper<?, ?> wrapper;

    private MobStyleType(MobStyleWrapper<?, ?> mobStyleWrapper) {
        this.wrapper = mobStyleWrapper;
    }

    @NotNull
    public MobStyleWrapper<?, ?> getWrapper() {
        return this.wrapper;
    }

    public boolean isApplicable(@NotNull EntityType entityType) {
        Class clazz = entityType.getEntityClass();
        if (clazz == null) {
            return false;
        }
        return this.getWrapper().getEntityClass().isAssignableFrom(clazz);
    }

    @NotNull
    public static MobStyleType[] get(@NotNull EntityType entityType) {
        return (MobStyleType[])Stream.of(MobStyleType.values()).filter(mobStyleType -> mobStyleType.isApplicable(entityType)).toArray(MobStyleType[]::new);
    }
}

