/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.mob.style;

import java.util.stream.IntStream;
import org.bukkit.DyeColor;
import org.bukkit.entity.Ageable;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Creeper;
import org.bukkit.entity.Fox;
import org.bukkit.entity.Horse;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Llama;
import org.bukkit.entity.MushroomCow;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Phantom;
import org.bukkit.entity.Rabbit;
import org.bukkit.entity.Sheep;
import org.bukkit.entity.Slime;
import org.bukkit.entity.Villager;
import org.bukkit.entity.ZombieVillager;
import org.jetbrains.annotations.NotNull;
import su.nexmedia.engine.utils.StringUtil;
import su.nightexpress.ama.mob.style.MobStyleWriter;

public class MobStyleWrapper<E, T> {
    private final Class<E> entityClass;
    private final MobStyleWriter<E, T> writer;
    public static final MobStyleWrapper<Ageable, Boolean> BABY = new MobStyleWrapper<Ageable, Boolean>(Ageable.class, new MobStyleWriter.WriterBoolean<Ageable>(){

        @Override
        public void apply(@NotNull Ageable ageable, @NotNull Boolean bl) {
            if (bl.booleanValue()) {
                ageable.setBaby();
            } else {
                ageable.setAdult();
            }
        }

        @Override
        public boolean alreadyHas(@NotNull Ageable ageable, @NotNull Boolean bl) {
            return !ageable.isAdult() == bl;
        }
    });
    public static final MobStyleWrapper<Sheep, DyeColor> SHEEP_COLOR = new MobStyleWrapper<Sheep, DyeColor>(Sheep.class, new MobStyleWriter.WriterEnum<Sheep, DyeColor>(){

        @Override
        @NotNull
        public Class<DyeColor> getEnumClass() {
            return DyeColor.class;
        }

        @Override
        public void apply(@NotNull Sheep sheep, @NotNull DyeColor dyeColor) {
            sheep.setColor(dyeColor);
        }

        @Override
        public boolean alreadyHas(@NotNull Sheep sheep, @NotNull DyeColor dyeColor) {
            return sheep.getColor() == dyeColor;
        }
    });
    public static final MobStyleWrapper<Horse, Horse.Color> HORSE_COLOR = new MobStyleWrapper<Horse, Horse.Color>(Horse.class, new MobStyleWriter.WriterEnum<Horse, Horse.Color>(){

        @Override
        @NotNull
        public Class<Horse.Color> getEnumClass() {
            return Horse.Color.class;
        }

        @Override
        public void apply(@NotNull Horse horse, @NotNull Horse.Color color) {
            horse.setColor(color);
        }

        @Override
        public boolean alreadyHas(@NotNull Horse horse, @NotNull Horse.Color color) {
            return horse.getColor() == color;
        }
    });
    public static final MobStyleWrapper<Horse, Horse.Style> HORSE_STYLE = new MobStyleWrapper<Horse, Horse.Style>(Horse.class, new MobStyleWriter.WriterEnum<Horse, Horse.Style>(){

        @Override
        @NotNull
        public Class<Horse.Style> getEnumClass() {
            return Horse.Style.class;
        }

        @Override
        public void apply(@NotNull Horse horse, @NotNull Horse.Style style) {
            horse.setStyle(style);
        }

        @Override
        public boolean alreadyHas(@NotNull Horse horse, @NotNull Horse.Style style) {
            return horse.getStyle() == style;
        }
    });
    public static final MobStyleWrapper<Fox, Fox.Type> FOX_TYPE = new MobStyleWrapper<Fox, Fox.Type>(Fox.class, new MobStyleWriter.WriterEnum<Fox, Fox.Type>(){

        @Override
        @NotNull
        public Class<Fox.Type> getEnumClass() {
            return Fox.Type.class;
        }

        @Override
        public void apply(@NotNull Fox fox, @NotNull Fox.Type type) {
            fox.setFoxType(type);
        }

        @Override
        public boolean alreadyHas(@NotNull Fox fox, @NotNull Fox.Type type) {
            return fox.getFoxType() == type;
        }
    });
    public static final MobStyleWrapper<Creeper, Boolean> CREEPER_CHARGE = new MobStyleWrapper<Creeper, Boolean>(Creeper.class, new MobStyleWriter.WriterBoolean<Creeper>(){

        @Override
        public void apply(@NotNull Creeper creeper, @NotNull Boolean bl) {
            creeper.setPowered(bl.booleanValue());
        }

        @Override
        public boolean alreadyHas(@NotNull Creeper creeper, @NotNull Boolean bl) {
            return creeper.isPowered() == bl.booleanValue();
        }
    });
    public static final MobStyleWrapper<Slime, Integer> SLIME_SIZE = new MobStyleWrapper<Slime, Integer>(Slime.class, new MobStyleWriter<Slime, Integer>(){

        @Override
        @NotNull
        public Integer parse(@NotNull String string) {
            return StringUtil.getInteger((String)string, (int)1, (boolean)false);
        }

        @NotNull
        public Integer[] values() {
            return (Integer[])IntStream.range(1, 16).boxed().toArray(Integer[]::new);
        }

        @Override
        public void apply(@NotNull Slime slime, @NotNull Integer n) {
            slime.setSize(n.intValue());
        }

        @Override
        public boolean alreadyHas(@NotNull Slime slime, @NotNull Integer n) {
            return slime.getSize() == n.intValue();
        }
    });
    public static final MobStyleWrapper<Phantom, Integer> PHANTOM_SIZE = new MobStyleWrapper<Phantom, Integer>(Phantom.class, new MobStyleWriter<Phantom, Integer>(){

        @Override
        @NotNull
        public Integer parse(@NotNull String string) {
            return StringUtil.getInteger((String)string, (int)1, (boolean)false);
        }

        @NotNull
        public Integer[] values() {
            return (Integer[])IntStream.range(1, 16).boxed().toArray(Integer[]::new);
        }

        @Override
        public void apply(@NotNull Phantom phantom, @NotNull Integer n) {
            phantom.setSize(n.intValue());
        }

        @Override
        public boolean alreadyHas(@NotNull Phantom phantom, @NotNull Integer n) {
            return phantom.getSize() == n.intValue();
        }
    });
    public static final MobStyleWrapper<Llama, Llama.Color> LLAMA_COLOR = new MobStyleWrapper<Llama, Llama.Color>(Llama.class, new MobStyleWriter.WriterEnum<Llama, Llama.Color>(){

        @Override
        @NotNull
        public Class<Llama.Color> getEnumClass() {
            return Llama.Color.class;
        }

        @Override
        public void apply(@NotNull Llama llama, @NotNull Llama.Color color) {
            llama.setColor(color);
        }

        @Override
        public boolean alreadyHas(@NotNull Llama llama, @NotNull Llama.Color color) {
            return llama.getColor() == color;
        }
    });
    public static final MobStyleWrapper<Parrot, Parrot.Variant> PARROT_VARIANT = new MobStyleWrapper<Parrot, Parrot.Variant>(Parrot.class, new MobStyleWriter.WriterEnum<Parrot, Parrot.Variant>(){

        @Override
        @NotNull
        public Class<Parrot.Variant> getEnumClass() {
            return Parrot.Variant.class;
        }

        @Override
        public void apply(@NotNull Parrot parrot, @NotNull Parrot.Variant variant) {
            parrot.setVariant(variant);
        }

        @Override
        public boolean alreadyHas(@NotNull Parrot parrot, @NotNull Parrot.Variant variant) {
            return parrot.getVariant() == variant;
        }
    });
    public static final MobStyleWrapper<Rabbit, Rabbit.Type> RABBIT_TYPE = new MobStyleWrapper<Rabbit, Rabbit.Type>(Rabbit.class, new MobStyleWriter.WriterEnum<Rabbit, Rabbit.Type>(){

        @Override
        @NotNull
        public Class<Rabbit.Type> getEnumClass() {
            return Rabbit.Type.class;
        }

        @Override
        public void apply(@NotNull Rabbit rabbit, @NotNull Rabbit.Type type) {
            rabbit.setRabbitType(type);
        }

        @Override
        public boolean alreadyHas(@NotNull Rabbit rabbit, @NotNull Rabbit.Type type) {
            return rabbit.getRabbitType() == type;
        }
    });
    public static final MobStyleWrapper<Cat, Cat.Type> CAT_TYPE = new MobStyleWrapper<Cat, Cat.Type>(Cat.class, new MobStyleWriter.WriterEnum<Cat, Cat.Type>(){

        @Override
        @NotNull
        public Class<Cat.Type> getEnumClass() {
            return Cat.Type.class;
        }

        @Override
        public void apply(@NotNull Cat cat, @NotNull Cat.Type type) {
            cat.setCatType(type);
        }

        @Override
        public boolean alreadyHas(@NotNull Cat cat, @NotNull Cat.Type type) {
            return cat.getCatType() == type;
        }
    });
    public static final MobStyleWrapper<MushroomCow, MushroomCow.Variant> MUSHROOM_VARIANT = new MobStyleWrapper<MushroomCow, MushroomCow.Variant>(MushroomCow.class, new MobStyleWriter.WriterEnum<MushroomCow, MushroomCow.Variant>(){

        @Override
        @NotNull
        public Class<MushroomCow.Variant> getEnumClass() {
            return MushroomCow.Variant.class;
        }

        @Override
        public void apply(@NotNull MushroomCow mushroomCow, @NotNull MushroomCow.Variant variant) {
            mushroomCow.setVariant(variant);
        }

        @Override
        public boolean alreadyHas(@NotNull MushroomCow mushroomCow, @NotNull MushroomCow.Variant variant) {
            return mushroomCow.getVariant() == variant;
        }
    });
    public static final MobStyleWrapper<Villager, Villager.Profession> VILLAGER = new MobStyleWrapper<Villager, Villager.Profession>(Villager.class, new MobStyleWriter.WriterEnum<Villager, Villager.Profession>(){

        @Override
        @NotNull
        public Class<Villager.Profession> getEnumClass() {
            return Villager.Profession.class;
        }

        @Override
        public void apply(@NotNull Villager villager, @NotNull Villager.Profession profession) {
            villager.setProfession(profession);
        }

        @Override
        public boolean alreadyHas(@NotNull Villager villager, @NotNull Villager.Profession profession) {
            return villager.getProfession() == profession;
        }
    });
    public static final MobStyleWrapper<ZombieVillager, Villager.Profession> VILLAGER_ZOMBIE = new MobStyleWrapper<ZombieVillager, Villager.Profession>(ZombieVillager.class, new MobStyleWriter.WriterEnum<ZombieVillager, Villager.Profession>(){

        @Override
        @NotNull
        public Class<Villager.Profession> getEnumClass() {
            return Villager.Profession.class;
        }

        @Override
        public void apply(@NotNull ZombieVillager zombieVillager, @NotNull Villager.Profession profession) {
            zombieVillager.setVillagerProfession(profession);
        }

        @Override
        public boolean alreadyHas(@NotNull ZombieVillager zombieVillager, @NotNull Villager.Profession profession) {
            return zombieVillager.getVillagerProfession() == profession;
        }
    });

    public MobStyleWrapper(@NotNull Class<E> clazz, @NotNull MobStyleWriter<E, T> mobStyleWriter) {
        this.entityClass = clazz;
        this.writer = mobStyleWriter;
    }

    @NotNull
    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    @NotNull
    public MobStyleWriter<E, T> getWriter() {
        return this.writer;
    }

    public boolean canBeApplied(@NotNull LivingEntity livingEntity) {
        return this.entityClass.isInstance(livingEntity);
    }

    public final boolean apply(@NotNull LivingEntity livingEntity, @NotNull String string) {
        if (!this.canBeApplied(livingEntity)) {
            return false;
        }
        T t = this.writer.parse(string);
        if (t == null) {
            return false;
        }
        this.writer.apply(livingEntity, t);
        return true;
    }

    public final boolean alreadyHas(@NotNull LivingEntity livingEntity, @NotNull String string) {
        if (!this.canBeApplied(livingEntity)) {
            return false;
        }
        T t = this.writer.parse(string);
        if (t == null) {
            return false;
        }
        return this.writer.alreadyHas(livingEntity, t);
    }
}

