/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.nms.v1_18_R2;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_18_R2.CraftWorld;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityInjector {
    private static final Map<EntityType, EntityTypes<?>> TYPES = new HashMap();

    public static void setup() {
        for (EntityType entityType : EntityType.values()) {
            if (!entityType.isAlive() || !entityType.isSpawnable()) continue;
            EntityTypes entityTypes = switch (entityType) {
                case EntityType.ELDER_GUARDIAN -> EntityTypes.t;
                case EntityType.WITHER_SKELETON -> EntityTypes.ba;
                case EntityType.STRAY -> EntityTypes.aK;
                case EntityType.HUSK -> EntityTypes.N;
                case EntityType.ZOMBIE_VILLAGER -> EntityTypes.bg;
                case EntityType.SKELETON_HORSE -> EntityTypes.aC;
                case EntityType.ZOMBIE_HORSE -> EntityTypes.bf;
                case EntityType.DONKEY -> EntityTypes.q;
                case EntityType.MULE -> EntityTypes.ag;
                case EntityType.EVOKER -> EntityTypes.y;
                case EntityType.VEX -> EntityTypes.aU;
                case EntityType.VINDICATOR -> EntityTypes.aW;
                case EntityType.ILLUSIONER -> EntityTypes.O;
                case EntityType.CREEPER -> EntityTypes.o;
                case EntityType.SKELETON -> EntityTypes.aB;
                case EntityType.SPIDER -> EntityTypes.aI;
                case EntityType.GIANT -> EntityTypes.G;
                case EntityType.ZOMBIE -> EntityTypes.be;
                case EntityType.SLIME -> EntityTypes.aD;
                case EntityType.GHAST -> EntityTypes.F;
                case EntityType.ZOMBIFIED_PIGLIN -> EntityTypes.bh;
                case EntityType.ENDERMAN -> EntityTypes.w;
                case EntityType.CAVE_SPIDER -> EntityTypes.k;
                case EntityType.SILVERFISH -> EntityTypes.aA;
                case EntityType.BLAZE -> EntityTypes.h;
                case EntityType.MAGMA_CUBE -> EntityTypes.X;
                case EntityType.ENDER_DRAGON -> EntityTypes.v;
                case EntityType.WITHER -> EntityTypes.aZ;
                case EntityType.BAT -> EntityTypes.f;
                case EntityType.WITCH -> EntityTypes.aY;
                case EntityType.ENDERMITE -> EntityTypes.x;
                case EntityType.GUARDIAN -> EntityTypes.K;
                case EntityType.SHULKER -> EntityTypes.ay;
                case EntityType.PIG -> EntityTypes.an;
                case EntityType.SHEEP -> EntityTypes.ax;
                case EntityType.COW -> EntityTypes.n;
                case EntityType.CHICKEN -> EntityTypes.l;
                case EntityType.SQUID -> EntityTypes.aJ;
                case EntityType.WOLF -> EntityTypes.bc;
                case EntityType.MUSHROOM_COW -> EntityTypes.ah;
                case EntityType.SNOWMAN -> EntityTypes.aF;
                case EntityType.OCELOT -> EntityTypes.ai;
                case EntityType.IRON_GOLEM -> EntityTypes.P;
                case EntityType.HORSE -> EntityTypes.M;
                case EntityType.RABBIT -> EntityTypes.au;
                case EntityType.POLAR_BEAR -> EntityTypes.ar;
                case EntityType.LLAMA -> EntityTypes.V;
                case EntityType.PARROT -> EntityTypes.al;
                case EntityType.VILLAGER -> EntityTypes.aV;
                case EntityType.TURTLE -> EntityTypes.aT;
                case EntityType.PHANTOM -> EntityTypes.am;
                case EntityType.DROWNED -> EntityTypes.s;
                case EntityType.CAT -> EntityTypes.j;
                case EntityType.PANDA -> EntityTypes.ak;
                case EntityType.PILLAGER -> EntityTypes.aq;
                case EntityType.RAVAGER -> EntityTypes.av;
                case EntityType.TRADER_LLAMA -> EntityTypes.aR;
                case EntityType.WANDERING_TRADER -> EntityTypes.aX;
                case EntityType.FOX -> EntityTypes.E;
                case EntityType.BEE -> EntityTypes.g;
                case EntityType.HOGLIN -> EntityTypes.L;
                case EntityType.PIGLIN -> EntityTypes.ao;
                case EntityType.STRIDER -> EntityTypes.aL;
                case EntityType.ZOGLIN -> EntityTypes.bd;
                case EntityType.PIGLIN_BRUTE -> EntityTypes.ap;
                case EntityType.AXOLOTL -> EntityTypes.e;
                case EntityType.GLOW_SQUID -> EntityTypes.I;
                case EntityType.GOAT -> EntityTypes.J;
                default -> null;
            };
            TYPES.put(entityType, entityTypes);
        }
    }

    @Nullable
    public static Entity spawnEntity(@NotNull EntityType entityType, @NotNull Location location) {
        EnumMobSpawn enumMobSpawn;
        BlockPosition blockPosition;
        EntityTypes<?> entityTypes = TYPES.get(entityType);
        if (entityTypes == null) {
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        EntityInsentient entityInsentient = (EntityInsentient)entityTypes.b(worldServer, null, null, null, blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), enumMobSpawn = EnumMobSpawn.n, false, false);
        if (entityInsentient != null) {
            worldServer.addFreshEntity((Entity)entityInsentient, null);
        }
        return entityInsentient;
    }
}

