/*
 * Decompiled with CFR 0.152.
 */
package su.nightexpress.ama.nms.v1_19_R3;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPosition;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_19_R3.CraftWorld;
import org.bukkit.entity.EntityType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityInjector {
    private static final Map<EntityType, EntityTypes<?>> TYPES = new HashMap();

    public static void setup() {
        for (EntityType entityType : EntityType.values()) {
            if (!entityType.isAlive() || !entityType.isSpawnable()) continue;
            EntityTypes entityTypes = switch (entityType) {
                case EntityType.ELDER_GUARDIAN -> EntityTypes.A;
                case EntityType.WITHER_SKELETON -> EntityTypes.bl;
                case EntityType.STRAY -> EntityTypes.aU;
                case EntityType.HUSK -> EntityTypes.Z;
                case EntityType.ZOMBIE_VILLAGER -> EntityTypes.br;
                case EntityType.SKELETON_HORSE -> EntityTypes.aK;
                case EntityType.ZOMBIE_HORSE -> EntityTypes.bq;
                case EntityType.DONKEY -> EntityTypes.w;
                case EntityType.MULE -> EntityTypes.ap;
                case EntityType.EVOKER -> EntityTypes.G;
                case EntityType.VEX -> EntityTypes.be;
                case EntityType.VINDICATOR -> EntityTypes.bg;
                case EntityType.ILLUSIONER -> EntityTypes.aa;
                case EntityType.CREEPER -> EntityTypes.u;
                case EntityType.SKELETON -> EntityTypes.aJ;
                case EntityType.SPIDER -> EntityTypes.aS;
                case EntityType.GIANT -> EntityTypes.R;
                case EntityType.ZOMBIE -> EntityTypes.bp;
                case EntityType.SLIME -> EntityTypes.aL;
                case EntityType.GHAST -> EntityTypes.Q;
                case EntityType.ZOMBIFIED_PIGLIN -> EntityTypes.bs;
                case EntityType.ENDERMAN -> EntityTypes.E;
                case EntityType.CAVE_SPIDER -> EntityTypes.n;
                case EntityType.SILVERFISH -> EntityTypes.aI;
                case EntityType.BLAZE -> EntityTypes.i;
                case EntityType.MAGMA_CUBE -> EntityTypes.al;
                case EntityType.ENDER_DRAGON -> EntityTypes.C;
                case EntityType.WITHER -> EntityTypes.bk;
                case EntityType.WITCH -> EntityTypes.bj;
                case EntityType.ENDERMITE -> EntityTypes.F;
                case EntityType.GUARDIAN -> EntityTypes.V;
                case EntityType.SHULKER -> EntityTypes.aG;
                case EntityType.PIG -> EntityTypes.av;
                case EntityType.SHEEP -> EntityTypes.aF;
                case EntityType.COW -> EntityTypes.t;
                case EntityType.CHICKEN -> EntityTypes.q;
                case EntityType.WOLF -> EntityTypes.bn;
                case EntityType.MUSHROOM_COW -> EntityTypes.ao;
                case EntityType.SNOWMAN -> EntityTypes.aO;
                case EntityType.OCELOT -> EntityTypes.aq;
                case EntityType.IRON_GOLEM -> EntityTypes.ac;
                case EntityType.HORSE -> EntityTypes.Y;
                case EntityType.RABBIT -> EntityTypes.aC;
                case EntityType.POLAR_BEAR -> EntityTypes.az;
                case EntityType.LLAMA -> EntityTypes.aj;
                case EntityType.PARROT -> EntityTypes.at;
                case EntityType.VILLAGER -> EntityTypes.bf;
                case EntityType.TURTLE -> EntityTypes.bd;
                case EntityType.PHANTOM -> EntityTypes.au;
                case EntityType.DROWNED -> EntityTypes.y;
                case EntityType.CAT -> EntityTypes.m;
                case EntityType.PANDA -> EntityTypes.as;
                case EntityType.PILLAGER -> EntityTypes.ay;
                case EntityType.RAVAGER -> EntityTypes.aD;
                case EntityType.TRADER_LLAMA -> EntityTypes.ba;
                case EntityType.WANDERING_TRADER -> EntityTypes.bh;
                case EntityType.FOX -> EntityTypes.N;
                case EntityType.BEE -> EntityTypes.h;
                case EntityType.HOGLIN -> EntityTypes.W;
                case EntityType.PIGLIN -> EntityTypes.aw;
                case EntityType.STRIDER -> EntityTypes.aV;
                case EntityType.ZOGLIN -> EntityTypes.bo;
                case EntityType.PIGLIN_BRUTE -> EntityTypes.ax;
                case EntityType.AXOLOTL -> EntityTypes.f;
                case EntityType.GOAT -> EntityTypes.U;
                case EntityType.WARDEN -> EntityTypes.bi;
                case EntityType.FROG -> EntityTypes.O;
                case EntityType.ALLAY -> EntityTypes.b;
                default -> null;
            };
            TYPES.put(entityType, entityTypes);
        }
    }

    @Nullable
    public static Entity spawnEntity(@NotNull EntityType entityType, @NotNull Location location) {
        EnumMobSpawn enumMobSpawn;
        BlockPosition blockPosition;
        EntityTypes<?> entityTypes = TYPES.get(entityType);
        if (entityTypes == null) {
            return null;
        }
        World world = location.getWorld();
        if (world == null) {
            return null;
        }
        WorldServer worldServer = ((CraftWorld)world).getHandle();
        EntityInsentient entityInsentient = (EntityInsentient)entityTypes.b(worldServer, null, null, blockPosition = new BlockPosition(location.getBlockX(), location.getBlockY(), location.getBlockZ()), enumMobSpawn = EnumMobSpawn.n, false, false);
        if (entityInsentient != null) {
            worldServer.addFreshEntity((Entity)entityInsentient, null);
        }
        return entityInsentient;
    }
}

